/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfigReference;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBookRegistry;
import org.cyclops.cyclopscore.infobook.InfoBookRegistry;
import org.cyclops.cyclopscore.init.IObjectReference;
import org.cyclops.cyclopscore.init.IRegistry;
import org.cyclops.cyclopscore.init.ItemCreativeTab;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.init.ModBaseVersionable;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.item.BucketRegistry;
import org.cyclops.cyclopscore.item.IBucketRegistry;
import org.cyclops.cyclopscore.modcompat.IModCompat;
import org.cyclops.cyclopscore.modcompat.ModCompatLoader;
import org.cyclops.cyclopscore.persist.world.GlobalCounters;
import org.cyclops.cyclopscore.persist.world.WorldStorage;
import org.cyclops.cyclopscore.proxy.ICommonProxy;
import org.cyclops.cyclopscore.recipe.custom.SuperRecipeRegistry;
import org.cyclops.cyclopscore.recipe.custom.api.ISuperRecipeRegistry;
import org.cyclops.cyclopscore.world.gen.IRetroGenRegistry;
import org.cyclops.cyclopscore.world.gen.RetroGenRegistry;
import org.cyclops.evilcraft.Advancements;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.EvilCraftSoundEvents;
import org.cyclops.evilcraft.ExtendedRecipeHandler;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.api.broom.BroomModifiers;
import org.cyclops.evilcraft.api.broom.IBroomModifierRegistry;
import org.cyclops.evilcraft.api.broom.IBroomPartRegistry;
import org.cyclops.evilcraft.api.degradation.IDegradationRegistry;
import org.cyclops.evilcraft.api.tileentity.bloodchest.IBloodChestRepairActionRegistry;
import org.cyclops.evilcraft.api.tileentity.purifier.IPurifierActionRegistry;
import org.cyclops.evilcraft.block.EnvironmentalAccumulatorConfig;
import org.cyclops.evilcraft.client.gui.container.GuiMainMenuEvilifier;
import org.cyclops.evilcraft.core.broom.BroomModifierRegistry;
import org.cyclops.evilcraft.core.broom.BroomPartRegistry;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.core.degradation.DegradationRegistry;
import org.cyclops.evilcraft.core.fluid.WorldSharedTank;
import org.cyclops.evilcraft.infobook.OriginsOfDarknessBook;
import org.cyclops.evilcraft.item.DarkGemConfig;
import org.cyclops.evilcraft.modcompat.baubles.BaublesModCompat;
import org.cyclops.evilcraft.tileentity.tickaction.bloodchest.BloodChestRepairActionRegistry;
import org.cyclops.evilcraft.tileentity.tickaction.purifier.PurifierActionRegistry;
import org.cyclops.evilcraft.world.gen.DarkTempleGenerator;
import org.cyclops.evilcraft.world.gen.EvilDungeonGenerator;
import org.cyclops.evilcraft.world.gen.OreGenerator;
import org.cyclops.evilcraft.world.gen.nbt.DarkTempleData;

@Mod(modid="evilcraft", name="EvilCraft", useMetadata=true, version="0.10.58", dependencies="required-after:forge@[14.23.1.2555,);required-after:cyclopscore@[0.11.6,);", guiFactory="org.cyclops.evilcraft.GuiConfigOverview$ExtendedConfigGuiFactory", certificateFingerprint="bd0353b3e8a2810d60dd584e256e364bc3bedd44", acceptedMinecraftVersions="[1.12.2]")
public class EvilCraft
extends ModBaseVersionable {
    @SidedProxy(clientSide="org.cyclops.evilcraft.proxy.ClientProxy", serverSide="org.cyclops.evilcraft.proxy.CommonProxy")
    public static ICommonProxy proxy;
    @Mod.Instance(value="evilcraft")
    public static EvilCraft _instance;
    public static GlobalCounters globalCounters;
    public static DarkTempleData darkTempleData;

    public EvilCraft() {
        super("evilcraft", "EvilCraft", "0.10.58");
        this.registerWorldStorage(new WorldSharedTank.TankData((ModBase)this));
        globalCounters = new GlobalCounters((ModBase)this);
        this.registerWorldStorage((WorldStorage)globalCounters);
        darkTempleData = new DarkTempleData((ModBase)this);
        this.registerWorldStorage(darkTempleData);
    }

    protected void loadModCompats(ModCompatLoader modCompatLoader) {
        modCompatLoader.addModCompat((IModCompat)new BaublesModCompat());
    }

    protected RecipeHandler constructRecipeHandler() {
        return new ExtendedRecipeHandler((ModBase)this, "shaped.xml", "shapeless.xml", "smelting.xml", "bloodinfuser.xml", "bloodinfuser_convenience.xml", "environmentalaccumulator.xml", "broomparts.xml");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.getRegistryManager().addRegistry(IDegradationRegistry.class, (IRegistry)new DegradationRegistry());
        this.getRegistryManager().addRegistry(ISuperRecipeRegistry.class, (IRegistry)new SuperRecipeRegistry((ModBase)this));
        this.getRegistryManager().addRegistry(IBloodChestRepairActionRegistry.class, (IRegistry)new BloodChestRepairActionRegistry());
        this.getRegistryManager().addRegistry(IRetroGenRegistry.class, (IRegistry)new RetroGenRegistry((ModBase)this));
        this.getRegistryManager().addRegistry(IBucketRegistry.class, (IRegistry)new BucketRegistry());
        this.getRegistryManager().addRegistry(IBroomPartRegistry.class, (IRegistry)new BroomPartRegistry());
        this.getRegistryManager().addRegistry(IBroomModifierRegistry.class, (IRegistry)new BroomModifierRegistry());
        this.getRegistryManager().addRegistry(IInfoBookRegistry.class, (IRegistry)new InfoBookRegistry());
        this.getRegistryManager().addRegistry(IPurifierActionRegistry.class, (IRegistry)new PurifierActionRegistry());
        BroomParts.init();
        BroomModifiers.init();
        super.preInit(event);
        Advancements.load();
        ((IInfoBookRegistry)this.getRegistryManager().getRegistry(IInfoBookRegistry.class)).registerInfoBook((IInfoBook)OriginsOfDarknessBook.getInstance(), "/assets/evilcraft/info/book.xml");
        if (MinecraftHelpers.isClientSide()) {
            MinecraftForge.EVENT_BUS.register(EvilCraftSoundEvents.class);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        super.init(event);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(), (int)5);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new EvilDungeonGenerator(), (int)2);
        if (Configs.isEnabled(EnvironmentalAccumulatorConfig.class)) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new DarkTempleGenerator(), (int)1);
        }
        if (event.getSide() == Side.CLIENT) {
            GuiMainMenuEvilifier.evilifyMainMenu();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        super.onServerAboutToStart(event);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        super.onServerStarting(event);
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        super.onServerStarted(event);
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        super.onServerStopping(event);
    }

    public CreativeTabs constructDefaultCreativeTab() {
        return new ItemCreativeTab((ModBase)this, (IObjectReference)new ItemConfigReference(DarkGemConfig.class));
    }

    public void onGeneralConfigsRegister(ConfigHandler configHandler) {
        configHandler.add((ExtendedConfig)new GeneralConfig());
        Configs.registerVanillaDictionary();
    }

    public void onMainConfigsRegister(ConfigHandler configHandler) {
        Configs.registerBlocks(configHandler);
    }

    public ICommonProxy getProxy() {
        return proxy;
    }

    public static void clog(String message) {
        EvilCraft.clog(message, Level.INFO);
    }

    public static void clog(String message, Level level) {
        _instance.getLoggerHelper().log(level, message);
    }

    static {
        globalCounters = null;
        darkTempleData = null;
    }
}

