/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items;

import javax.annotation.Nonnull;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemStackHandler
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<fy> {
    protected fi<aip> stacks;

    public ItemStackHandler() {
        this(1);
    }

    public ItemStackHandler(int size) {
        this.stacks = fi.a((int)size, (Object)aip.a);
    }

    public ItemStackHandler(fi<aip> stacks) {
        this.stacks = stacks;
    }

    public void setSize(int size) {
        this.stacks = fi.a((int)size, (Object)aip.a);
    }

    @Override
    public void setStackInSlot(int slot, @Nonnull aip stack) {
        this.validateSlotIndex(slot);
        this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    @Override
    public int getSlots() {
        return this.stacks.size();
    }

    @Override
    @Nonnull
    public aip getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (aip)this.stacks.get(slot);
    }

    @Override
    @Nonnull
    public aip insertItem(int slot, @Nonnull aip stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.b()) {
            return aip.a;
        }
        this.validateSlotIndex(slot);
        aip existing = (aip)this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.b()) {
            if (!ItemHandlerHelper.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl2 = reachedLimit = stack.E() > limit;
        if (!simulate) {
            if (existing.b()) {
                this.stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, limit) : stack));
            } else {
                existing.f(reachedLimit ? limit : stack.E());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, stack.E() - limit) : aip.a;
    }

    @Override
    @Nonnull
    public aip extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return aip.a;
        }
        this.validateSlotIndex(slot);
        aip existing = (aip)this.stacks.get(slot);
        if (existing.b()) {
            return aip.a;
        }
        int toExtract = Math.min(amount, existing.d());
        if (existing.E() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)aip.a);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize(existing, existing.E() - toExtract));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize(existing, toExtract);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    protected int getStackLimit(int slot, @Nonnull aip stack) {
        return Math.min(this.getSlotLimit(slot), stack.d());
    }

    @Override
    public fy serializeNBT() {
        ge nbtTagList = new ge();
        for (int i2 = 0; i2 < this.stacks.size(); ++i2) {
            if (((aip)this.stacks.get(i2)).b()) continue;
            fy itemTag = new fy();
            itemTag.a("Slot", i2);
            ((aip)this.stacks.get(i2)).a(itemTag);
            nbtTagList.a((gn)itemTag);
        }
        fy nbt = new fy();
        nbt.a("Items", (gn)nbtTagList);
        nbt.a("Size", this.stacks.size());
        return nbt;
    }

    @Override
    public void deserializeNBT(fy nbt) {
        this.setSize(nbt.b("Size", 3) ? nbt.h("Size") : this.stacks.size());
        ge tagList = nbt.c("Items", 10);
        for (int i2 = 0; i2 < tagList.c(); ++i2) {
            fy itemTags = tagList.b(i2);
            int slot = itemTags.h("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)new aip(itemTags));
        }
        this.onLoad();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    protected void onLoad() {
    }

    protected void onContentsChanged(int slot) {
    }
}

