/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.gui;

import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.latmod.yabba.net.MessageBarrelConnector;
import com.latmod.yabba.net.MessageOpenBarrelGui;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiBarrelConnector
extends GuiButtonListBase {
    private Collection<MessageBarrelConnector.BarrelInst> barrels;

    public GuiBarrelConnector(ITextComponent t, Collection<MessageBarrelConnector.BarrelInst> c) {
        this.setTitle(t.func_150254_d());
        this.setHasSearchBox(true);
        this.barrels = c;
    }

    public void addButtons(Panel panel) {
        for (final MessageBarrelConnector.BarrelInst inst : this.barrels) {
            final String title2 = inst.title2.func_150254_d();
            SimpleTextButton button = new SimpleTextButton(panel, inst.title.func_150254_d(), inst.icon){

                public void onClicked(MouseButton button) {
                    GuiHelper.playClickSound();
                    new MessageOpenBarrelGui(inst.pos).sendToServer();
                }

                public void addMouseOverText(List<String> list) {
                    super.addMouseOverText(list);
                    if (1.isShiftKeyDown()) {
                        list.add(TextFormatting.DARK_GRAY + "[" + inst.pos.func_177958_n() + ", " + inst.pos.func_177956_o() + ", " + inst.pos.func_177952_p() + "]");
                    }
                }

                public String getTitle() {
                    return 1.isShiftKeyDown() ? title2 : super.getTitle();
                }

                public Icon getIcon() {
                    return 1.isShiftKeyDown() ? inst.icon2 : super.getIcon();
                }
            };
            button.setWidth(Math.max(button.width, this.getStringWidth(title2) + 28));
            panel.add((Widget)button);
        }
    }
}

