/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.VanillaDoubleChestItemHandler;

public class InventoryUtils {
    public static void dropInventoryItems(World world, BlockPos pos, IItemHandler itemHandler) {
        Random random = new Random();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack itemStack = itemHandler.getStackInSlot(i);
            if (itemStack.func_190926_b()) continue;
            float offsetX = random.nextFloat() * 0.8f + 0.1f;
            float offsetY = random.nextFloat() * 0.8f + 0.1f;
            float offsetZ = random.nextFloat() * 0.8f + 0.1f;
            while (!itemStack.func_190926_b()) {
                int stackSize = Math.min(itemStack.func_190916_E(), random.nextInt(21) + 10);
                EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + (double)offsetX, (double)pos.func_177956_o() + (double)offsetY, (double)pos.func_177952_p() + (double)offsetZ, new ItemStack(itemStack.func_77973_b(), stackSize, itemStack.func_77960_j()));
                if (itemStack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d(itemStack.func_77978_p().func_74737_b());
                }
                itemStack.func_190918_g(stackSize);
                float motionScale = 0.05f;
                entityitem.field_70159_w = random.nextGaussian() * (double)motionScale;
                entityitem.field_70181_x = random.nextGaussian() * (double)motionScale + (double)0.2f;
                entityitem.field_70179_y = random.nextGaussian() * (double)motionScale;
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    public static IItemHandler getInventory(World world, BlockPos pos, @Nullable EnumFacing side) {
        IItemHandler ret;
        VanillaDoubleChestItemHandler doubleChest;
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        if (te instanceof TileEntityChest && (doubleChest = VanillaDoubleChestItemHandler.get((TileEntityChest)((TileEntityChest)te))) != VanillaDoubleChestItemHandler.NO_ADJACENT_CHESTS_INSTANCE) {
            return doubleChest;
        }
        IItemHandler iItemHandler = ret = te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) ? (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) : null;
        if (ret == null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            ret = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        }
        return ret;
    }

    public static int transferItems(IItemHandler from, IItemHandler to, int slot, int count) {
        if (from == null || to == null || count == 0) {
            return 0;
        }
        ItemStack toSend = from.extractItem(slot, count, true);
        if (toSend.func_190926_b()) {
            return 0;
        }
        ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)toSend, (boolean)false);
        int inserted = toSend.func_190916_E() - excess.func_190916_E();
        from.extractItem(slot, inserted, false);
        return inserted;
    }

    public static boolean dropItems(World world, BlockPos pos, ItemStack stack) {
        if (!world.field_72995_K) {
            EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
            return world.func_72838_d((Entity)item);
        }
        return true;
    }

    public static int countItems(ItemStack toCount, IItemHandler handler, int max, boolean matchMeta) {
        int count = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            boolean match;
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            boolean bl = match = matchMeta ? stack.func_77969_a(toCount) : stack.func_185136_b(toCount);
            if (match) {
                count += stack.func_190916_E();
            }
            if (count < max) continue;
            return max;
        }
        return count;
    }
}

