/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.util.Iterator;
import java.util.List;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.config.ConfigHandler;
import me.desht.modularrouters.integration.XPCollection;
import me.desht.modularrouters.item.augment.ItemAugment;
import me.desht.modularrouters.item.module.Module;
import me.desht.modularrouters.item.upgrade.ItemUpgrade;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.InventoryUtils;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.ItemHandlerHelper;

public class CompiledVacuumModule
extends CompiledModule {
    public static final String NBT_XP_FLUID_TYPE = "XPFluidType";
    public static final String NBT_AUTO_EJECT = "AutoEject";
    private final boolean fastPickup = this.getAugmentCount(ItemAugment.AugmentType.FAST_PICKUP) > 0;
    private final boolean xpMode = this.getAugmentCount(ItemAugment.AugmentType.XP_VACUUM) > 0;
    private final boolean autoEjecting;
    private final FluidStack xpJuiceStack;
    private TileEntity fluidReceiver = null;
    private EnumFacing fluidReceiverFace = null;
    private int xpBuffered = 0;
    private XPCollection.XPCollectionType xpCollectionType;

    public CompiledVacuumModule(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
        NBTTagCompound compound = stack.func_77978_p();
        this.xpCollectionType = XPCollection.XPCollectionType.values()[compound.func_74762_e(NBT_XP_FLUID_TYPE)];
        this.autoEjecting = compound.func_74767_n(NBT_AUTO_EJECT);
        if (this.xpMode) {
            Fluid xpFluid = this.xpCollectionType.getFluid();
            FluidStack fluidStack = this.xpJuiceStack = xpFluid == null ? null : new FluidStack(xpFluid, 1000);
            if (router != null) {
                this.findFluidReceiver(router);
            }
        } else {
            this.xpJuiceStack = null;
        }
    }

    @Override
    public boolean execute(TileEntityItemRouter router) {
        if (this.xpMode) {
            return this.handleXpMode(router);
        }
        return this.handleItemMode(router);
    }

    @Override
    public void onNeighbourChange(TileEntityItemRouter router) {
        this.findFluidReceiver(router);
    }

    private void findFluidReceiver(TileEntityItemRouter router) {
        if (!this.xpMode || this.xpJuiceStack == null) {
            return;
        }
        this.fluidReceiver = null;
        for (EnumFacing face : EnumFacing.values()) {
            IFluidHandler handler;
            TileEntity te = router.func_145831_w().func_175625_s(router.func_174877_v().func_177972_a(face));
            if (te == null || !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.func_176734_d()) || (handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.func_176734_d())).fill(this.xpJuiceStack, false) <= 0) continue;
            this.fluidReceiver = te;
            this.fluidReceiverFace = face.func_176734_d();
            return;
        }
    }

    private boolean handleItemMode(TileEntityItemRouter router) {
        if (router.isBufferFull()) {
            return false;
        }
        ItemStack bufferStack = router.getBuffer().getStackInSlot(0);
        BlockPos centrePos = this.getTarget().pos;
        int range = this.getRange();
        List items = router.func_145831_w().func_72872_a(EntityItem.class, new AxisAlignedBB(centrePos.func_177982_a(-range, -range, -range), centrePos.func_177982_a(range + 1, range + 1, range + 1)));
        int toPickUp = this.getItemsPerTick(router);
        for (EntityItem item : items) {
            if (item.field_70128_L || !this.fastPickup && item.func_174874_s()) continue;
            ItemStack stackOnGround = item.func_92059_d();
            if (!bufferStack.func_190926_b() && !ItemHandlerHelper.canItemStacksStack((ItemStack)stackOnGround, (ItemStack)bufferStack) || !this.getFilter().test(stackOnGround)) continue;
            int inRouter = bufferStack.func_190916_E();
            int spaceInRouter = this.getRegulationAmount() > 0 ? Math.min(stackOnGround.func_77976_d(), this.getRegulationAmount()) - inRouter : stackOnGround.func_77976_d() - inRouter;
            ItemStack vacuumed = stackOnGround.func_77979_a(Math.min(this.getItemsPerTick(router), spaceInRouter));
            ItemStack excess = router.insertBuffer(vacuumed);
            int remaining = excess == null ? 0 : excess.func_190916_E();
            stackOnGround.func_190917_f(remaining);
            int inserted = vacuumed.func_190916_E() - remaining;
            toPickUp -= inserted;
            if (stackOnGround.func_190926_b()) {
                item.func_70106_y();
            }
            if (inserted > 0 && ConfigHandler.module.vacuumParticles && router.getUpgradeCount(ItemUpgrade.UpgradeType.MUFFLER) < 2) {
                ((WorldServer)router.func_145831_w()).func_180505_a(EnumParticleTypes.EXPLOSION_NORMAL, false, item.field_70165_t, item.field_70163_u + 0.25, item.field_70161_v, 2, 0.0, 0.0, 0.0, 0.0, new int[0]);
            }
            if (toPickUp > 0) continue;
            break;
        }
        return toPickUp < this.getItemsPerTick(router);
    }

    private boolean handleXpMode(TileEntityItemRouter router) {
        EntityXPOrb orb;
        BlockPos centrePos = this.getTarget().pos;
        int range = this.getRange();
        List orbs = router.func_145831_w().func_72872_a(EntityXPOrb.class, new AxisAlignedBB(centrePos.func_177982_a(-range, -range, -range), centrePos.func_177982_a(range + 1, range + 1, range + 1)));
        if (orbs.isEmpty()) {
            return false;
        }
        ItemStack inRouterStack = router.getBufferItemStack();
        int spaceForXp = 0;
        IFluidHandlerItem xpHandler = null;
        if (this.xpCollectionType.isSolid()) {
            if (!inRouterStack.func_190926_b() && !ItemHandlerHelper.canItemStacksStack((ItemStack)inRouterStack, (ItemStack)this.xpCollectionType.getIcon())) {
                return false;
            }
            spaceForXp = (inRouterStack.func_77976_d() - inRouterStack.func_190916_E()) * this.xpCollectionType.getXpRatio();
        } else {
            if (this.fluidReceiver != null && this.fluidReceiver.func_145837_r()) {
                this.findFluidReceiver(router);
            }
            Object object = xpHandler = this.fluidReceiver == null || !this.fluidReceiver.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.fluidReceiverFace) ? FluidUtil.getFluidHandler((ItemStack)inRouterStack) : (IFluidHandler)this.fluidReceiver.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.fluidReceiverFace);
            if (xpHandler == null) {
                return false;
            }
            for (IFluidTankProperties tank : xpHandler.getTankProperties()) {
                if (!tank.canFillFluidType(this.xpJuiceStack) || tank.getContents() != null && tank.getContents().amount != 0 && !tank.getContents().getFluid().getName().equals(this.xpCollectionType.getRegistryName())) continue;
                spaceForXp += (tank.getCapacity() - (tank.getContents() == null ? 0 : tank.getContents().amount)) / this.xpCollectionType.getXpRatio();
            }
        }
        if (spaceForXp == 0) {
            return false;
        }
        int initialSpaceForXp = spaceForXp;
        Iterator iterator = orbs.iterator();
        while (iterator.hasNext() && (orb = (EntityXPOrb)iterator.next()).func_70526_d() <= spaceForXp) {
            if (this.xpCollectionType.isSolid()) {
                this.xpBuffered += orb.func_70526_d();
                if (this.xpBuffered > this.xpCollectionType.getXpRatio()) {
                    ItemStack stack = this.xpCollectionType.getIcon().func_77946_l();
                    stack.func_190920_e(this.xpBuffered / this.xpCollectionType.getXpRatio());
                    ItemStack excess = router.insertBuffer(stack);
                    this.xpBuffered -= stack.func_190916_E() * this.xpCollectionType.getXpRatio();
                    if (!excess.func_190926_b()) {
                        InventoryUtils.dropItems(router.func_145831_w(), router.func_174877_v(), excess);
                    }
                }
            } else {
                FluidStack xpStack = new FluidStack(this.xpJuiceStack.getFluid(), orb.func_70526_d() * this.xpCollectionType.getXpRatio() + this.xpBuffered);
                int filled = xpHandler.fill(xpStack, true);
                if (filled < xpStack.amount) {
                    spaceForXp = 0;
                    this.xpBuffered = xpStack.amount - filled;
                } else {
                    this.xpBuffered = 0;
                }
            }
            spaceForXp -= orb.func_70526_d();
            orb.func_70106_y();
        }
        return initialSpaceForXp - spaceForXp > 0;
    }

    @Override
    public ModuleTarget setupTarget(TileEntityItemRouter router, ItemStack stack) {
        if (router == null) {
            return null;
        }
        Module.RelativeDirection dir = this.getDirection();
        int offset = dir == Module.RelativeDirection.NONE ? 0 : this.getRange() + 1;
        EnumFacing facing = router.getAbsoluteFacing(dir);
        return new ModuleTarget(router.func_145831_w().field_73011_w.getDimension(), router.func_174877_v().func_177967_a(facing, offset), facing);
    }

    public XPCollection.XPCollectionType getXPCollectionType() {
        return this.xpCollectionType;
    }

    public boolean isAutoEjecting() {
        return this.autoEjecting;
    }
}

