/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import javax.annotation.Nullable;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.item.module.FluidModule;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class CompiledFluidModule
extends CompiledModule {
    public static String NBT_MAX_TRANSFER = "MaxTransfer";
    public static String NBT_FLUID_DIRECTION = "FluidDir";
    private final int maxTransfer;
    private final FluidModule.FluidDirection fluidDirection;
    private static final InfiniteWaterHandler infiniteWater = new InfiniteWaterHandler();

    public CompiledFluidModule(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
        NBTTagCompound compound = this.setupNBT(stack);
        this.maxTransfer = compound.func_74762_e(NBT_MAX_TRANSFER);
        this.fluidDirection = FluidModule.FluidDirection.values()[compound.func_74771_c(NBT_FLUID_DIRECTION)];
    }

    @Override
    public boolean execute(TileEntityItemRouter router) {
        boolean transferDone;
        ItemStack containerStack = router.getBufferItemStack();
        if (containerStack.func_190916_E() != 1) {
            return false;
        }
        IFluidHandlerItem routerFluidHandler = FluidUtil.getFluidHandler((ItemStack)containerStack);
        if (routerFluidHandler == null) {
            return false;
        }
        if (this.fluidDirection == FluidModule.FluidDirection.OUT && !this.getFilter().test(containerStack)) {
            return false;
        }
        InfiniteWaterHandler worldFluidHandler = this.fluidDirection == FluidModule.FluidDirection.IN && this.isInfiniteWaterSource(router.func_145831_w(), this.getTarget().pos) ? infiniteWater : FluidUtil.getFluidHandler((World)router.func_145831_w(), (BlockPos)this.getTarget().pos, (EnumFacing)this.getFacing().func_176734_d());
        if (worldFluidHandler == null) {
            if (this.fluidDirection == FluidModule.FluidDirection.OUT && this.tryPourOutFluid((IFluidHandler)routerFluidHandler, router.func_145831_w(), this.getTarget().pos, containerStack)) {
                router.setBufferItemStack(routerFluidHandler.getContainer());
                return true;
            }
            return false;
        }
        if (this.fluidDirection == FluidModule.FluidDirection.IN) {
            Fluid fluid;
            FluidStack fluidStack = worldFluidHandler.getTankProperties()[0].getContents();
            Fluid fluid2 = fluid = fluidStack == null ? null : fluidStack.getFluid();
            if (!this.getFilter().testFluid(fluid)) {
                return false;
            }
        }
        switch (this.fluidDirection) {
            case IN: {
                transferDone = this.doTransfer(router, worldFluidHandler, (IFluidHandler)routerFluidHandler, FluidModule.FluidDirection.IN);
                break;
            }
            case OUT: {
                transferDone = this.doTransfer(router, (IFluidHandler)routerFluidHandler, worldFluidHandler, FluidModule.FluidDirection.OUT);
                break;
            }
            default: {
                return false;
            }
        }
        if (transferDone) {
            router.setBufferItemStack(routerFluidHandler.getContainer());
        }
        return transferDone;
    }

    private boolean isInfiniteWaterSource(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if ((state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            int count = 0;
            for (EnumFacing face : EnumFacing.field_176754_o) {
                IBlockState state2 = world.func_180495_p(pos.func_177972_a(face));
                if (state2.func_177230_c() != Blocks.field_150355_j && state2.func_177230_c() != Blocks.field_150358_i || (Integer)state2.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0 || ++count < 2) continue;
                return true;
            }
        }
        return false;
    }

    private boolean tryPourOutFluid(IFluidHandler routerFluidHandler, World world, BlockPos pos, ItemStack containerStack) {
        FluidStack toPlace = routerFluidHandler.drain(1000, false);
        if (toPlace == null || toPlace.amount < 1000) {
            return false;
        }
        FluidActionResult res = FluidUtil.tryPlaceFluid(null, (World)world, (BlockPos)pos, (ItemStack)containerStack, (FluidStack)toPlace);
        if (res.isSuccess()) {
            routerFluidHandler.drain(1000, true);
            world.func_190524_a(pos, world.func_180495_p(pos).func_177230_c(), pos);
            return true;
        }
        return false;
    }

    private boolean doTransfer(TileEntityItemRouter router, IFluidHandler src, IFluidHandler dest, FluidModule.FluidDirection direction) {
        int amount;
        FluidStack newStack;
        if (this.getRegulationAmount() > 0) {
            if (direction == FluidModule.FluidDirection.IN && this.checkFluidPercent(src) <= this.getRegulationAmount()) {
                return false;
            }
            if (direction == FluidModule.FluidDirection.OUT && this.checkFluidPercent(dest) >= this.getRegulationAmount()) {
                return false;
            }
        }
        if ((newStack = FluidUtil.tryFluidTransfer((IFluidHandler)dest, (IFluidHandler)src, (int)(amount = Math.min(this.maxTransfer, router.getCurrentFluidTransferAllowance(direction))), (boolean)false)) != null && newStack.amount > 0 && (newStack = FluidUtil.tryFluidTransfer((IFluidHandler)dest, (IFluidHandler)src, (int)newStack.amount, (boolean)true)) != null && newStack.amount > 0) {
            router.transferredFluid(newStack.amount, direction);
            return true;
        }
        return false;
    }

    private int checkFluidPercent(IFluidHandler handler) {
        int total = 0;
        int max = 0;
        for (IFluidTankProperties tank : handler.getTankProperties()) {
            max += tank.getCapacity();
            if (tank.getContents() == null) continue;
            total += tank.getContents().amount;
        }
        return total * 100 / max;
    }

    private NBTTagCompound setupNBT(ItemStack stack) {
        NBTTagCompound compound = ModuleHelper.validateNBT(stack);
        if (!compound.func_74764_b(NBT_MAX_TRANSFER)) {
            compound.func_74768_a(NBT_MAX_TRANSFER, 1000);
        }
        if (!compound.func_74764_b(NBT_FLUID_DIRECTION)) {
            compound.func_74774_a(NBT_FLUID_DIRECTION, (byte)FluidModule.FluidDirection.IN.ordinal());
        }
        return compound;
    }

    public FluidModule.FluidDirection getFluidDirection() {
        return this.fluidDirection;
    }

    public int getMaxTransfer() {
        return this.maxTransfer;
    }

    private static class InfiniteWaterHandler
    implements IFluidHandler {
        private static final IFluidTankProperties waterTank = new IFluidTankProperties(){

            @Nullable
            public FluidStack getContents() {
                return new FluidStack(FluidRegistry.WATER, 1000);
            }

            public int getCapacity() {
                return 1000;
            }

            public boolean canFill() {
                return false;
            }

            public boolean canDrain() {
                return true;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return false;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return fluidStack.getFluid() == FluidRegistry.WATER;
            }
        };

        private InfiniteWaterHandler() {
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{waterTank};
        }

        public int fill(FluidStack resource, boolean doFill) {
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return new FluidStack(FluidRegistry.WATER, resource.amount);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return new FluidStack(FluidRegistry.WATER, maxDrain);
        }
    }
}

