/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic;

import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class ModuleTarget {
    public final int dimId;
    public final BlockPos pos;
    public final EnumFacing face;
    public final String invName;

    public ModuleTarget(int dimId, BlockPos pos, EnumFacing face, String invName) {
        this.dimId = dimId;
        this.pos = pos;
        this.face = face;
        this.invName = invName;
    }

    public ModuleTarget(int dimId, BlockPos pos, EnumFacing face) {
        this(dimId, pos, face, "");
    }

    public ModuleTarget(int dimId, BlockPos pos) {
        this(dimId, pos, null);
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound ext = new NBTTagCompound();
        ext.func_74768_a("Dimension", this.dimId);
        ext.func_74768_a("X", this.pos.func_177958_n());
        ext.func_74768_a("Y", this.pos.func_177956_o());
        ext.func_74768_a("Z", this.pos.func_177952_p());
        ext.func_74774_a("Face", (byte)this.face.ordinal());
        ext.func_74778_a("InvName", this.invName);
        return ext;
    }

    public static ModuleTarget fromNBT(NBTTagCompound nbt) {
        BlockPos pos = new BlockPos(nbt.func_74762_e("X"), nbt.func_74762_e("Y"), nbt.func_74762_e("Z"));
        EnumFacing face = EnumFacing.values()[nbt.func_74771_c("Face")];
        return new ModuleTarget(nbt.func_74762_e("Dimension"), pos, face, nbt.func_74779_i("InvName"));
    }

    public String toString() {
        return MiscUtil.locToString(this.dimId, this.pos) + " " + this.face + " [" + this.invName + "]";
    }
}

