/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.smartfilter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.gui.filter.GuiModFilter;
import me.desht.modularrouters.container.ContainerModFilter;
import me.desht.modularrouters.item.smartfilter.SmartFilter;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.ModMatcher;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.GuiSyncMessage;
import me.desht.modularrouters.util.ModNameCache;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ModFilter
extends SmartFilter {
    private static final String NBT_MODS = "Mods";
    private static final int MAX_SIZE = 6;

    @Override
    public IItemMatcher compile(ItemStack filterStack, ItemStack moduleStack, ModuleTarget target) {
        return new ModMatcher(ModFilter.getModList(filterStack));
    }

    public static List<String> getModList(ItemStack filterStack) {
        if (filterStack.func_77942_o()) {
            NBTTagList items = filterStack.func_77978_p().func_150295_c(NBT_MODS, 8);
            ArrayList res = Lists.newArrayListWithExpectedSize((int)items.func_74745_c());
            for (int i = 0; i < items.func_74745_c(); ++i) {
                res.add(items.func_150307_f(i));
            }
            return res;
        }
        return Lists.newArrayList();
    }

    private static void setModList(ItemStack filterStack, List<String> mods) {
        if (!filterStack.func_77942_o()) {
            filterStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList list = new NBTTagList();
        for (String m : mods) {
            list.func_74742_a((NBTBase)new NBTTagString(m));
        }
        NBTTagCompound compound = filterStack.func_77978_p();
        compound.func_74782_a(NBT_MODS, (NBTBase)list);
    }

    @Override
    public void addExtraInformation(ItemStack stack, World player, List<String> list, ITooltipFlag advanced) {
        super.addExtraInformation(stack, player, list, advanced);
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            List<String> l = ModFilter.getModList(stack);
            list.add(I18n.func_135052_a((String)"itemText.misc.modFilter.count", (Object[])new Object[]{l.size()}));
            list.addAll(l.stream().map(ModNameCache::getModName).map(s -> " \u2022 " + TextFormatting.AQUA + s).collect(Collectors.toList()));
        } else {
            list.add(I18n.func_135052_a((String)"itemText.misc.modFilter.count", (Object[])new Object[]{0}));
        }
    }

    @Override
    public Class<? extends GuiScreen> getGuiHandler() {
        return GuiModFilter.class;
    }

    @Override
    public boolean hasGuiContainer() {
        return true;
    }

    @Override
    public Container createContainer(EntityPlayer player, ItemStack filterStack, EnumHand hand, TileEntityItemRouter router) {
        return new ContainerModFilter(player, filterStack, hand, router);
    }

    @Override
    public IMessage dispatchMessage(EntityPlayer player, FilterSettingsMessage message, ItemStack filterStack, ItemStack moduleStack) {
        switch (message.getOp()) {
            case ADD_STRING: {
                String modId = message.getNbtData().func_74779_i("ModId");
                List<String> l = ModFilter.getModList(filterStack);
                if (l.size() >= 6 || l.contains(modId)) break;
                l.add(modId);
                ModFilter.setModList(filterStack, l);
                return new GuiSyncMessage(filterStack);
            }
            case REMOVE_AT: {
                int pos = message.getNbtData().func_74762_e("Pos");
                List<String> l = ModFilter.getModList(filterStack);
                if (pos < 0 || pos >= l.size()) break;
                l.remove(pos);
                ModFilter.setModList(filterStack, l);
                return new GuiSyncMessage(filterStack);
            }
            default: {
                ModularRouters.logger.warn("received unexpected message type " + (Object)((Object)message.getOp()) + " for " + filterStack);
            }
        }
        return null;
    }

    @Override
    public int getSize(ItemStack filterStack) {
        return filterStack.func_77942_o() ? filterStack.func_77978_p().func_150295_c(NBT_MODS, 8).func_74745_c() : 0;
    }
}

