/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.smartfilter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import me.desht.modularrouters.client.gui.filter.GuiInspectionFilter;
import me.desht.modularrouters.item.smartfilter.SmartFilter;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.InspectionMatcher;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.GuiSyncMessage;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class InspectionFilter
extends SmartFilter {
    private static final String NBT_MATCH_ALL = "MatchAll";
    private static final String NBT_ITEMS = "Items";
    private static final int MAX_SIZE = 6;

    @Override
    public IItemMatcher compile(ItemStack filterStack, ItemStack moduleStack, ModuleTarget target) {
        return new InspectionMatcher(InspectionFilter.getComparisonList(filterStack));
    }

    @Override
    public void addExtraInformation(ItemStack itemstack, World player, List<String> list, ITooltipFlag advanced) {
        super.addExtraInformation(itemstack, player, list, advanced);
        InspectionMatcher.ComparisonList comparisonList = InspectionFilter.getComparisonList(itemstack);
        if (!comparisonList.items.isEmpty()) {
            list.add(TextFormatting.YELLOW + I18n.func_135052_a((String)("guiText.label.matchAll." + comparisonList.isMatchAll()), (Object[])new Object[0]) + ":");
            for (InspectionMatcher.Comparison c : comparisonList.items) {
                list.add(TextFormatting.AQUA + "\u2022 " + c.asLocalizedText());
            }
        }
    }

    public static InspectionMatcher.ComparisonList getComparisonList(ItemStack filterStack) {
        if (filterStack.func_77942_o()) {
            NBTTagCompound compound = filterStack.func_77978_p();
            boolean matchAll = compound.func_74767_n(NBT_MATCH_ALL);
            ArrayList l = Lists.newArrayList();
            NBTTagList items = compound.func_150295_c(NBT_ITEMS, 8);
            for (int i = 0; i < items.func_74745_c(); ++i) {
                l.add(InspectionMatcher.Comparison.fromString(items.func_150307_f(i)));
            }
            return new InspectionMatcher.ComparisonList(l, matchAll);
        }
        return new InspectionMatcher.ComparisonList(Lists.newArrayList(), false);
    }

    private void setComparisonList(ItemStack filterStack, InspectionMatcher.ComparisonList comparisonList) {
        if (!filterStack.func_77942_o()) {
            filterStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound compound = filterStack.func_77978_p();
        NBTTagList l = new NBTTagList();
        for (InspectionMatcher.Comparison comp : comparisonList.items) {
            l.func_74742_a((NBTBase)new NBTTagString(comp.toString()));
        }
        compound.func_74757_a(NBT_MATCH_ALL, comparisonList.isMatchAll());
        compound.func_74782_a(NBT_ITEMS, (NBTBase)l);
    }

    @Override
    public Class<? extends GuiScreen> getGuiHandler() {
        return GuiInspectionFilter.class;
    }

    @Override
    public IMessage dispatchMessage(EntityPlayer player, FilterSettingsMessage message, ItemStack filterStack, ItemStack moduleStack) {
        InspectionMatcher.ComparisonList comparisonList = InspectionFilter.getComparisonList(filterStack);
        switch (message.getOp()) {
            case ADD_STRING: {
                if (comparisonList.items.size() >= 6) break;
                InspectionMatcher.Comparison c = InspectionMatcher.Comparison.fromString(message.getNbtData().func_74779_i("Comparison"));
                comparisonList.items.add(c);
                this.setComparisonList(filterStack, comparisonList);
                return new GuiSyncMessage(filterStack);
            }
            case REMOVE_AT: {
                int pos = message.getNbtData().func_74762_e("Pos");
                if (pos < 0 || pos >= comparisonList.items.size()) break;
                comparisonList.items.remove(pos);
                this.setComparisonList(filterStack, comparisonList);
                return new GuiSyncMessage(filterStack);
            }
            case ANY_ALL_FLAG: {
                comparisonList.setMatchAll(message.getNbtData().func_74767_n(NBT_MATCH_ALL));
                this.setComparisonList(filterStack, comparisonList);
                return new GuiSyncMessage(filterStack);
            }
        }
        return null;
    }

    @Override
    public int getSize(ItemStack filterStack) {
        return 0;
    }
}

