/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.fx.Vector3;
import me.desht.modularrouters.client.gui.GuiItemRouter;
import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.module.Module;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.network.ParticleBeamMessage;
import me.desht.modularrouters.util.BlockUtil;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class TargetedModule
extends Module {
    private static final String NBT_TARGET = "Target";
    private static final Map<UUID, Long> lastSwing = Maps.newHashMap();

    @Override
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing face, float x, float y, float z) {
        if (player.func_70093_af()) {
            if (InventoryUtils.getInventory(world, pos, face) != null) {
                if (world.field_72995_K) {
                    player.func_184185_a(RegistrarMR.SOUND_SUCCESS, 1.0f, 1.3f);
                } else {
                    TargetedModule.setTarget(stack, world, pos, face);
                    ModuleTarget tgt = TargetedModule.getTarget(stack, true);
                    if (tgt != null) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("chatText.misc.targetSet", new Object[]{tgt.toString()}), false);
                    }
                }
                return EnumActionResult.SUCCESS;
            }
            return super.onItemUse(stack, player, world, pos, hand, face, x, y, z);
        }
        return EnumActionResult.PASS;
    }

    @Override
    public void addUsageInformation(ItemStack itemstack, World player, List<String> list, ITooltipFlag advanced) {
        super.addUsageInformation(itemstack, player, list, advanced);
        MiscUtil.appendMultiline(list, "itemText.targetingHint", new Object[0]);
    }

    @Override
    public void addExtraInformation(ItemStack itemstack, World player, List<String> list, ITooltipFlag advanced) {
        super.addExtraInformation(itemstack, player, list, advanced);
        ModuleTarget target = TargetedModule.getTarget(itemstack);
        if (target != null) {
            list.add(I18n.func_135052_a((String)"chatText.misc.target", (Object[])new Object[]{target.toString()}));
            if (Minecraft.func_71410_x().field_71462_r instanceof GuiItemRouter) {
                TileEntityItemRouter router = ((GuiItemRouter)Minecraft.func_71410_x().field_71462_r).router;
                ModuleTarget moduleTarget = new ModuleTarget(router.func_145831_w().field_73011_w.getDimension(), router.func_174877_v());
                TargetValidation val = this.validateTarget(itemstack, moduleTarget, target, false);
                if (val != TargetValidation.OK) {
                    list.add(I18n.func_135052_a((String)("chatText.targetValidation." + (Object)((Object)val)), (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    public ActionResult<ItemStack> onSneakRightClick(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (TargetedModule.getTarget(stack) != null) {
            if (world.field_72995_K) {
                player.func_184185_a(RegistrarMR.SOUND_SUCCESS, 1.0f, 1.3f);
            } else {
                TargetedModule.setTarget(stack, world, null, null);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chatText.misc.targetCleared", new Object[0]), false);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private static void setTarget(ItemStack stack, World world, BlockPos pos, EnumFacing face) {
        if (world.field_72995_K) {
            ModularRouters.logger.warn("TargetModule.setTarget() should not be called client-side!");
            return;
        }
        NBTTagCompound compound = ModuleHelper.validateNBT(stack);
        if (pos == null) {
            compound.func_82580_o(NBT_TARGET);
        } else {
            String invName = BlockUtil.getBlockName(world, pos);
            ModuleTarget mt = new ModuleTarget(world.field_73011_w.getDimension(), pos, face, invName == null ? "?" : invName);
            compound.func_74782_a(NBT_TARGET, (NBTBase)mt.toNBT());
        }
        stack.func_77982_d(compound);
    }

    public static ModuleTarget getTarget(ItemStack stack) {
        return TargetedModule.getTarget(stack, false);
    }

    public static ModuleTarget getTarget(ItemStack stack, boolean checkBlockName) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_150299_b(NBT_TARGET) == 10) {
            String invName;
            WorldServer w;
            ModuleTarget target = ModuleTarget.fromNBT(compound.func_74775_l(NBT_TARGET));
            if (checkBlockName && (w = DimensionManager.getWorld((int)target.dimId)) != null && w.func_72863_F().func_73149_a(target.pos.func_177958_n() >> 4, target.pos.func_177952_p() >> 4) && !target.invName.equals(invName = BlockUtil.getBlockName((World)w, target.pos))) {
                TargetedModule.setTarget(stack, (World)w, target.pos, target.face);
                return new ModuleTarget(target.dimId, target.pos, target.face, invName);
            }
            return target;
        }
        return null;
    }

    @Override
    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (!(entityLiving instanceof EntityPlayerMP)) {
            return false;
        }
        EntityPlayerMP player = (EntityPlayerMP)entityLiving;
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_70093_af()) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now - lastSwing.getOrDefault(player.func_110124_au(), 0L) < 250L) {
            return true;
        }
        lastSwing.put(player.func_110124_au(), now);
        ModuleTarget src = new ModuleTarget(world.field_73011_w.getDimension(), player.func_180425_c());
        ModuleTarget target = TargetedModule.getTarget(stack, true);
        if (target == null) {
            return false;
        }
        TargetValidation res = this.validateTarget(stack, src, target, true);
        Vector3 orig = Vector3.fromEntityCenter((Entity)player);
        Vector3 end = Vector3.fromBlockPos(target.pos).add(0.5);
        if (src.dimId == target.dimId) {
            ModularRouters.network.sendTo((IMessage)new ParticleBeamMessage(orig.x, orig.y, orig.z, end.x, end.y, end.z, null, 0.5f), player);
        }
        player.func_146105_b(new TextComponentTranslation("chatText.misc.target", new Object[]{target.toString()}).func_150258_a("  ").func_150257_a((ITextComponent)new TextComponentTranslation("chatText.targetValidation." + (Object)((Object)res), new Object[0])), false);
        return true;
    }

    private TargetValidation validateTarget(ItemStack moduleStack, ModuleTarget src, ModuleTarget dst, boolean validateBlocks) {
        if (this.isRangeLimited() && (src.dimId != dst.dimId || src.pos.func_177951_i((Vec3i)dst.pos) > (double)this.maxDistanceSq(moduleStack))) {
            return TargetValidation.OUT_OF_RANGE;
        }
        if (validateBlocks) {
            WorldServer w = DimensionManager.getWorld((int)dst.dimId);
            if (w == null || !w.func_72863_F().func_73149_a(dst.pos.func_177958_n() >> 4, dst.pos.func_177952_p() >> 4)) {
                return TargetValidation.NOT_LOADED;
            }
            if (w.func_175625_s(dst.pos) == null) {
                return TargetValidation.NOT_INVENTORY;
            }
        }
        return TargetValidation.OK;
    }

    private int maxDistanceSq(ItemStack stack) {
        Module module = ItemModule.getModule(stack);
        if (module instanceof IRangedModule) {
            int r = ((IRangedModule)((Object)module)).getCurrentRange(stack);
            return r * r;
        }
        return 0;
    }

    protected boolean isRangeLimited() {
        return true;
    }

    static enum TargetValidation {
        OK,
        OUT_OF_RANGE,
        NOT_LOADED,
        NOT_INVENTORY;

    }
}

