/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.BlockItemRouter;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.gui.GuiItemRouter;
import me.desht.modularrouters.client.gui.module.GuiModule;
import me.desht.modularrouters.config.ConfigHandler;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.container.slot.ValidatingSlot;
import me.desht.modularrouters.item.ItemSubTypes;
import me.desht.modularrouters.item.augment.ItemAugment;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import me.desht.modularrouters.item.smartfilter.SmartFilter;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.SimpleItemMatcher;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Module
extends ItemSubTypes.SubItemHandler {
    public abstract CompiledModule compile(TileEntityItemRouter var1, ItemStack var2);

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addBasicInformation(ItemStack itemstack, World player, List<String> list, ITooltipFlag advanced) {
        Slot slot;
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiItemRouter && (slot = ((GuiItemRouter)Minecraft.func_71410_x().field_71462_r).getSlotUnderMouse()) instanceof ValidatingSlot.Module) {
            list.add(MiscUtil.translate("itemText.misc.configureHint", String.valueOf(ConfigHandler.getConfigKey())));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addExtraInformation(ItemStack itemstack, World player, List<String> list, ITooltipFlag advanced) {
        this.addSettingsInformation(itemstack, list);
        this.addAugmentInformation(itemstack, list);
    }

    private void addSettingsInformation(ItemStack itemstack, List<String> list) {
        if (this.isDirectional()) {
            RelativeDirection dir = ModuleHelper.getDirectionFromNBT(itemstack);
            String dirStr = this.getDirectionString(dir);
            list.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"guiText.label.direction", (Object[])new Object[0]) + ": " + TextFormatting.AQUA + dirStr);
        }
        this.addFilterInformation(itemstack, list);
        list.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"itemText.misc.flags", (Object[])new Object[0]) + ": " + String.join((CharSequence)" / ", this.formatFlag("IGNORE_META", ModuleHelper.ignoreMeta(itemstack)), this.formatFlag("IGNORE_NBT", ModuleHelper.ignoreNBT(itemstack)), this.formatFlag("IGNORE_OREDICT", ModuleHelper.ignoreOreDict(itemstack)), this.formatFlag("TERMINATE", !ModuleHelper.terminates(itemstack))));
        if (this instanceof IRangedModule) {
            IRangedModule rm = (IRangedModule)((Object)this);
            int curRange = rm.getCurrentRange(itemstack);
            String col = curRange > rm.getBaseRange() ? TextFormatting.GREEN.toString() : (curRange < rm.getBaseRange() ? TextFormatting.RED.toString() : TextFormatting.AQUA.toString());
            list.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"itemText.misc.rangeInfo", (Object[])new Object[]{col, rm.getCurrentRange(itemstack), rm.getBaseRange(), rm.getHardMaxRange()}));
        }
    }

    public String getDirectionString(RelativeDirection dir) {
        return this.isOmniDirectional() && dir == RelativeDirection.NONE ? I18n.func_135052_a((String)"guiText.tooltip.allDirections", (Object[])new Object[0]) : I18n.func_135052_a((String)("guiText.tooltip." + dir.toString()), (Object[])new Object[0]);
    }

    private String formatFlag(String key, boolean flag) {
        String text = I18n.func_135052_a((String)("itemText.misc." + key), (Object[])new Object[0]);
        return (flag ? TextFormatting.DARK_AQUA + TextFormatting.STRIKETHROUGH.toString() : TextFormatting.AQUA) + text + TextFormatting.RESET;
    }

    private void addFilterInformation(ItemStack itemstack, List<String> list) {
        NBTTagList filterItems = ModuleHelper.getFilterItems(itemstack);
        list.add(TextFormatting.YELLOW + I18n.func_135052_a((String)("itemText.misc." + (ModuleHelper.isBlacklist(itemstack) ? "blacklist" : "whitelist")), (Object[])new Object[0]) + ":");
        if (filterItems.func_74745_c() > 0) {
            for (int i = 0; i < filterItems.func_74745_c(); ++i) {
                ItemStack s = new ItemStack(filterItems.func_150305_b(i));
                SmartFilter f = ItemSmartFilter.getFilter(s);
                if (f == null) {
                    list.add(" \u2022 " + TextFormatting.AQUA + s.func_82833_r());
                    continue;
                }
                int size = f.getSize(s);
                String suffix = size > 0 ? " [" + size + "]" : "";
                list.add(" \u2022 " + TextFormatting.AQUA + TextFormatting.ITALIC + s.func_82833_r() + suffix);
            }
        } else {
            String s = list.get(list.size() - 1);
            list.set(list.size() - 1, s + " " + TextFormatting.AQUA + TextFormatting.ITALIC + I18n.func_135052_a((String)"itemText.misc.noItems", (Object[])new Object[0]));
        }
    }

    private void addAugmentInformation(ItemStack itemstack, List<String> list) {
        ItemAugment.AugmentCounter c = new ItemAugment.AugmentCounter(itemstack);
        ArrayList toAdd = Lists.newArrayList();
        for (ItemAugment.AugmentType type : ItemAugment.AugmentType.values()) {
            int n = c.getAugmentCount(type);
            if (n <= 0) continue;
            String s = I18n.func_135052_a((String)("item." + type.toString().toLowerCase() + "_augment.name"), (Object[])new Object[0]);
            if (n > 1) {
                s = n + " x " + s;
            }
            s = s + TextFormatting.AQUA + ItemAugment.getAugment(type).getExtraInfo(n, itemstack);
            toAdd.add(" \u2022 " + TextFormatting.DARK_GREEN + s);
        }
        if (!toAdd.isEmpty()) {
            list.add(TextFormatting.GREEN + I18n.func_135052_a((String)"itemText.augments", (Object[])new Object[0]));
            list.addAll(toAdd);
        }
    }

    @Override
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing face, float x, float y, float z) {
        TileEntityItemRouter router = TileEntityItemRouter.getRouterAt((IBlockAccess)world, pos);
        if (router != null && !player.func_70093_af()) {
            player.openGui((Object)ModularRouters.instance, ModularRouters.GUI_ROUTER, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> onSneakRightClick(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return false;
    }

    public ContainerModule createGuiContainer(EntityPlayer player, EnumHand hand, ItemStack moduleStack, TileEntityItemRouter router) {
        return new ContainerModule(player, hand, moduleStack, router);
    }

    public Class<? extends GuiModule> getGuiHandler() {
        return GuiModule.class;
    }

    public boolean isDirectional() {
        return true;
    }

    public boolean isOmniDirectional() {
        return false;
    }

    public boolean isFluidModule() {
        return false;
    }

    public boolean isItemValidForFilter(ItemStack stack) {
        return true;
    }

    public IItemMatcher getFilterItemMatcher(ItemStack stack) {
        return new SimpleItemMatcher(stack);
    }

    public static enum RelativeDirection {
        NONE(0, null),
        DOWN(1, BlockItemRouter.OPEN_D),
        UP(2, BlockItemRouter.OPEN_U),
        LEFT(4, BlockItemRouter.OPEN_L),
        RIGHT(8, BlockItemRouter.OPEN_R),
        FRONT(16, BlockItemRouter.OPEN_F),
        BACK(32, BlockItemRouter.OPEN_B);

        private static RelativeDirection[] realSides;
        private final int mask;
        private final PropertyBool property;

        private RelativeDirection(int mask, PropertyBool property) {
            this.mask = mask;
            this.property = property;
        }

        public static RelativeDirection[] realSides() {
            return realSides;
        }

        public EnumFacing toEnumFacing(EnumFacing current) {
            switch (this) {
                case UP: {
                    return EnumFacing.UP;
                }
                case DOWN: {
                    return EnumFacing.DOWN;
                }
                case FRONT: {
                    return current;
                }
                case LEFT: {
                    return current.func_176746_e();
                }
                case BACK: {
                    return current.func_176734_d();
                }
                case RIGHT: {
                    return current.func_176735_f();
                }
            }
            return current;
        }

        public int getMask() {
            return this.mask;
        }

        public PropertyBool getProperty() {
            return this.property;
        }

        static {
            realSides = new RelativeDirection[]{FRONT, BACK, UP, DOWN, LEFT, RIGHT};
        }
    }

    public static enum ModuleFlags {
        BLACKLIST(true, 1),
        IGNORE_META(false, 2),
        IGNORE_NBT(true, 4),
        IGNORE_OREDICT(true, 8),
        TERMINATE(false, 128);

        private final boolean defaultValue;
        private byte mask;

        private ModuleFlags(boolean defaultValue, int mask) {
            this.defaultValue = defaultValue;
            this.mask = (byte)mask;
        }

        public boolean getDefaultValue() {
            return this.defaultValue;
        }

        public byte getMask() {
            return this.mask;
        }
    }
}

