/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import java.io.IOException;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.gui.widgets.GuiContainerBase;
import me.desht.modularrouters.container.ContainerSmartFilter;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.network.OpenGuiMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

abstract class GuiFilterContainer
extends GuiContainerBase {
    protected final BlockPos routerPos;
    protected final Integer moduleSlotIndex;
    protected final Integer filterSlotIndex;
    protected final EnumHand hand;
    protected final String title;
    protected final ItemStack filterStack;

    GuiFilterContainer(ContainerSmartFilter container, BlockPos routerPos, Integer moduleSlotIndex, Integer filterSlotIndex, EnumHand hand) {
        super(container);
        this.routerPos = routerPos;
        this.moduleSlotIndex = moduleSlotIndex;
        this.filterSlotIndex = filterSlotIndex;
        this.hand = hand;
        this.filterStack = container.getFilterStack();
        this.title = this.filterStack.func_82833_r();
    }

    boolean closeGUI() {
        ItemStack stack;
        if (this.routerPos != null) {
            TileEntityItemRouter router = TileEntityItemRouter.getRouterAt((IBlockAccess)this.field_146297_k.field_71441_e, this.routerPos);
            if (router != null) {
                router.playerConfiguringModule((EntityPlayer)this.field_146297_k.field_71439_g, this.moduleSlotIndex);
                ModularRouters.network.sendToServer((IMessage)OpenGuiMessage.openModuleInRouter(this.routerPos, this.moduleSlotIndex));
                return true;
            }
        } else if (this.hand != null && ItemModule.getModule(stack = this.field_146297_k.field_71439_g.func_184586_b(this.hand)) != null) {
            ModularRouters.network.sendToServer((IMessage)OpenGuiMessage.openModuleInHand(this.hand));
            return true;
        }
        return false;
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if ((keyCode == 1 || keyCode == 18) && this.closeGUI()) {
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }
}

