/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.world;

import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.silentchaos512.lib.SilentLib;

public abstract class WorldGeneratorSL
implements IWorldGenerator {
    public final boolean allowRetrogen;
    public final String retrogenKey;
    public final int retrogenVersion;
    protected boolean printDebugInfo = false;

    public WorldGeneratorSL(boolean allowRetrogren, String retrogenKey) {
        this(allowRetrogren, retrogenKey, 1);
    }

    public WorldGeneratorSL(boolean allowRetrogren, String retrogenKey, int retrogenVersion) {
        this.allowRetrogen = allowRetrogren;
        this.retrogenKey = retrogenKey;
        int n = this.retrogenVersion = retrogenVersion > 0 ? retrogenVersion : 1;
        if (allowRetrogren) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int posZ;
        int posX;
        int dim = world.field_73011_w.getDimension();
        if (!this.generateForDimension(dim, world, random, posX = chunkX * 16, posZ = chunkZ * 16)) {
            switch (dim) {
                case 0: {
                    this.generateSurface(world, random, posX, posZ);
                    break;
                }
                case -1: {
                    this.generateNether(world, random, posX, posZ);
                    break;
                }
                case 1: {
                    this.generateEnd(world, random, posX, posZ);
                    break;
                }
                default: {
                    this.generateSurface(world, random, posX, posZ);
                }
            }
        }
    }

    protected void generateSurface(World world, Random random, int posX, int posZ) {
    }

    protected void generateNether(World world, Random random, int posX, int posZ) {
    }

    protected void generateEnd(World world, Random random, int posX, int posZ) {
    }

    protected boolean generateForDimension(int dim, World world, Random random, int posX, int posZ) {
        return false;
    }

    protected void debug(Object obj) {
        if (this.printDebugInfo) {
            SilentLib.logHelper.debug(obj);
        }
    }
}

