/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import net.silentchaos512.lib.collection.ItemStackList;

public class StackHelper {
    @Deprecated
    @Nonnull
    public static ItemStack grow(@Nonnull ItemStack stack, int amount) {
        stack.func_190917_f(amount);
        return stack;
    }

    @Deprecated
    @Nonnull
    public static ItemStack shrink(@Nonnull ItemStack stack, int amount) {
        stack.func_190918_g(amount);
        return stack;
    }

    @Deprecated
    @Nonnull
    public static ItemStack safeCopy(@Nonnull ItemStack stack) {
        return stack.func_77946_l();
    }

    @Deprecated
    public static int getCount(@Nonnull ItemStack stack) {
        return stack.func_190916_E();
    }

    @Deprecated
    @Nonnull
    public static ItemStack setCount(@Nonnull ItemStack stack, int amount) {
        stack.func_190920_e(amount);
        if (amount <= 0) {
            return StackHelper.empty();
        }
        return stack;
    }

    public static boolean isEmpty(@Nonnull ItemStack stack) {
        return stack == null || stack.func_190926_b();
    }

    public static boolean isValid(@Nonnull ItemStack stack) {
        return stack != null && !stack.func_190926_b();
    }

    @Nonnull
    public static ItemStack loadFromNBT(NBTTagCompound tags) {
        if (tags == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(tags);
    }

    @Deprecated
    @Nonnull
    public static ItemStack empty() {
        return ItemStack.field_190927_a;
    }

    @Nullable
    public static NBTTagCompound getTagCompound(@Nonnull ItemStack stack, boolean createIfNull) {
        if (StackHelper.isEmpty(stack)) {
            return null;
        }
        if (!stack.func_77942_o() && createIfNull) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    @Nonnull
    public static ItemStack extractItem(@Nullable TileEntity tileEntity, int slot, int amount) {
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return capability.extractItem(slot, amount, false);
        }
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            return inventory.func_70298_a(slot, amount);
        }
        return StackHelper.empty();
    }

    public static void setStack(@Nullable TileEntity tileEntity, int slot, @Nonnull ItemStack stack) {
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            capability.extractItem(slot, 64, false);
            capability.insertItem(slot, stack, false);
        } else if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            inventory.func_70299_a(slot, stack);
        }
    }

    @Nonnull
    public static List<ItemStack> getOres(String oreDictKey) {
        return OreDictionary.getOres((String)oreDictKey);
    }

    @Nonnull
    public static List<ItemStack> getOres(String oreDictKey, boolean alwaysCreateEntry) {
        return OreDictionary.getOres((String)oreDictKey, (boolean)alwaysCreateEntry);
    }

    @Nonnull
    public static List<String> getOreNames(@Nonnull ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        if (stack.func_190926_b()) {
            return list;
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            list.add(OreDictionary.getOreName((int)id));
        }
        return list;
    }

    public static boolean matchesOreDict(ItemStack stack, String oreDictKey) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (String oreName : StackHelper.getOreNames(stack)) {
            if (!oreName.equals(oreDictKey)) continue;
            return true;
        }
        for (ItemStack stackOre : StackHelper.getOres(oreDictKey)) {
            if (!stack.func_77969_a(stackOre)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static ItemStack getAndSplit(ItemStackList stacks, int index, int amount) {
        return ItemStackHelper.func_188382_a((List)((Object)stacks), (int)index, (int)amount);
    }

    @Deprecated
    public static ItemStack getAndRemove(ItemStackList stacks, int index) {
        return ItemStackHelper.func_188383_a((List)((Object)stacks), (int)index);
    }

    public static NBTTagCompound saveAllItems(NBTTagCompound tags, ItemStackList stacks) {
        return StackHelper.saveAllItems(tags, stacks, true);
    }

    public static NBTTagCompound saveAllItems(NBTTagCompound tags, ItemStackList stacks, boolean saveEmpty) {
        return ItemStackHelper.func_191281_a((NBTTagCompound)tags, (NonNullList)stacks, (boolean)saveEmpty);
    }

    public static void loadAllItems(NBTTagCompound tags, ItemStackList stacks) {
        ItemStackHelper.func_191283_b((NBTTagCompound)tags, (NonNullList)stacks);
    }
}

