/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.event;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.item.ItemGuideBookSL;
import net.silentchaos512.lib.util.EntityHelper;
import net.silentchaos512.lib.util.PlayerHelper;

public final class SilentLibCommonEvents {
    private static final String NBT_ROOT_GUIDE_BOOKS = "silentlib_guide_books";

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        NBTTagCompound persistedData;
        EntityPlayer player = event.player;
        NBTTagCompound forgeData = player.getEntityData();
        if (!forgeData.func_74764_b("PlayerPersisted")) {
            forgeData.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
        }
        if (!(persistedData = forgeData.func_74775_l("PlayerPersisted")).func_74764_b(NBT_ROOT_GUIDE_BOOKS)) {
            persistedData.func_74782_a(NBT_ROOT_GUIDE_BOOKS, (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound guideData = persistedData.func_74775_l(NBT_ROOT_GUIDE_BOOKS);
        int id = 0;
        ItemGuideBookSL item = ItemGuideBookSL.getBookById(id);
        while (item != null && item.giveBookOnFirstLogin) {
            if (!guideData.func_74767_n(item.getFullName())) {
                guideData.func_74757_a(item.getFullName(), true);
                PlayerHelper.giveItem(player, new ItemStack((Item)item));
                SilentLib.logHelper.info((Object)("Player has been given guide book " + item.getFullName()));
            }
            item = ItemGuideBookSL.getBookById(++id);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            EntityHelper.handleSpawns();
        }
    }
}

