/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.silentchaos512.lib.config.ConfigBase;

public abstract class AbstractGuiFactory
implements IModGuiFactory {
    public abstract ConfigBase getConfig();

    public abstract String getModId();

    public abstract String getGuiTitle();

    public boolean hasConfigGui() {
        return true;
    }

    public GuiScreen createConfigGui(GuiScreen parentScreen) {
        return new BasicGuiConfig(parentScreen, this);
    }

    public Set<IModGuiFactory.RuntimeOptionCategoryElement> runtimeGuiCategories() {
        return null;
    }

    public static class BasicGuiConfig
    extends GuiConfig {
        public BasicGuiConfig(GuiScreen parentScreen, AbstractGuiFactory factory) {
            super(parentScreen, BasicGuiConfig.getAllElements(factory), factory.getModId(), false, false, factory.getGuiTitle());
        }

        public static List<IConfigElement> getAllElements(AbstractGuiFactory factory) {
            ConfigBase config = factory.getConfig();
            ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
            Set categories = config.getConfiguration().getCategoryNames();
            for (String cat : categories) {
                if (cat.contains(".")) continue;
                List elements = new ConfigElement(config.getCategory(cat)).getChildElements();
                String langKey = "config." + factory.getModId() + ":" + cat;
                list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement(cat, langKey, elements));
            }
            return list;
        }
    }
}

