/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.init;

import com.phylogeny.extrabitmanipulation.armor.ChiseledArmorStackHandeler;
import com.phylogeny.extrabitmanipulation.armor.ModelChiseledArmor;
import com.phylogeny.extrabitmanipulation.armor.ModelChiseledArmorLeggings;
import com.phylogeny.extrabitmanipulation.block.BlockExtraBitManipulationBase;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.init.BlocksExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.init.ItemsExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.item.ItemExtraBitManipulationBase;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModelRegistration {
    private static final String ARMOR_TEXTURE_PATH = "extrabitmanipulation:textures/armor/chiseled_armor.png";
    private static ModelChiseledArmor armorModel;
    private static ModelChiseledArmorLeggings armorModelLeggings;
    private static ModelBiped armorModelEmpty;

    public static void registerItemModels() {
        ItemChiseledArmor.ArmorMovingPart.initIconModelLocations();
        ModelRegistration.registerChiseledArmorItemModel(ItemsExtraBitManipulation.chiseledHelmet);
        ModelRegistration.registerChiseledArmorItemModel(ItemsExtraBitManipulation.chiseledChestplate);
        ModelRegistration.registerChiseledArmorItemModel(ItemsExtraBitManipulation.chiseledLeggings);
        ModelRegistration.registerChiseledArmorItemModel(ItemsExtraBitManipulation.chiseledBoots);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.diamondNugget);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.bitWrench);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.sculptingLoop);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.sculptingSquare);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.sculptingSpadeCurved);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.sculptingSpadeSquared);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.modelingTool);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.modelingToolHead);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.bitWrenchHead);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.sculptingLoopHead);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.sculptingSquareHead);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.sculptingSpadeCurvedHead);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.sculptingSpadeSquaredHead);
        ModelRegistration.registerItemBlockModel(BlocksExtraBitManipulation.bodyPartTemplate);
        armorModel = new ModelChiseledArmor();
        armorModelLeggings = new ModelChiseledArmorLeggings();
        armorModelEmpty = new ModelBiped();
        ModelRegistration.armorModelEmpty.field_78116_c.field_78804_l.clear();
        ModelRegistration.armorModelEmpty.field_78115_e.field_78804_l.clear();
        ModelRegistration.armorModelEmpty.field_178723_h.field_78804_l.clear();
        ModelRegistration.armorModelEmpty.field_178724_i.field_78804_l.clear();
        ModelRegistration.armorModelEmpty.field_178721_j.field_78804_l.clear();
        ModelRegistration.armorModelEmpty.field_178722_k.field_78804_l.clear();
        ArrayList<ModelResourceLocation> modelLocations = new ArrayList<ModelResourceLocation>();
        for (ItemChiseledArmor.ArmorMovingPart movingPart : ItemChiseledArmor.ArmorMovingPart.values()) {
            for (ModelResourceLocation modelLocation : movingPart.getIconModelLocations()) {
                modelLocations.add(modelLocation);
            }
        }
        ModelRegistration.registerIsolatedModel(ItemsExtraBitManipulation.chiseledHelmet, modelLocations.toArray(new ResourceLocation[modelLocations.size()]));
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        ModelRegistration.registerBakedItemModel(event, ItemsExtraBitManipulation.chiseledHelmet);
        ModelRegistration.registerBakedItemModel(event, ItemsExtraBitManipulation.chiseledChestplate);
        ModelRegistration.registerBakedItemModel(event, ItemsExtraBitManipulation.chiseledLeggings);
        ModelRegistration.registerBakedItemModel(event, ItemsExtraBitManipulation.chiseledBoots);
    }

    private static void registerBakedItemModel(ModelBakeEvent event, Item item) {
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(item.getRegistryName(), "inventory"), (Object)new ChiseledArmorStackHandeler.ChiseledArmorBakedModel());
    }

    private static void registerItemBlockModel(Block block) {
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            ModelRegistration.registerItemModel(item, ((BlockExtraBitManipulationBase)block).getName());
        }
    }

    private static void registerItemModel(Item item) {
        ModelRegistration.registerItemModel(item, ((ItemExtraBitManipulationBase)item).getName());
    }

    private static void registerChiseledArmorItemModel(Item item) {
        ItemChiseledArmor armorPiece = (ItemChiseledArmor)item;
        ResourceLocation name = armorPiece.getRegistryName();
        if (name == null) {
            return;
        }
        ModelRegistration.registerItemModel((Item)armorPiece, name.func_110623_a());
        ModelRegistration.registerIsolatedModel((Item)armorPiece, armorPiece.initItemModelLocation());
        armorPiece.field_77881_a.initIconStack((Item)armorPiece);
    }

    private static void registerItemModel(Item item, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("extrabitmanipulation", name), "inventory"));
    }

    private static void registerIsolatedModel(Item item, ResourceLocation ... resourceLocations) {
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])resourceLocations);
    }

    public static ModelBiped getArmorModel(ItemStack stack, EntityEquipmentSlot slot) {
        return ModelRegistration.shouldRenderEmptymodel(stack) ? armorModelEmpty : (slot == EntityEquipmentSlot.LEGS ? armorModelLeggings : armorModel);
    }

    public static String getArmorTexture(ItemStack stack) {
        return ModelRegistration.shouldRenderEmptymodel(stack) ? null : ARMOR_TEXTURE_PATH;
    }

    private static boolean shouldRenderEmptymodel(ItemStack stack) {
        return Configs.armorModelRenderMode == ArmorModelRenderMode.NEVER || Configs.armorModelRenderMode == ArmorModelRenderMode.IF_EMPTY && ItemStackHelper.getArmorData(ItemStackHelper.getNBTOrNew(stack)).func_74767_n("notEmpty");
    }

    public static enum ArmorModelRenderMode {
        IF_EMPTY,
        NEVER,
        ALWAYS;

    }
}

