/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.helper;

import com.phylogeny.extrabitmanipulation.ExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.api.ChiselsAndBitsAPIAccess;
import com.phylogeny.extrabitmanipulation.helper.BitIOHelper;
import com.phylogeny.extrabitmanipulation.helper.BitToolSettingsHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.item.ItemModelingTool;
import com.phylogeny.extrabitmanipulation.reference.GuiIDs;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class BitAreaHelper {
    public static Vec3d readVecFromNBT(NBTTagCompound nbt, String key) {
        NBTTagList bounds = nbt.func_150295_c(key, 6);
        return bounds.func_82582_d() ? null : new Vec3d(bounds.func_150309_d(0), bounds.func_150309_d(1), bounds.func_150309_d(2));
    }

    public static void writeVecToNBT(Vec3d vec, NBTTagCompound nbt, String key) {
        NBTTagList bounds = new NBTTagList();
        BitAreaHelper.appendBound(bounds, vec.field_72450_a);
        BitAreaHelper.appendBound(bounds, vec.field_72448_b);
        BitAreaHelper.appendBound(bounds, vec.field_72449_c);
        nbt.func_74782_a(key, (NBTBase)bounds);
    }

    private static void appendBound(NBTTagList bounds, double bound) {
        bounds.func_74742_a((NBTBase)new NBTTagDouble(bound));
    }

    public static EnumFacing readFacingFromNBT(NBTTagCompound nbt, String key) {
        return EnumFacing.field_82609_l[nbt.func_74762_e(key)];
    }

    public static void writeFacingToNBT(EnumFacing face, NBTTagCompound nbt, String key) {
        nbt.func_74768_a(key, face.ordinal());
    }

    public static BlockPos readBlockPosFromNBT(NBTTagCompound nbt, String key) {
        return BlockPos.func_177969_a((long)nbt.func_74763_f(key));
    }

    public static void writeBlockPosToNBT(BlockPos pos, NBTTagCompound nbt, String key) {
        nbt.func_74772_a(key, pos.func_177986_g());
    }

    public static Vec3d getBitGridOffset(EnumFacing side, boolean inside, float hitX, float hitY, float hitZ, boolean removeBits) {
        boolean su;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        x = hitX < (float)Math.round(hitX / 0.0625f) * 0.0625f ? 1.0f : -1.0f;
        y = hitY < (float)Math.round(hitY / 0.0625f) * 0.0625f ? 1.0f : -1.0f;
        z = hitZ < (float)Math.round(hitZ / 0.0625f) * 0.0625f ? 1.0f : -1.0f;
        double offsetX = Math.abs(side.func_82601_c());
        double offsetY = Math.abs(side.func_96559_d());
        double offsetZ = Math.abs(side.func_82599_e());
        if (side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
            if (offsetX > 0.0) {
                x *= -1.0f;
            }
            if (offsetY > 0.0) {
                y *= -1.0f;
            }
            if (offsetZ > 0.0) {
                z *= -1.0f;
            }
        }
        boolean bl = su = side == EnumFacing.UP || side == EnumFacing.SOUTH;
        if (removeBits ? !inside || !su : inside && su) {
            if (offsetX > 0.0) {
                x *= -1.0f;
            }
            if (offsetY > 0.0) {
                y *= -1.0f;
            }
            if (offsetZ > 0.0) {
                z *= -1.0f;
            }
        }
        return new Vec3d((double)x, (double)y, (double)z);
    }

    public static boolean readBlockStates(ItemStack stack, EntityPlayer player, World world, BlockPos pos, Vec3d hit, Vec3i drawnStartPoint, BitToolSettingsHelper.ModelReadData modelingData) {
        ItemModelingTool modelingTool = (ItemModelingTool)(ItemStackHelper.isModelingToolStack(stack) ? stack.func_77973_b() : null);
        if (modelingTool == null) {
            return false;
        }
        NBTTagCompound nbt = modelingTool.initialize(stack, modelingData);
        ModelingBoxSet boxSet = BitAreaHelper.getModelingToolBoxSet(player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), hit, drawnStartPoint, false, modelingData.getAreaMode(), modelingData.getSnapMode());
        if (boxSet.isEmpty()) {
            return false;
        }
        BitIOHelper.saveBlockStates(ChiselsAndBitsAPIAccess.apiInstance, player, world, boxSet.getBoundingBox(), nbt);
        if (modelingData.getGuiOpen()) {
            player.openGui((Object)ExtraBitManipulation.instance, GuiIDs.BIT_MAPPING.getID(), player.field_70170_p, 0, 0, 0);
        }
        return true;
    }

    public static ModelingBoxSet getModelingToolBoxSet(EntityPlayer player, int x, int y, int z, Vec3d hit, Vec3i drawnStartPointModelingTool, boolean addToBoxForRender, int modelAreaMode, int modeSnapToChunk) {
        AxisAlignedBB boxBounding = null;
        AxisAlignedBB boxPoint = null;
        if (modelAreaMode == 2) {
            if (drawnStartPointModelingTool != null) {
                int x2 = drawnStartPointModelingTool.func_177958_n();
                int y2 = drawnStartPointModelingTool.func_177956_o();
                int z2 = drawnStartPointModelingTool.func_177952_p();
                if (addToBoxForRender) {
                    if (Math.max(x, x2) == x) {
                        ++x;
                    } else {
                        ++x2;
                    }
                    if (Math.max(y, y2) == y) {
                        ++y;
                    } else {
                        ++y2;
                    }
                    if (Math.max(z, z2) == z) {
                        ++z;
                    } else {
                        ++z2;
                    }
                }
                boxBounding = new AxisAlignedBB((double)x2, (double)y2, (double)z2, Math.abs(x2 - x) <= 16 ? (double)x : (double)(x2 - x > 0 ? x2 - 16 : x2 + 16), Math.abs(y2 - y) <= 16 ? (double)y : (double)(y2 - y > 0 ? y2 - 16 : y2 + 16), Math.abs(z2 - z) <= 16 ? (double)z : (double)(z2 - z > 0 ? z2 - 16 : z2 + 16));
            }
        } else {
            int hitX = (int)Math.round(hit.field_72450_a);
            int hitY = (int)Math.round(hit.field_72448_b);
            int hitZ = (int)Math.round(hit.field_72449_c);
            boxBounding = new AxisAlignedBB((double)hitX, (double)hitY, (double)hitZ, (double)hitX, (double)hitY, (double)hitZ);
            boxPoint = boxBounding.func_186662_g(0.005);
            boxBounding = boxBounding.func_186662_g(8.0);
            if (modelAreaMode == 1) {
                float yaw = Math.abs(player.field_70177_z) % 360.0f;
                int greaterX = 8;
                int lesserX = -8;
                if (player.field_70177_z < 0.0f) {
                    greaterX *= -1;
                    lesserX *= -1;
                }
                int greaterZ = -8;
                int lesserZ = 8;
                int angleX = 180;
                int angleZ = 90;
                EnumFacing side = player.func_174811_aO();
                if (player.field_70177_z > 0.0f ? side.func_176743_c() == EnumFacing.AxisDirection.POSITIVE : side == EnumFacing.SOUTH || side == EnumFacing.WEST) {
                    greaterZ *= -1;
                    lesserZ *= -1;
                    if (side == (player.field_70177_z > 0.0f ? EnumFacing.EAST : EnumFacing.WEST)) {
                        lesserX *= -1;
                        angleZ = 270;
                    } else {
                        angleZ = 0;
                    }
                }
                boxBounding = boxBounding.func_72317_d(yaw > (float)angleX ? (double)greaterX : (double)lesserX, player.field_70125_A > 0.0f ? -8.0 : 8.0, yaw > (float)angleZ ? (double)greaterZ : (double)lesserZ);
            }
            if (modeSnapToChunk > 0) {
                if (x < 0) {
                    x -= 15;
                }
                if (z < 0) {
                    z -= 15;
                }
                x -= x % 16;
                z -= z % 16;
                y = modeSnapToChunk == 2 ? (y -= y % 16) : (int)boxBounding.field_72338_b;
                double offsetX = (double)x - boxBounding.field_72340_a;
                double offsetY = (double)y - boxBounding.field_72338_b;
                double offsetZ = (double)z - boxBounding.field_72339_c;
                boxBounding = boxBounding.func_72317_d(offsetX, offsetY, offsetZ);
                boxPoint = boxPoint.func_72317_d(offsetX, offsetY, offsetZ);
            }
        }
        return new ModelingBoxSet(boxBounding, boxPoint);
    }

    public static class ModelingBoxSet {
        private AxisAlignedBB boxBounding;
        private AxisAlignedBB boxPoint;

        public ModelingBoxSet(@Nullable AxisAlignedBB boxBounding, @Nullable AxisAlignedBB boxPoint) {
            this.boxBounding = boxBounding;
            this.boxPoint = boxPoint;
        }

        public AxisAlignedBB getBoundingBox() {
            return this.boxBounding;
        }

        public AxisAlignedBB getPoint() {
            return this.boxPoint;
        }

        public boolean hasPoint() {
            return this.boxPoint != null;
        }

        public boolean isEmpty() {
            return this.boxBounding == null && this.boxPoint == null;
        }
    }
}

