/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.client;

import com.google.common.base.Stopwatch;
import com.phylogeny.extrabitmanipulation.ExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.api.ChiselsAndBitsAPIAccess;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.client.Prism;
import com.phylogeny.extrabitmanipulation.client.gui.GuiBitToolSettingsMenu;
import com.phylogeny.extrabitmanipulation.config.ConfigShapeRender;
import com.phylogeny.extrabitmanipulation.config.ConfigShapeRenderPair;
import com.phylogeny.extrabitmanipulation.helper.BitAreaHelper;
import com.phylogeny.extrabitmanipulation.helper.BitToolSettingsHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.init.KeyBindingsExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.init.RenderLayersExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.item.ItemModelingTool;
import com.phylogeny.extrabitmanipulation.item.ItemSculptingTool;
import com.phylogeny.extrabitmanipulation.packet.PacketCollectArmorBlocks;
import com.phylogeny.extrabitmanipulation.packet.PacketCycleBitWrenchMode;
import com.phylogeny.extrabitmanipulation.packet.PacketOpenBitMappingGui;
import com.phylogeny.extrabitmanipulation.packet.PacketOpenChiseledArmorGui;
import com.phylogeny.extrabitmanipulation.packet.PacketOpenInventoryGui;
import com.phylogeny.extrabitmanipulation.packet.PacketReadBlockStates;
import com.phylogeny.extrabitmanipulation.packet.PacketSculpt;
import com.phylogeny.extrabitmanipulation.packet.PacketSetCollectionBox;
import com.phylogeny.extrabitmanipulation.packet.PacketThrowBit;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import java.util.concurrent.TimeUnit;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitLocation;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.api.ModKeyBinding;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Cylinder;
import org.lwjgl.util.glu.Disk;
import org.lwjgl.util.glu.Quadric;
import org.lwjgl.util.glu.Sphere;

public class ClientEventHandler {
    private float millisecondsElapsed;
    private static Stopwatch timer;
    private Vec3d drawnStartPoint = null;
    private Vec3i drawnStartPointModelingTool = null;
    private static final ResourceLocation ARROW_HEAD;
    private static final ResourceLocation ARROW_BIDIRECTIONAL;
    private static final ResourceLocation ARROW_CYCLICAL;
    private static final ResourceLocation CIRCLE;
    private static final ResourceLocation INVERSION;
    private static final int[] DIRECTION_FORWARD;
    private static final int[] DIRECTION_BACKWARD;
    private static final int[] AXIS_FORWARD;
    private static final int[] AXIS_BACKWARD;
    private static final int[] SHAPE_CURVED;
    private static final int[] SHAPE_FLAT;
    private boolean keyThrowBitIsDown;
    private static double BOUNDING_BOX_OFFSET;

    @SubscribeEvent
    public void registerTextures(TextureStitchEvent.Pre event) {
        this.registerTexture(ARROW_HEAD);
        this.registerTexture(ARROW_BIDIRECTIONAL);
        this.registerTexture(ARROW_CYCLICAL);
        this.registerTexture(CIRCLE);
        this.registerTexture(INVERSION);
        RenderLayersExtraBitManipulation.clearRenderMaps();
    }

    private void registerTexture(ResourceLocation resourceLocation) {
        SimpleTexture texture = new SimpleTexture(resourceLocation);
        Minecraft.func_71410_x().field_71446_o.func_110579_a(resourceLocation, (ITextureObject)texture);
    }

    @SubscribeEvent
    public void clearDisplayListsMaps(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        ClientHelper.getThreadListener().func_152344_a(new Runnable(){

            @Override
            public void run() {
                RenderLayersExtraBitManipulation.clearRenderMaps();
            }
        });
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        ItemStack stack;
        if (timer == null) {
            timer = Stopwatch.createStarted();
        }
        this.keyThrowBitIsDown = (ChiselsAndBitsAPIAccess.apiInstance.getItemType(stack = ClientHelper.getHeldItemMainhand()) == ItemType.CHISLED_BIT ? KeyBindingsExtraBitManipulation.THROW_BIT : KeyBindingsExtraBitManipulation.THROW_BIT_BIT_BAG).isKeyDown();
        if (ChiselsAndBitsAPIAccess.apiInstance.getKeyBinding(ModKeyBinding.MODE_MENU).func_151470_d() || KeyBindingsExtraBitManipulation.OPEN_BIT_MAPPING_GUI.isKeyDown() || KeyBindingsExtraBitManipulation.EDIT_DESIGN.isKeyDown() || KeyBindingsExtraBitManipulation.OPEN_CHISELED_ARMOR_GUI_MAIN.isKeyDown() || KeyBindingsExtraBitManipulation.OPEN_CHISELED_ARMOR_GUI_VANITY.isKeyDown() || KeyBindingsExtraBitManipulation.OPEN_CHISELED_ARMOR_SLOTS_GUI.isKeyDown()) {
            if (KeyBindingsExtraBitManipulation.OPEN_BIT_MAPPING_GUI.isKeyDown()) {
                if (ItemStackHelper.isModelingToolStack(stack) && ItemStackHelper.hasKey(stack, "savedStates")) {
                    this.openBitMappingGui();
                }
            } else if (KeyBindingsExtraBitManipulation.EDIT_DESIGN.isKeyDown()) {
                if (stack.func_77942_o() && ItemStackHelper.isDesignStack(stack)) {
                    this.openBitMappingGui();
                }
            } else if (KeyBindingsExtraBitManipulation.OPEN_CHISELED_ARMOR_GUI_MAIN.isKeyDown() || KeyBindingsExtraBitManipulation.OPEN_CHISELED_ARMOR_GUI_VANITY.isKeyDown()) {
                boolean openVanitySlots = KeyBindingsExtraBitManipulation.OPEN_CHISELED_ARMOR_GUI_VANITY.isKeyDown();
                boolean armorFound = false;
                for (int i = 2; i < EntityEquipmentSlot.values().length; ++i) {
                    if (!ItemStackHelper.isChiseledArmorStack(ItemStackHelper.getChiseledArmorStack(ClientHelper.getPlayer(), EntityEquipmentSlot.values()[i], !openVanitySlots))) continue;
                    armorFound = true;
                    break;
                }
                if (armorFound) {
                    ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketOpenChiseledArmorGui(!openVanitySlots));
                } else {
                    ClientHelper.printChatMessageWithDeletion("You must be wearing at least one piece of Chiseled Armor" + (openVanitySlots ? " in a vanity slot" : "") + " to open the Chiseled Armor GUI" + (openVanitySlots ? " for those slots." : "."));
                }
            } else if (KeyBindingsExtraBitManipulation.OPEN_CHISELED_ARMOR_SLOTS_GUI.isKeyDown()) {
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketOpenInventoryGui(false));
            } else if (ItemStackHelper.isBitToolStack(stack) || ItemStackHelper.isChiseledArmorStack(stack)) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiBitToolSettingsMenu());
            }
        }
    }

    @SubscribeEvent
    public void throwBit(TickEvent.PlayerTickEvent event) {
        boolean isBit;
        if (event.phase != TickEvent.Phase.START || !this.keyThrowBitIsDown) {
            return;
        }
        ItemStack stack = ClientHelper.getHeldItemMainhand();
        boolean bl = isBit = ChiselsAndBitsAPIAccess.apiInstance.getItemType(stack) == ItemType.CHISLED_BIT;
        if (!stack.func_190926_b() && (ChiselsAndBitsAPIAccess.apiInstance.getItemType(stack) == ItemType.BIT_BAG || timer.elapsed(TimeUnit.MILLISECONDS) > 150L && isBit)) {
            if (isBit) {
                timer = Stopwatch.createStarted();
            }
            ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketThrowBit());
        }
    }

    private void openBitMappingGui() {
        ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketOpenBitMappingGui());
    }

    /*
     * Unable to fully structure code
     */
    @SubscribeEvent
    public void interceptMouseInput(MouseEvent event) {
        player = ClientHelper.getPlayer();
        if (event.getDwheel() != 0) {
            stack = player.func_184614_ca();
            if (ItemStackHelper.isBitToolStack(stack)) {
                v0 = forward = event.getDwheel() < 0;
                if (KeyBindingsExtraBitManipulation.SHIFT.isKeyDown()) {
                    if (ItemStackHelper.isBitWrenchItem(stack.func_77973_b())) {
                        ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketCycleBitWrenchMode(forward));
                    } else {
                        this.cycleSemiDiameter(player, stack, forward);
                    }
                    event.setCanceled(true);
                } else if (ItemStackHelper.isSculptingToolItem(stack.func_77973_b()) && (KeyBindingsExtraBitManipulation.CONTROL.isKeyDown() || KeyBindingsExtraBitManipulation.ALT.isKeyDown())) {
                    if (KeyBindingsExtraBitManipulation.CONTROL.isKeyDown()) {
                        this.cycleDirection(player, stack, forward);
                    } else {
                        this.cycleWallThickness(player, stack, forward);
                    }
                    event.setCanceled(true);
                }
            } else {
                this.drawnStartPoint = null;
            }
        } else if ((KeyBindingsExtraBitManipulation.CONTROL.isKeyDown() || KeyBindingsExtraBitManipulation.ALT.isKeyDown()) && event.isButtonstate()) {
            stack = player.func_184614_ca();
            item = stack.func_77973_b();
            if (ItemStackHelper.isSculptingToolItem(item)) {
                if (KeyBindingsExtraBitManipulation.CONTROL.isKeyDown()) {
                    if (event.getButton() == 1) {
                        this.cycleShapeType(player, stack, item);
                    }
                    if (event.getButton() == 0) {
                        this.toggleBitGridTargeted(player, stack);
                    }
                } else {
                    if (event.getButton() == 1) {
                        this.toggleHollowShape(player, stack, item);
                    }
                    if (event.getButton() == 0) {
                        this.toggleOpenEnds(player, stack);
                    }
                }
                event.setCanceled(true);
            }
        } else if (event.getButton() == 0) {
            if (!player.field_71075_bZ.field_75099_e) {
                return;
            }
            stack = player.func_184614_ca();
            item = stack.func_77973_b();
            if (event.isButtonstate() && ItemStackHelper.isChiseledArmorItem(item) && (target = ClientHelper.getObjectMouseOver()) != null && target.field_72313_a == RayTraceResult.Type.BLOCK && (mode = BitToolSettingsHelper.getArmorMode(nbt = ItemStackHelper.getNBTOrNew(stack))) == 0) {
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetCollectionBox(player.field_70177_z, player.func_70093_af(), player.func_174811_aO().func_176734_d(), target.func_178782_a(), target.field_178784_b, target.field_72307_f));
                ClientHelper.printChatMessageWithDeletion("Set collection reference area for a " + ItemChiseledArmor.getPartAndScaleText(BitToolSettingsHelper.getArmorMovingPart(nbt, (ItemChiseledArmor)item), BitToolSettingsHelper.getArmorScale(nbt)));
                event.setCanceled(true);
            }
            if (event.isButtonstate() && ItemStackHelper.isBitWrenchItem(item)) {
                event.setCanceled(true);
            } else if (ItemStackHelper.isChiseledArmorItem(item) && BitToolSettingsHelper.getArmorMode(ItemStackHelper.getNBTOrNew(stack)) == 1 || ItemStackHelper.isSculptingToolItem(item)) {
                isArmor = ItemStackHelper.isChiseledArmorItem(item);
                v1 = isArmor != false ? true : (drawnMode = BitToolSettingsHelper.getSculptMode(stack.func_77978_p()) == 2);
                if (!drawnMode) {
                    this.drawnStartPoint = null;
                }
                if (event.isButtonstate() || drawnMode && this.drawnStartPoint != null) {
                    removeBits = isArmor != false ? true : ((ItemSculptingTool)item).removeBits();
                    target = ClientHelper.getObjectMouseOver();
                    shiftDown = KeyBindingsExtraBitManipulation.SHIFT.isKeyDown();
                    if (target != null && target.field_72313_a != RayTraceResult.Type.MISS) {
                        if (target.field_72313_a == RayTraceResult.Type.BLOCK) {
                            pos = target.func_178782_a();
                            side = target.field_178784_b;
                            hit = target.field_72307_f;
                            swingTool = true;
                            if (drawnMode && event.isButtonstate() && this.drawnStartPoint != null) {
                                event.setCanceled(true);
                                return;
                            }
                            if ((isArmor || !shiftDown) && drawnMode && event.isButtonstate()) {
                                if (isArmor && !ItemStackHelper.getNBTOrNew(stack).func_74764_b("hit")) {
                                    ClientHelper.printChatMessageWithDeletion("You must set a bodypart template reference area in 'Template Creation' mode before collecting block copies.");
                                    swingTool = false;
                                } else {
                                    bitLoc = ChiselsAndBitsAPIAccess.apiInstance.getBitPos((float)hit.field_72450_a - (float)pos.func_177958_n(), (float)hit.field_72448_b - (float)pos.func_177956_o(), (float)hit.field_72449_c - (float)pos.func_177952_p(), side, pos, false);
                                    if (bitLoc != null) {
                                        x = pos.func_177958_n();
                                        y = pos.func_177956_o();
                                        z = pos.func_177952_p();
                                        x2 = (float)x + (float)bitLoc.getBitX() * 0.0625f;
                                        y2 = (float)y + (float)bitLoc.getBitY() * 0.0625f;
                                        z2 = (float)z + (float)bitLoc.getBitZ() * 0.0625f;
                                        if (!removeBits) {
                                            x2 += (float)side.func_82601_c() * 0.0625f;
                                            y2 += (float)side.func_96559_d() * 0.0625f;
                                            z2 += (float)side.func_82599_e() * 0.0625f;
                                        }
                                        this.drawnStartPoint = new Vec3d((double)x2, (double)y2, (double)z2);
                                        if (isArmor && player.func_70093_af()) {
                                            vec = new Vec3d((double)side.func_82601_c(), (double)side.func_96559_d(), (double)side.func_82599_e());
                                            if (BitToolSettingsHelper.areArmorBitsTargeted(ItemStackHelper.getNBTOrNew(stack))) {
                                                vec = vec.func_186678_a(0.0625);
                                            }
                                            this.drawnStartPoint = this.drawnStartPoint.func_178787_e(vec);
                                        }
                                    } else {
                                        this.drawnStartPoint = null;
                                        swingTool = false;
                                    }
                                }
                            } else {
                                if (shiftDown && !isArmor) {
                                    api = ChiselsAndBitsAPIAccess.apiInstance;
                                    bitLoc = api.getBitPos((float)hit.field_72450_a - (float)pos.func_177958_n(), (float)hit.field_72448_b - (float)pos.func_177956_o(), (float)hit.field_72449_c - (float)pos.func_177952_p(), side, pos, false);
                                    if (bitLoc != null) {
                                        try {
                                            bitAccess = api.getBitAccess(player.field_70170_p, pos);
                                            bit = bitAccess.getBitAt(bitLoc.getBitX(), bitLoc.getBitY(), bitLoc.getBitZ());
                                            BitToolSettingsHelper.setBitStack(player, stack, removeBits, bit, removeBits != false ? Configs.sculptSetBitWire : Configs.sculptSetBitSpade);
                                            if (!(removeBits != false ? Configs.sculptSetBitWire : Configs.sculptSetBitSpade).shouldDisplayInChat()) ** GOTO lbl120
                                            ClientHelper.printChatMessageWithDeletion((removeBits != false ? "Removing only " : "Sculpting with ") + BitToolSettingsHelper.getBitName(bit.getItemStack(1)));
                                        }
                                        catch (APIExceptions.CannotBeChiseled e) {
                                            event.setCanceled(true);
                                            return;
                                        }
                                    }
                                } else if (!shiftDown || removeBits || drawnMode) {
                                    if (isArmor) {
                                        nbt = ItemStackHelper.getNBTOrNew(stack);
                                        collectionData = new BitToolSettingsHelper.ArmorCollectionData(nbt, (ItemChiseledArmor)item, this.getDrawnArmorCollectionBox(player, nbt, side, pos, hit));
                                        swingTool = ItemChiseledArmor.collectArmorBlocks(player, collectionData);
                                        ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketCollectArmorBlocks(collectionData));
                                    } else {
                                        sculptingData = new BitToolSettingsHelper.SculptingData(stack.func_77978_p(), (ItemSculptingTool)item);
                                        swingTool = ((ItemSculptingTool)item).sculptBlocks(stack, player, player.field_70170_p, pos, side, hit, this.drawnStartPoint, sculptingData);
                                        ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSculpt(pos, side, hit, this.drawnStartPoint, sculptingData));
                                    }
                                }
lbl120:
                                // 7 sources

                                if (drawnMode && !event.isButtonstate()) {
                                    this.drawnStartPoint = null;
                                }
                            }
                            if (swingTool) {
                                player.func_184609_a(EnumHand.MAIN_HAND);
                            }
                            event.setCanceled(true);
                        }
                    } else if (shiftDown && event.isButtonstate() && removeBits && !isArmor) {
                        BitToolSettingsHelper.setBitStack(player, stack, true, null, Configs.sculptSetBitWire);
                        if ((removeBits != false ? Configs.sculptSetBitWire : Configs.sculptSetBitSpade).shouldDisplayInChat()) {
                            ClientHelper.printChatMessageWithDeletion("Removing any/all bits");
                        }
                    } else if (drawnMode) {
                        this.drawnStartPoint = null;
                    }
                }
            }
        } else if (event.getButton() == 1 && event.isButtonstate() && ItemStackHelper.isModelingToolStack(stack = player.func_184614_ca()) && ItemStackHelper.hasKey(stack, "savedStates") && KeyBindingsExtraBitManipulation.SHIFT.isKeyDown()) {
            this.openBitMappingGui();
            event.setCanceled(true);
        }
        if (!event.isCanceled() && event.getButton() == 1 && event.isButtonstate() && ItemStackHelper.isSculptingToolStack(stack = player.func_184614_ca())) {
            this.cycleSculptMode(player, stack, KeyBindingsExtraBitManipulation.SHIFT.isKeyDown() == false);
        }
        if (event.getDwheel() != 0) {
            stack = player.func_184614_ca();
            isArmor = ItemStackHelper.isChiseledArmorStack(stack);
            if (isArmor || ItemStackHelper.isModelingToolStack(stack)) {
                forward = event.getDwheel() < 0;
                controlDown = KeyBindingsExtraBitManipulation.CONTROL.isKeyDown();
                if (controlDown || (isArmor != false ? KeyBindingsExtraBitManipulation.ALT.isKeyDown() != false : KeyBindingsExtraBitManipulation.SHIFT.isKeyDown() != false)) {
                    if (controlDown) {
                        if (isArmor) {
                            this.cycleArmorScale(player, stack, forward);
                        } else {
                            this.cycleModelSnapMode(player, stack, forward);
                        }
                    } else if (isArmor) {
                        this.cycleArmorMovingPart(player, stack, forward);
                    } else {
                        this.cycleModelAreaMode(player, stack, forward);
                    }
                    event.setCanceled(true);
                }
            } else {
                this.drawnStartPointModelingTool = null;
            }
        } else if ((KeyBindingsExtraBitManipulation.CONTROL.isKeyDown() || KeyBindingsExtraBitManipulation.ALT.isKeyDown()) && event.isButtonstate()) {
            stack = player.func_184614_ca();
            isArmor = ItemStackHelper.isChiseledArmorStack(stack);
            controlDown = KeyBindingsExtraBitManipulation.CONTROL.isKeyDown();
            if (isArmor || ItemStackHelper.isModelingToolStack(stack) && controlDown) {
                if (event.getButton() == 1) {
                    if (isArmor) {
                        if (controlDown) {
                            this.toggleArmorMode(player, stack);
                        } else {
                            this.toggleArmorBitsTargeted(player, stack);
                        }
                    } else {
                        this.toggleModelGuiOpen(player, stack);
                    }
                }
                event.setCanceled(true);
            }
        } else if (event.getButton() == 0 && ItemStackHelper.isModelingToolStack(stack = player.func_184614_ca()) && (item = stack.func_77973_b()) != null) {
            v2 = drawnMode = BitToolSettingsHelper.getModelAreaMode(stack.func_77978_p()) == 2;
            if (!drawnMode) {
                this.drawnStartPointModelingTool = null;
            }
            if (event.isButtonstate() || drawnMode && this.drawnStartPointModelingTool != null) {
                target = ClientHelper.getObjectMouseOver();
                if (target != null && target.field_72313_a != RayTraceResult.Type.MISS) {
                    if (target.field_72313_a == RayTraceResult.Type.BLOCK) {
                        pos = target.func_178782_a();
                        hit = target.field_72307_f;
                        swingTool = true;
                        if (drawnMode && event.isButtonstate() && this.drawnStartPointModelingTool != null) {
                            event.setCanceled(true);
                            return;
                        }
                        if (!KeyBindingsExtraBitManipulation.SHIFT.isKeyDown() && drawnMode && event.isButtonstate()) {
                            this.drawnStartPointModelingTool = new Vec3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                        } else {
                            if (!KeyBindingsExtraBitManipulation.SHIFT.isKeyDown() || drawnMode) {
                                modelingData = new BitToolSettingsHelper.ModelReadData(stack.func_77978_p());
                                swingTool = BitAreaHelper.readBlockStates(stack, player, player.field_70170_p, pos, hit, this.drawnStartPointModelingTool, modelingData);
                                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketReadBlockStates(pos, hit, this.drawnStartPointModelingTool, modelingData));
                            }
                            if (drawnMode && !event.isButtonstate()) {
                                this.drawnStartPointModelingTool = null;
                            }
                        }
                        if (swingTool) {
                            player.func_184609_a(EnumHand.MAIN_HAND);
                        }
                        event.setCanceled(true);
                    }
                } else if (drawnMode) {
                    this.drawnStartPointModelingTool = null;
                }
            }
        }
    }

    private void toggleArmorMode(EntityPlayer player, ItemStack stack) {
        int mode = BitToolSettingsHelper.cycleData(BitToolSettingsHelper.getArmorMode(stack.func_77978_p()), true, ItemChiseledArmor.MODE_TITLES.length);
        BitToolSettingsHelper.setArmorMode(player, stack, mode, Configs.armorMode);
        if (Configs.armorMode.shouldDisplayInChat()) {
            ClientHelper.printChatMessageWithDeletion(BitToolSettingsHelper.getArmorModeText(mode));
        }
    }

    private void toggleArmorBitsTargeted(EntityPlayer player, ItemStack stack) {
        boolean targetBits = !BitToolSettingsHelper.areArmorBitsTargeted(stack.func_77978_p());
        BitToolSettingsHelper.setArmorBitsTargeted(player, stack, targetBits, Configs.armorTargetBits);
        if (Configs.armorTargetBits.shouldDisplayInChat()) {
            ClientHelper.printChatMessageWithDeletion(BitToolSettingsHelper.getArmorBitsTargetedText(targetBits));
        }
    }

    private void cycleArmorScale(EntityPlayer player, ItemStack stack, boolean forward) {
        int scale = BitToolSettingsHelper.cycleData(BitToolSettingsHelper.getArmorScale(stack.func_77978_p()), forward, ItemChiseledArmor.SCALE_TITLES.length);
        BitToolSettingsHelper.setArmorScale(player, stack, scale, Configs.armorScale);
        if (Configs.armorScale.shouldDisplayInChat()) {
            ClientHelper.printChatMessageWithDeletion(BitToolSettingsHelper.getArmorScaleText(scale));
        }
    }

    private void cycleArmorMovingPart(EntityPlayer player, ItemStack stack, boolean forward) {
        ItemChiseledArmor armorPiece = (ItemChiseledArmor)stack.func_77973_b();
        int partIndex = BitToolSettingsHelper.getArmorMovingPart(stack.func_77978_p(), armorPiece).getPartIndex();
        partIndex = BitToolSettingsHelper.cycleData(partIndex, forward, armorPiece.MOVING_PART_TITLES.length);
        BitToolSettingsHelper.setArmorMovingPart(player, stack, armorPiece, partIndex);
        if (BitToolSettingsHelper.getArmorMovingPartConfig(armorPiece.field_77881_a).shouldDisplayInChat()) {
            ClientHelper.printChatMessageWithDeletion(BitToolSettingsHelper.getArmorMovingPartText(armorPiece.MOVING_PARTS[partIndex], armorPiece));
        }
    }

    private void cycleModelAreaMode(EntityPlayer player, ItemStack stack, boolean forward) {
        int mode = BitToolSettingsHelper.cycleData(BitToolSettingsHelper.getModelAreaMode(stack.func_77978_p()), forward, ItemModelingTool.AREA_MODE_TITLES.length);
        BitToolSettingsHelper.setModelAreaMode(player, stack, mode, Configs.modelAreaMode);
        if (Configs.modelAreaMode.shouldDisplayInChat()) {
            ClientHelper.printChatMessageWithDeletion(BitToolSettingsHelper.getModelAreaModeText(mode));
        }
    }

    private void cycleModelSnapMode(EntityPlayer player, ItemStack stack, boolean forward) {
        int mode = BitToolSettingsHelper.cycleData(BitToolSettingsHelper.getModelSnapMode(stack.func_77978_p()), forward, ItemModelingTool.SNAP_MODE_TITLES.length);
        BitToolSettingsHelper.setModelSnapMode(player, stack, mode, Configs.modelSnapMode);
        if (Configs.modelSnapMode.shouldDisplayInChat()) {
            ClientHelper.printChatMessageWithDeletion(BitToolSettingsHelper.getModelSnapModeText(mode));
        }
    }

    private void toggleModelGuiOpen(EntityPlayer player, ItemStack stack) {
        boolean modelGuiOpen = !BitToolSettingsHelper.getModelGuiOpen(stack.func_77978_p());
        BitToolSettingsHelper.setModelGuiOpen(player, stack, modelGuiOpen, Configs.modelGuiOpen);
        if (Configs.modelGuiOpen.shouldDisplayInChat()) {
            ClientHelper.printChatMessageWithDeletion(BitToolSettingsHelper.getModelGuiOpenText(modelGuiOpen));
        }
    }

    private void cycleSculptMode(EntityPlayer player, ItemStack stack, boolean forward) {
        int mode = BitToolSettingsHelper.cycleData(BitToolSettingsHelper.getSculptMode(stack.func_77978_p()), forward, ItemSculptingTool.MODE_TITLES.length);
        BitToolSettingsHelper.setSculptMode(player, stack, mode, Configs.sculptMode);
        if (Configs.sculptMode.shouldDisplayInChat()) {
            ClientHelper.printChatMessageWithDeletion(BitToolSettingsHelper.getSculptModeText(mode));
        }
    }

    private void cycleDirection(EntityPlayer player, ItemStack stack, boolean forward) {
        NBTTagCompound nbt = ItemStackHelper.getNBTOrNew(stack);
        int direction = BitToolSettingsHelper.getDirection(nbt);
        int shapeType = BitToolSettingsHelper.getShapeType(nbt, ((ItemSculptingTool)stack.func_77973_b()).isCurved());
        int rotation = direction / 6;
        direction %= 6;
        if (!(shapeType == 4 && (!forward ? rotation != 0 : rotation != 1) || shapeType == 5 && (!forward ? rotation != 0 : rotation != 3))) {
            int n = shapeType == 2 || shapeType > 3 ? (forward ? DIRECTION_FORWARD[direction] : DIRECTION_BACKWARD[direction]) : (direction = forward ? AXIS_FORWARD[direction] : AXIS_BACKWARD[direction]);
            rotation = forward ? 0 : (shapeType == 4 ? 1 : 3);
        } else {
            rotation = shapeType == 4 ? (rotation == 0 ? 1 : 0) : BitToolSettingsHelper.cycleData(rotation, forward, 4);
        }
        BitToolSettingsHelper.setDirection(player, stack, direction += 6 * rotation, Configs.sculptDirection);
        if (Configs.sculptDirection.shouldDisplayInChat()) {
            ClientHelper.printChatMessageWithDeletion(BitToolSettingsHelper.getDirectionText(direction, shapeType == 4 || shapeType == 5));
        }
    }

    private void cycleShapeType(EntityPlayer player, ItemStack stack, Item item) {
        boolean isCurved = ((ItemSculptingTool)item).isCurved();
        NBTTagCompound nbt = ItemStackHelper.getNBTOrNew(stack);
        int shapeType = BitToolSettingsHelper.getShapeType(nbt, isCurved);
        shapeType = isCurved ? SHAPE_CURVED[shapeType] : SHAPE_FLAT[shapeType];
        BitToolSettingsHelper.setShapeType(player, stack, isCurved, shapeType, isCurved ? Configs.sculptShapeTypeCurved : Configs.sculptShapeTypeFlat);
        if ((isCurved ? Configs.sculptShapeTypeCurved : Configs.sculptShapeTypeFlat).shouldDisplayInChat()) {
            ClientHelper.printChatMessageWithDeletion(BitToolSettingsHelper.getShapeTypeText(shapeType));
        }
    }

    private void toggleBitGridTargeted(EntityPlayer player, ItemStack stack) {
        boolean targetBitGrid = !BitToolSettingsHelper.isBitGridTargeted(stack.func_77978_p());
        BitToolSettingsHelper.setBitGridTargeted(player, stack, targetBitGrid, Configs.sculptTargetBitGridVertexes);
        if (Configs.sculptTargetBitGridVertexes.shouldDisplayInChat()) {
            ClientHelper.printChatMessageWithDeletion(BitToolSettingsHelper.getBitGridTargetedText(targetBitGrid));
        }
    }

    private void cycleSemiDiameter(EntityPlayer player, ItemStack stack, boolean forward) {
        int semiDiameter = BitToolSettingsHelper.cycleData(BitToolSettingsHelper.getSemiDiameter(stack.func_77978_p()), forward, Configs.maxSemiDiameter);
        BitToolSettingsHelper.setSemiDiameter(player, stack, semiDiameter, Configs.sculptSemiDiameter);
        if (Configs.sculptSemiDiameter.shouldDisplayInChat()) {
            ClientHelper.printChatMessageWithDeletion(BitToolSettingsHelper.getSemiDiameterText(stack.func_77978_p(), semiDiameter));
        }
    }

    private void toggleHollowShape(EntityPlayer player, ItemStack stack, Item item) {
        boolean isWire = ((ItemSculptingTool)item).removeBits();
        boolean isHollowShape = !BitToolSettingsHelper.isHollowShape(stack.func_77978_p(), isWire);
        BitToolSettingsHelper.setHollowShape(player, stack, isWire, isHollowShape, isWire ? Configs.sculptHollowShapeWire : Configs.sculptHollowShapeSpade);
        if ((isWire ? Configs.sculptHollowShapeWire : Configs.sculptHollowShapeSpade).shouldDisplayInChat()) {
            ClientHelper.printChatMessageWithDeletion(BitToolSettingsHelper.getHollowShapeText(isHollowShape));
        }
    }

    private void toggleOpenEnds(EntityPlayer player, ItemStack stack) {
        boolean areEndsOpen = !BitToolSettingsHelper.areEndsOpen(stack.func_77978_p());
        BitToolSettingsHelper.setEndsOpen(player, stack, areEndsOpen, Configs.sculptOpenEnds);
        if (Configs.sculptOpenEnds.shouldDisplayInChat()) {
            ClientHelper.printChatMessageWithDeletion(BitToolSettingsHelper.getOpenEndsText(areEndsOpen));
        }
    }

    private void cycleWallThickness(EntityPlayer player, ItemStack stack, boolean forward) {
        int wallThickness = BitToolSettingsHelper.cycleData(BitToolSettingsHelper.getWallThickness(stack.func_77978_p()), forward, Configs.maxWallThickness);
        BitToolSettingsHelper.setWallThickness(player, stack, wallThickness, Configs.sculptWallThickness);
        if (Configs.sculptWallThickness.shouldDisplayInChat()) {
            ClientHelper.printChatMessageWithDeletion(BitToolSettingsHelper.getWallThicknessText(wallThickness));
        }
    }

    @SubscribeEvent
    public void cancelBoundingBoxDraw(DrawBlockHighlightEvent event) {
        ItemStack stack = event.getPlayer().func_184614_ca();
        if (ItemStackHelper.isSculptingToolStack(stack) && BitToolSettingsHelper.getSculptMode(stack.func_77978_p()) == 1) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void renderBoxesSpheresAndOverlays(RenderWorldLastEvent event) {
        EntityPlayer player = ClientHelper.getPlayer();
        World world = player.field_70170_p;
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        RayTraceResult target = ClientHelper.getObjectMouseOver();
        Item item = stack.func_77973_b();
        boolean hitBlock = target != null && target.field_72313_a.equals((Object)RayTraceResult.Type.BLOCK);
        boolean isArmor = ItemStackHelper.isChiseledArmorItem(item);
        if (!(isArmor || hitBlock && ItemStackHelper.isBitToolItem(item))) {
            return;
        }
        IChiselAndBitsAPI api = ChiselsAndBitsAPIAccess.apiInstance;
        float ticks = event.getPartialTicks();
        double playerX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)ticks;
        double playerY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)ticks;
        double playerZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)ticks;
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder buffer = t.func_178180_c();
        if (isArmor) {
            NBTTagCompound nbt = ItemStackHelper.getNBTOrNew(stack);
            if (nbt.func_74764_b("hit")) {
                BitToolSettingsHelper.ArmorBodyPartTemplateBoxData boxData = new BitToolSettingsHelper.ArmorBodyPartTemplateBoxData(nbt, (ItemChiseledArmor)item);
                this.renderBodyPartTemplate(playerX, playerY, playerZ, boxData.getFacingBox(), t, buffer, boxData.getBox(), 0.0f);
            }
            if (!hitBlock) {
                return;
            }
        }
        EnumFacing dir = target.field_178784_b;
        BlockPos pos = target.func_178782_a();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        double diffX = playerX - (double)x;
        double diffY = playerY - (double)y;
        double diffZ = playerZ - (double)z;
        Vec3d hit = target.field_72307_f;
        if (ItemStackHelper.isBitWrenchItem(item) && api.isBlockChiseled(world, target.func_178782_a()) && !Configs.disableOverlays) {
            boolean mirrorInversion;
            double mirTravel;
            int mode = ItemStackHelper.getNBTOrNew(stack).func_74762_e("wrenchMode");
            if (timer == null) {
                timer = Stopwatch.createStarted();
            }
            this.millisecondsElapsed = timer.elapsed(TimeUnit.MILLISECONDS);
            int side = dir.ordinal();
            boolean upDown = side <= 1;
            boolean eastWest = side >= 4;
            boolean northSouth = !upDown && !eastWest;
            AxisAlignedBB box = new AxisAlignedBB(eastWest ? hit.field_72450_a : (double)x, upDown ? hit.field_72448_b : (double)y, northSouth ? hit.field_72449_c : (double)z, eastWest ? hit.field_72450_a : (double)(x + 1), upDown ? hit.field_72448_b : (double)(y + 1), northSouth ? hit.field_72449_c : (double)(z + 1));
            int offsetX = Math.abs(dir.func_82601_c());
            int offsetY = Math.abs(dir.func_96559_d());
            int offsetZ = Math.abs(dir.func_82599_e());
            double invOffsetX = offsetX ^ 1;
            double invOffsetY = offsetY ^ 1;
            double invOffsetZ = offsetZ ^ 1;
            boolean invertDirection = KeyBindingsExtraBitManipulation.SHIFT.isKeyDown();
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179098_w();
            GlStateManager.func_179094_E();
            double angle = this.getInitialAngle(mode);
            if (mode == 3) {
                if (side % 2 == 1) {
                    angle += 180.0;
                }
                if (side >= 4) {
                    angle -= 90.0;
                }
            } else {
                if (mode == 0) {
                    if (side % 2 == (invertDirection ? 0 : 1)) {
                        angle *= -1.0;
                    }
                } else if (side < 2 || side > 3) {
                    angle *= -1.0;
                }
                if (eastWest) {
                    angle += 90.0;
                }
                if (side == (mode == 1 ? 1 : 0) || side == 3 || side == 4) {
                    angle += 180.0;
                }
            }
            double offsetX2 = 0.5 * invOffsetX;
            double offsetY2 = 0.5 * invOffsetY;
            double offsetZ2 = 0.5 * invOffsetZ;
            double mirTravel1 = mirTravel = mode == 1 ? Configs.mirrorAmplitude * Math.cos(Math.PI * 2 * (double)this.millisecondsElapsed / (double)Configs.mirrorPeriod) : 0.0;
            double mirTravel2 = 0.0;
            boolean bl = mirrorInversion = invertDirection && mode == 1;
            if (mirrorInversion && side <= 1 && player.func_174811_aO().ordinal() > 3) {
                angle += 90.0;
                mirTravel1 = 0.0;
                mirTravel2 = mirTravel;
            }
            this.translateAndRotateTexture(playerX, playerY, playerZ, dir, upDown, eastWest, offsetX, offsetY, offsetZ, angle, diffX, diffY, diffZ, offsetX2, offsetY2, offsetZ2, mirTravel1, mirTravel2);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(mode == 0 ? ARROW_CYCLICAL : (mode == 1 ? ARROW_BIDIRECTIONAL : (mode == 2 ? CIRCLE : INVERSION)));
            float minU = 0.0f;
            float maxU = 1.0f;
            float minV = 0.0f;
            float maxV = 1.0f;
            if (mode == 0) {
                if (invertDirection) {
                    float minU2 = minU;
                    minU = maxU;
                    maxU = minU2;
                }
            } else if (mode == 2) {
                EnumFacing dir2 = side <= 1 ? EnumFacing.WEST : (side <= 3 ? EnumFacing.WEST : EnumFacing.DOWN);
                box = this.contractBoxOrRenderArrows(true, t, buffer, side, northSouth, dir2, box, invOffsetX, invOffsetY, invOffsetZ, invertDirection, minU, maxU, minV, maxV);
            }
            this.renderTexturedSide(t, buffer, side, northSouth, box, minU, maxU, minV, maxV, 1.0);
            GlStateManager.func_179121_F();
            AxisAlignedBB box3 = world.func_180495_p(pos).func_185918_c(world, pos);
            for (int s = 0; s < 6; ++s) {
                if (s == side) continue;
                GlStateManager.func_179094_E();
                upDown = s <= 1;
                eastWest = s >= 4;
                northSouth = !upDown && !eastWest;
                dir = EnumFacing.func_82600_a((int)s);
                box = new AxisAlignedBB(eastWest ? (s == 5 ? box3.field_72336_d : box3.field_72340_a) : (double)x, upDown ? (s == 1 ? box3.field_72337_e : box3.field_72338_b) : (double)y, northSouth ? (s == 3 ? box3.field_72334_f : box3.field_72339_c) : (double)z, eastWest ? (s == 4 ? box3.field_72340_a : box3.field_72336_d) : (double)(x + 1), upDown ? (s == 0 ? box3.field_72338_b : box3.field_72337_e) : (double)(y + 1), northSouth ? (s == 2 ? box3.field_72339_c : box3.field_72334_f) : (double)(z + 1));
                angle = this.getInitialAngle(mode);
                boolean oppRotation = false;
                int mode2 = mode;
                if (mode != 3) {
                    boolean bl2 = oppRotation = dir == EnumFacing.func_82600_a((int)side).func_176734_d();
                    if (mode == 0) {
                        if (!oppRotation) {
                            Minecraft.func_71410_x().field_71446_o.func_110577_a(ARROW_HEAD);
                            angle = 90.0;
                            if (side % 2 == 0) {
                                angle += 180.0;
                            }
                            if (invertDirection) {
                                angle += 180.0;
                            }
                            mode2 = 2;
                        } else {
                            Minecraft.func_71410_x().field_71446_o.func_110577_a(ARROW_CYCLICAL);
                            mode2 = 0;
                        }
                    } else if (mode == 2) {
                        if (!oppRotation) {
                            Minecraft.func_71410_x().field_71446_o.func_110577_a(ARROW_HEAD);
                            if (side == 0 ? s == 2 || s == 5 : (side == 1 ? s == 3 || s == 4 : (side == 2 ? s == 1 || s == 5 : (side == 3 ? s == 0 || s == 4 : (side == 4 ? s == 1 || s == 2 : s == 0 || s == 3))))) {
                                angle += 180.0;
                            }
                            if (invertDirection) {
                                angle += 180.0;
                            }
                        } else {
                            Minecraft.func_71410_x().field_71446_o.func_110577_a(CIRCLE);
                        }
                    }
                }
                mirTravel1 = mirTravel;
                mirTravel2 = 0.0;
                if (mode != 3 && ((side <= 1 && mirrorInversion ? side > 1 : side <= 1) && s > 1 || (mirrorInversion ? (oppRotation ? player.func_174811_aO().ordinal() > 3 : side > 3) : side == 2 || side == 3) && s <= 1)) {
                    angle += 90.0;
                    mirTravel1 = 0.0;
                    mirTravel2 = mirTravel;
                }
                if (mode == 3) {
                    if (s % 2 == 1) {
                        angle += 180.0;
                    }
                    if (s >= 4) {
                        angle -= 90.0;
                    }
                } else {
                    if (mode2 == 0) {
                        if (s % 2 == (invertDirection ? 0 : 1)) {
                            angle *= -1.0;
                        }
                        if (oppRotation) {
                            angle *= -1.0;
                        }
                    } else if (s < 2 || s > 3) {
                        angle *= -1.0;
                    }
                    if (eastWest) {
                        angle -= 90.0;
                    }
                    if (s == (mode2 == 1 ? 1 : 0) || s == 3 || s == 5) {
                        angle += 180.0;
                    }
                }
                offsetX = Math.abs(dir.func_82601_c());
                offsetY = Math.abs(dir.func_96559_d());
                offsetZ = Math.abs(dir.func_82599_e());
                invOffsetX = offsetX ^ 1;
                invOffsetY = offsetY ^ 1;
                invOffsetZ = offsetZ ^ 1;
                offsetX2 = 0.5 * invOffsetX;
                offsetY2 = 0.5 * invOffsetY;
                offsetZ2 = 0.5 * invOffsetZ;
                this.translateAndRotateTexture(playerX, playerY, playerZ, dir, upDown, eastWest, offsetX, offsetY, offsetZ, angle, diffX, diffY, diffZ, offsetX2, offsetY2, offsetZ2, mirTravel1, mirTravel2);
                minU = 0.0f;
                maxU = 1.0f;
                minV = 0.0f;
                maxV = 1.0f;
                if (mode2 == 0) {
                    if (oppRotation) {
                        minU = 1.0f;
                        maxU = 0.0f;
                    }
                    if (invertDirection) {
                        float minU2 = minU;
                        minU = maxU;
                        maxU = minU2;
                    }
                } else if (mode2 == 2) {
                    EnumFacing dir2 = side <= 1 ? (s == 2 || s == 3 ? EnumFacing.WEST : EnumFacing.DOWN) : (side >= 4 ? EnumFacing.WEST : (s <= 1 ? EnumFacing.WEST : EnumFacing.DOWN));
                    box = this.contractBoxOrRenderArrows(oppRotation, t, buffer, side, northSouth, dir2, box, invOffsetX, invOffsetY, invOffsetZ, invertDirection, minU, maxU, minV, maxV);
                }
                if (mode2 != 2 || oppRotation) {
                    this.renderTexturedSide(t, buffer, s, northSouth, box, minU, maxU, minV, maxV, 1.0);
                }
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
        } else if (ItemStackHelper.isSculptingToolItem(item)) {
            float hitZ;
            float hitY;
            float hitX;
            IBitLocation bitLoc;
            ItemSculptingTool toolItem = (ItemSculptingTool)item;
            boolean removeBits = toolItem.removeBits();
            int mode = BitToolSettingsHelper.getSculptMode(stack.func_77978_p());
            if ((!removeBits || mode > 0 || api.canBeChiseled(world, target.func_178782_a())) && (bitLoc = api.getBitPos(hitX = (float)hit.field_72450_a - (float)pos.func_177958_n(), hitY = (float)hit.field_72448_b - (float)pos.func_177956_o(), hitZ = (float)hit.field_72449_c - (float)pos.func_177952_p(), dir, pos, false)) != null) {
                boolean isHollow;
                NBTTagCompound nbt = ItemStackHelper.getNBTOrNew(stack);
                int x2 = bitLoc.getBitX();
                int y2 = bitLoc.getBitY();
                int z2 = bitLoc.getBitZ();
                if (!toolItem.removeBits()) {
                    x2 += dir.func_82601_c();
                    y2 += dir.func_96559_d();
                    z2 += dir.func_82599_e();
                }
                boolean isDrawn = this.drawnStartPoint != null;
                boolean drawnBox = mode == 2 && isDrawn;
                int shapeType = BitToolSettingsHelper.getShapeType(nbt, toolItem.isCurved());
                boolean fixedNotSym = !drawnBox && shapeType == 2 || shapeType > 4;
                this.glStart();
                double r = (double)BitToolSettingsHelper.getSemiDiameter(nbt) * 0.0625;
                ConfigShapeRenderPair configPair = Configs.itemShapeMap.get((Object)toolItem);
                ConfigShapeRender configBox = configPair.boundingBox;
                AxisAlignedBB box = null;
                AxisAlignedBB shapeBox = null;
                double x3 = (double)x + (double)x2 * 0.0625;
                double y3 = (double)y + (double)y2 * 0.0625;
                double z3 = (double)z + (double)z2 * 0.0625;
                if (configBox.renderInnerShape || configBox.renderOuterShape) {
                    GlStateManager.func_179094_E();
                    GL11.glLineWidth((float)configBox.lineWidth);
                    boolean inside = ItemSculptingTool.wasInsideClicked(dir, hit, pos);
                    if (drawnBox) {
                        double x4 = this.drawnStartPoint.field_72450_a;
                        double y4 = this.drawnStartPoint.field_72448_b;
                        double z4 = this.drawnStartPoint.field_72449_c;
                        if (Math.max(x3, x4) == x3) {
                            x3 += 0.0625;
                        } else {
                            x4 += 0.0625;
                        }
                        if (Math.max(y3, y4) == y3) {
                            y3 += 0.0625;
                        } else {
                            y4 += 0.0625;
                        }
                        if (Math.max(z3, z4) == z3) {
                            z3 += 0.0625;
                        } else {
                            z4 += 0.0625;
                        }
                        box = new AxisAlignedBB(x4, y4, z4, x3, y3, z3);
                    } else {
                        double f = 0.0;
                        Vec3d vecOffset = new Vec3d(0.0, 0.0, 0.0);
                        boolean targetBitGrid = BitToolSettingsHelper.isBitGridTargeted(nbt);
                        if (mode == 2) {
                            r = 0.0;
                        } else if (targetBitGrid) {
                            f = 0.03125;
                            vecOffset = BitAreaHelper.getBitGridOffset(dir, inside, hitX, hitY, hitZ, removeBits);
                            r -= f;
                        }
                        box = new AxisAlignedBB((double)x - r, (double)y - r, (double)z - r, (double)x + r + 0.0625, (double)y + r + 0.0625, (double)z + r + 0.0625).func_72317_d((double)x2 * 0.0625 + f * vecOffset.field_72450_a, (double)y2 * 0.0625 + f * vecOffset.field_72448_b, (double)z2 * 0.0625 + f * vecOffset.field_72449_c);
                        boolean placementOffset = BitToolSettingsHelper.isShapeOffset(nbt) && !removeBits && mode != 2;
                        double r2 = r + (targetBitGrid ? 0.03125 : 0.0);
                        if (placementOffset) {
                            box = box.func_72317_d((double)dir.func_82601_c() * r2, (double)dir.func_96559_d() * r2, (double)dir.func_82599_e() * r2);
                        }
                        if (targetBitGrid && mode != 2) {
                            x3 = (box.field_72336_d + box.field_72340_a) * 0.5 - f;
                            y3 = (box.field_72337_e + box.field_72338_b) * 0.5 - f;
                            z3 = (box.field_72334_f + box.field_72339_c) * 0.5 - f;
                        }
                        if (!targetBitGrid && placementOffset) {
                            x3 += (double)dir.func_82601_c() * r2;
                            y3 += (double)dir.func_96559_d() * r2;
                            z3 += (double)dir.func_82599_e() * r2;
                        }
                    }
                    if (fixedNotSym) {
                        shapeBox = box.func_186662_g(0.0);
                    }
                    if (mode == 0) {
                        BlockPos pos2 = !removeBits && !inside ? pos.func_177972_a(dir) : pos;
                        AxisAlignedBB box2 = !removeBits ? new AxisAlignedBB(pos2) : world.func_180495_p(pos2).func_185918_c(world, pos2);
                        box = this.limitBox(box, box2);
                    }
                    if (configBox.renderOuterShape) {
                        RenderGlobal.func_189697_a((AxisAlignedBB)box.func_186662_g(BOUNDING_BOX_OFFSET).func_72317_d(-playerX, -playerY, -playerZ), (float)configBox.red, (float)configBox.green, (float)configBox.blue, (float)configBox.outerShapeAlpha);
                    }
                    if (configBox.renderInnerShape) {
                        GlStateManager.func_179143_c((int)516);
                        RenderGlobal.func_189697_a((AxisAlignedBB)box.func_186662_g(BOUNDING_BOX_OFFSET).func_72317_d(-playerX, -playerY, -playerZ), (float)configBox.red, (float)configBox.green, (float)configBox.blue, (float)configBox.innerShapeAlpha);
                        GlStateManager.func_179143_c((int)515);
                    }
                    GlStateManager.func_179121_F();
                }
                if (!fixedNotSym && box != null) {
                    shapeBox = box.func_186662_g(0.0);
                }
                boolean isOpen = (isHollow = BitToolSettingsHelper.isHollowShape(nbt, removeBits)) && BitToolSettingsHelper.areEndsOpen(nbt);
                this.renderEnvelopedShapes(shapeType, nbt, playerX, playerY, playerZ, isDrawn, drawnBox, r, configPair, shapeBox, x3, y3, z3, 0.0, isOpen);
                float wallThickness = (float)BitToolSettingsHelper.getWallThickness(nbt) * 0.0625f;
                if (wallThickness > 0.0f && isHollow && (mode != 2 || drawnBox)) {
                    this.renderEnvelopedShapes(shapeType, nbt, playerX, playerY, playerZ, isDrawn, drawnBox, r, configPair, shapeBox, x3, y3, z3, wallThickness, isOpen);
                }
                this.glEnd();
            }
        } else if (ItemStackHelper.isModelingToolItem(item)) {
            this.glStart();
            BitAreaHelper.ModelingBoxSet boxSet = BitAreaHelper.getModelingToolBoxSet(player, x, y, z, hit, this.drawnStartPointModelingTool, true, BitToolSettingsHelper.getModelAreaMode(stack.func_77978_p()), BitToolSettingsHelper.getModelSnapMode(stack.func_77978_p()));
            if (!boxSet.isEmpty()) {
                this.renderBoundingBox(boxSet.getBoundingBox().func_72317_d(-playerX, -playerY, -playerZ), 1.0f, 1.0f, 1.0f, 115);
                if (boxSet.hasPoint()) {
                    this.renderBoundingBox(boxSet.getPoint().func_72317_d(-playerX, -playerY, -playerZ), 1.0f, 1.0f, 1.0f, 155);
                }
            }
            this.glEnd();
        } else if (ItemStackHelper.isChiseledArmorItem(item)) {
            NBTTagCompound nbt = ItemStackHelper.getNBTOrNew(stack);
            int mode = BitToolSettingsHelper.getArmorMode(nbt);
            if (hitBlock) {
                if (mode == 0) {
                    EnumFacing facingBox = player.func_174811_aO().func_176734_d();
                    AxisAlignedBB box = ItemChiseledArmor.getBodyPartTemplateBox(player, dir, pos, hit, BitToolSettingsHelper.getArmorScale(nbt), BitToolSettingsHelper.getArmorMovingPart(nbt, (ItemChiseledArmor)item));
                    if (box != null) {
                        this.renderBodyPartTemplate(playerX, playerY, playerZ, facingBox, t, buffer, box, 1.0f);
                    }
                } else {
                    this.glStart();
                    this.renderBoundingBox(this.getDrawnArmorCollectionBox(player, nbt, dir, pos, hit).func_72317_d(-playerX, -playerY, -playerZ).func_186662_g(BOUNDING_BOX_OFFSET), 0.0f, 0.0f, 0.0f, 155);
                    this.glEnd();
                }
            }
        }
    }

    private AxisAlignedBB getDrawnArmorCollectionBox(EntityPlayer player, NBTTagCompound nbt, EnumFacing dir, BlockPos pos, Vec3d hit) {
        double offset;
        double z4;
        double y4;
        double x4;
        boolean targetBits = BitToolSettingsHelper.areArmorBitsTargeted(nbt);
        double x3 = 0.0;
        double y3 = 0.0;
        double z3 = 0.0;
        if (targetBits) {
            float hitZ;
            float hitY;
            float hitX = (float)hit.field_72450_a - (float)pos.func_177958_n();
            IBitLocation bitLoc = ChiselsAndBitsAPIAccess.apiInstance.getBitPos(hitX, hitY = (float)hit.field_72448_b - (float)pos.func_177956_o(), hitZ = (float)hit.field_72449_c - (float)pos.func_177952_p(), dir, pos, false);
            if (bitLoc != null) {
                int x2 = bitLoc.getBitX();
                int y2 = bitLoc.getBitY();
                int z2 = bitLoc.getBitZ();
                x3 = (double)pos.func_177958_n() + (double)x2 * 0.0625;
                y3 = (double)pos.func_177956_o() + (double)y2 * 0.0625;
                z3 = (double)pos.func_177952_p() + (double)z2 * 0.0625;
                if (player.func_70093_af()) {
                    x3 += (double)dir.func_82601_c() * 0.0625;
                    y3 += (double)dir.func_96559_d() * 0.0625;
                    z3 += (double)dir.func_82599_e() * 0.0625;
                }
            }
        } else {
            x3 = pos.func_177958_n();
            y3 = pos.func_177956_o();
            z3 = pos.func_177952_p();
            if (player.func_70093_af()) {
                x3 += (double)dir.func_82601_c();
                y3 += (double)dir.func_96559_d();
                z3 += (double)dir.func_82599_e();
            }
        }
        if (this.drawnStartPoint != null) {
            x4 = this.drawnStartPoint.field_72450_a;
            y4 = this.drawnStartPoint.field_72448_b;
            z4 = this.drawnStartPoint.field_72449_c;
        } else {
            x4 = x3;
            y4 = y3;
            z4 = z3;
        }
        if (!targetBits) {
            x4 = Math.floor(x4);
            y4 = Math.floor(y4);
            z4 = Math.floor(z4);
            offset = 1.0;
        } else {
            offset = 0.0625;
        }
        if (Math.max(x3, x4) == x3) {
            x3 += offset;
        } else {
            x4 += offset;
        }
        if (Math.max(y3, y4) == y3) {
            y3 += offset;
        } else {
            y4 += offset;
        }
        if (Math.max(z3, z4) == z3) {
            z3 += offset;
        } else {
            z4 += offset;
        }
        return new AxisAlignedBB(x4, y4, z4, x3, y3, z3);
    }

    private void renderBodyPartTemplate(double playerX, double playerY, double playerZ, EnumFacing facingBox, Tessellator t, BufferBuilder buffer, AxisAlignedBB box, float redBlue) {
        this.glStart();
        box = box.func_72317_d(-playerX, -playerY, -playerZ).func_186662_g(BOUNDING_BOX_OFFSET);
        this.renderBoundingBox(box, redBlue, 1.0f, redBlue, 155);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            boolean flag;
            boolean isFront;
            boolean bl = isFront = face == facingBox;
            if (isFront) {
                GL11.glColor4d((double)0.0, (double)0.0, (double)1.0, (double)0.5);
            } else {
                GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)0.5);
            }
            boolean northSouth = face.func_176740_k() == EnumFacing.Axis.Z;
            double minX = box.field_72340_a;
            double minY = box.field_72338_b;
            double minZ = box.field_72339_c;
            double maxX = box.field_72336_d;
            double maxY = box.field_72337_e;
            double maxZ = box.field_72334_f;
            if (face.func_176740_k() == EnumFacing.Axis.X) {
                maxX = face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? box.field_72336_d : box.field_72340_a;
                minX = maxX;
            } else if (face.func_176740_k() == EnumFacing.Axis.Y) {
                maxY = face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? box.field_72337_e : box.field_72338_b;
                minY = maxY;
            } else {
                maxZ = face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? box.field_72334_f : box.field_72339_c;
                minZ = maxZ;
            }
            boolean bl2 = flag = face.func_176743_c() == (face.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.AxisDirection.NEGATIVE : EnumFacing.AxisDirection.POSITIVE);
            if (flag || isFront) {
                buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                buffer.func_181662_b(minX, minY, minZ).func_181675_d();
                buffer.func_181662_b(maxX, northSouth ? minY : maxY, minZ).func_181675_d();
                buffer.func_181662_b(maxX, maxY, maxZ).func_181675_d();
                buffer.func_181662_b(minX, northSouth ? maxY : minY, maxZ).func_181675_d();
                t.func_78381_a();
            }
            if (flag && !isFront) continue;
            buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            buffer.func_181662_b(minX, northSouth ? maxY : minY, maxZ).func_181675_d();
            buffer.func_181662_b(maxX, maxY, maxZ).func_181675_d();
            buffer.func_181662_b(maxX, northSouth ? minY : maxY, minZ).func_181675_d();
            buffer.func_181662_b(minX, minY, minZ).func_181675_d();
            t.func_78381_a();
        }
        this.glEnd();
    }

    private void glStart() {
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
    }

    private void glEnd() {
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    private void renderBoundingBox(AxisAlignedBB boxBounding, float red, float green, float blue, int outerAlpha) {
        RenderGlobal.func_189697_a((AxisAlignedBB)boxBounding, (float)red, (float)green, (float)blue, (float)((float)outerAlpha / 255.0f));
        GlStateManager.func_179143_c((int)516);
        RenderGlobal.func_189697_a((AxisAlignedBB)boxBounding, (float)red, (float)green, (float)blue, (float)0.10980392f);
        GlStateManager.func_179143_c((int)515);
    }

    private void renderEnvelopedShapes(int shapeType, NBTTagCompound nbt, double playerX, double playerY, double playerZ, boolean isDrawn, boolean drawnBox, double r, ConfigShapeRenderPair configPair, AxisAlignedBB box, double x, double y, double z, double contraction, boolean isOpen) {
        ConfigShapeRender configShape = configPair.envelopedShape;
        if (configShape.renderInnerShape || configShape.renderOuterShape) {
            boolean openSym;
            double v;
            double a = 0.0;
            double b = 0.0;
            double c = 0.0;
            int dir = BitToolSettingsHelper.getDirection(nbt);
            dir %= 6;
            boolean notFullSym = shapeType != 0 && shapeType != 3;
            boolean notSym = shapeType == 2 || shapeType > 4;
            double ri = r + 0.03125;
            r = Math.max(ri - contraction, 0.0);
            boolean drawnNotSym = notSym && drawnBox;
            double base = 0.0;
            if (drawnBox || notSym) {
                double f = 0.5;
                double minX = box.field_72340_a * f;
                double minY = box.field_72338_b * f;
                double minZ = box.field_72339_c * f;
                double maxX = box.field_72336_d * f;
                double maxY = box.field_72337_e * f;
                double maxZ = box.field_72334_f * f;
                double x2 = maxX - minX;
                double y2 = maxY - minY;
                double z2 = maxZ - minZ;
                if (drawnNotSym) {
                    if (dir == 2 || dir == 3) {
                        v = y2;
                        y2 = z2;
                        z2 = v;
                    } else if (dir > 3) {
                        v = y2;
                        y2 = x2;
                        x2 = v;
                    }
                }
                if (notSym && contraction > 0.0) {
                    if (!isOpen) {
                        base = contraction;
                    }
                    double y2sq = (y2 *= 2.0) * y2;
                    double aInset = Math.sqrt(x2 * x2 + y2sq) * contraction / x2 + base;
                    double cInset = Math.sqrt(z2 * z2 + y2sq) * contraction / z2 + base;
                    a = Math.max((y2 - aInset) * (x2 / y2), 0.0);
                    c = Math.max((y2 - cInset) * (z2 / y2), 0.0);
                    contraction = Math.min(aInset - base, cInset - base);
                    b = Math.max(y2 * 0.5 - contraction * 0.5 - base * 0.5, 0.0);
                } else {
                    a = Math.max(x2 - (!isOpen || !notFullSym || dir < 4 ? contraction : 0.0), 0.0);
                    c = Math.max(z2 - (!isOpen || !notFullSym || dir != 2 && dir != 3 ? contraction : 0.0), 0.0);
                    b = Math.max(y2 - (!isOpen || !notFullSym || dir > 1 ? contraction : 0.0), 0.0);
                }
                r = Math.max(Math.max(a, b), c);
                x = maxX + minX;
                y = maxY + minY;
                z = maxZ + minZ;
                if (drawnBox) {
                    if (notSym || !notFullSym) {
                        if (dir < 2 || dir > 3 || !notFullSym) {
                            v = b;
                            b = c;
                            c = v;
                        }
                    } else if (dir < 2) {
                        v = b;
                        b = c;
                        c = v;
                    } else if (dir > 3) {
                        v = a;
                        a = c;
                        c = v;
                    } else {
                        v = b;
                        b = a;
                        a = v;
                    }
                }
            } else {
                b = c = r;
                a = c;
                if (b > 0.0 && notFullSym && isOpen) {
                    b += contraction * (double)(!isDrawn ? 1 : 0);
                }
            }
            Prism shape = shapeType > 2 ? new Prism(shapeType > 4, shapeType == 4 || shapeType == 5) : (notFullSym ? new Cylinder() : new Sphere());
            shape.setDrawStyle(100011);
            Disk lid = new Disk();
            lid.setDrawStyle(100011);
            GlStateManager.func_179094_E();
            GL11.glLineWidth((float)configShape.lineWidth);
            double x2 = x - playerX;
            double y2 = y - playerY;
            double z2 = z - playerZ;
            if (!notSym && !isDrawn) {
                double hp = 0.03125;
                x2 += hp;
                y2 += hp;
                z2 += hp;
            }
            if (notFullSym && isOpen && contraction > 0.0 && !notSym) {
                double offset = contraction * (notSym ? 0.5 : (double)(drawnBox ? 0 : -1));
                if (dir != 3) {
                    y2 += dir == 0 ? offset : -offset;
                }
                if (dir > 2) {
                    x2 += dir == 5 ? -offset : offset;
                }
                if (dir == 2 || dir == 3) {
                    z2 += dir == 2 ? offset : -offset;
                }
            }
            GlStateManager.func_179137_b((double)x2, (double)y2, (double)z2);
            int rot2 = dir;
            if (!drawnNotSym || dir != 2) {
                if (notFullSym && rot2 != 1) {
                    int angle = 90;
                    if (rot2 == 3) {
                        rot2 = 0;
                        angle = 180;
                        if (!drawnNotSym || dir != 3) {
                            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        }
                    } else {
                        rot2 = rot2 > 1 ? (rot2 %= 4) : (rot2 ^= 5);
                    }
                    Vec3i vec = EnumFacing.func_82600_a((int)rot2).func_176734_d().func_176730_m();
                    GlStateManager.func_179114_b((float)angle, (float)vec.func_177958_n(), (float)vec.func_177956_o(), (float)vec.func_177952_p());
                } else {
                    GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
            }
            boolean bl = openSym = notFullSym && !notSym && isOpen && !isDrawn;
            if (notFullSym) {
                double offset1 = 0.0;
                double offset2 = 0.0;
                double r2 = r;
                if (notSym) {
                    r2 -= contraction * 0.5 - base * 0.5;
                } else if (openSym) {
                    double m = -contraction;
                    if (dir == 0) {
                        m *= 2.0;
                    }
                    if (dir != 1) {
                        r -= m;
                    }
                    if (dir > 1) {
                        if (dir < 3) {
                            offset1 = m;
                        } else {
                            offset2 = m;
                        }
                    }
                }
                GlStateManager.func_179137_b((double)offset1, (double)offset2, (double)(-r2));
            }
            if (openSym) {
                v = b;
                b = c;
                c = v;
            }
            if (drawnNotSym) {
                if (dir == 2 || dir == 3) {
                    v = b;
                    b = c;
                    c = v;
                } else if (dir > 3) {
                    v = b;
                    b = a;
                    a = v;
                }
            }
            if (notFullSym && drawnBox) {
                if (b > c && b > a) {
                    GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(b - c));
                } else if (a > c && a >= b) {
                    GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(a - c));
                }
            }
            GlStateManager.func_179139_a((double)(a / ri), (double)(b / ri), (double)(c / ri));
            if (configShape.renderOuterShape) {
                this.drawEnvelopedShapes(ri, configShape, shapeType, shape, (Quadric)lid, true, notSym, isOpen);
            }
            if (configShape.renderInnerShape) {
                GlStateManager.func_179143_c((int)516);
                this.drawEnvelopedShapes(ri, configShape, shapeType, shape, (Quadric)lid, false, notSym, isOpen);
                GlStateManager.func_179143_c((int)515);
            }
            GlStateManager.func_179121_F();
        }
    }

    private void drawEnvelopedShapes(double r, ConfigShapeRender configShape, int shapeType, Quadric shape, Quadric lid, boolean isOuter, boolean isCylinder, boolean isOpen) {
        GlStateManager.func_179094_E();
        this.drawEnvelopedShape(shape, r, isOuter, configShape, isCylinder, isOpen);
        if (shapeType > 0 && shapeType < 3 && !isOpen) {
            if (shapeType == 1) {
                this.drawEnvelopedShape(lid, r, isOuter, configShape, isCylinder, isOpen);
            }
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(r * 2.0));
            this.drawEnvelopedShape(lid, r, isOuter, configShape, isCylinder, isOpen);
        }
        GlStateManager.func_179121_F();
    }

    private void drawEnvelopedShape(Quadric shape, double radius, boolean isOuter, ConfigShapeRender configShape, boolean isCone, boolean isOpen) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)configShape.red, (float)configShape.green, (float)configShape.blue, (float)(isOuter ? configShape.outerShapeAlpha : configShape.innerShapeAlpha));
        float r = (float)radius;
        if (shape instanceof Prism) {
            ((Prism)shape).draw(r, isOpen);
        } else if (shape instanceof Sphere) {
            ((Sphere)shape).draw(r, 32, 32);
        } else if (shape instanceof Cylinder) {
            ((Cylinder)shape).draw(isCone ? 0.0f : r, r, r * 2.0f, 32, 32);
        } else if (shape instanceof Disk) {
            ((Disk)shape).draw(0.0f, r, 32, 32);
        }
        GlStateManager.func_179121_F();
    }

    private AxisAlignedBB limitBox(AxisAlignedBB box, AxisAlignedBB mask) {
        double d0 = Math.max(box.field_72340_a, mask.field_72340_a);
        double d1 = Math.max(box.field_72338_b, mask.field_72338_b);
        double d2 = Math.max(box.field_72339_c, mask.field_72339_c);
        double d3 = Math.min(box.field_72336_d, mask.field_72336_d);
        double d4 = Math.min(box.field_72337_e, mask.field_72337_e);
        double d5 = Math.min(box.field_72334_f, mask.field_72334_f);
        return new AxisAlignedBB(d0, d1, d2, d3, d4, d5);
    }

    private double getInitialAngle(int mode) {
        return mode == 0 ? (double)this.millisecondsElapsed * (360.0 / (double)Configs.rotationPeriod) % 360.0 : 0.0;
    }

    private void translateAndRotateTexture(double playerX, double playerY, double playerZ, EnumFacing dir, boolean upDown, boolean eastWest, int offsetX, int offsetY, int offsetZ, double angle, double diffX, double diffY, double diffZ, double offsetX2, double offsetY2, double offsetZ2, double mirTravel1, double mirTravel2) {
        double cos = Math.cos(Math.toRadians(angle));
        double sin = Math.sin(Math.toRadians(angle));
        if (upDown) {
            GL11.glTranslated((double)(diffX * cos + diffZ * sin - diffX + mirTravel1), (double)0.0, (double)(-diffX * sin + diffZ * cos - diffZ + mirTravel2));
        } else if (eastWest) {
            GL11.glTranslated((double)0.0, (double)(diffY * cos - diffZ * sin - diffY + mirTravel2), (double)(diffY * sin + diffZ * cos - diffZ + mirTravel1));
        } else {
            GL11.glTranslated((double)(diffX * cos - diffY * sin - diffX + mirTravel1), (double)(diffX * sin + diffY * cos - diffY + mirTravel2), (double)0.0);
        }
        GL11.glTranslated((double)offsetX2, (double)offsetY2, (double)offsetZ2);
        GL11.glRotated((double)angle, (double)offsetX, (double)offsetY, (double)offsetZ);
        GL11.glTranslated((double)(-offsetX2), (double)(-offsetY2), (double)(-offsetZ2));
        GL11.glTranslated((double)(-playerX + 0.002 * (double)dir.func_82601_c()), (double)(-playerY + 0.002 * (double)dir.func_96559_d()), (double)(-playerZ + 0.002 * (double)dir.func_82599_e()));
    }

    private AxisAlignedBB contractBoxOrRenderArrows(boolean contractBox, Tessellator t, BufferBuilder buffer, int side, boolean northSouth, EnumFacing dir, AxisAlignedBB box, double invOffsetX, double invOffsetY, double invOffsetZ, boolean invertDirection, float minU, float maxU, float minV, float maxV) {
        if (contractBox) {
            double amount = this.millisecondsElapsed % (float)Configs.translationScalePeriod / (float)Configs.translationScalePeriod;
            amount /= invertDirection ? -2.0 : 2.0;
            if (invertDirection && Configs.translationScalePeriod > 1) {
                amount += 0.5;
            }
            box = box.func_72321_a(-amount * invOffsetX, -amount * invOffsetY, -amount * invOffsetZ);
        } else if (Configs.translationDistance > 0.0) {
            int timeOffset;
            double distance = Configs.translationDistance;
            double fadeDistance = Configs.translationFadeDistance;
            double period = Configs.translationMovementPeriod;
            double offsetDistance = Configs.translationOffsetDistance;
            int n = timeOffset = offsetDistance > 0.0 ? (int)(period / (distance / offsetDistance)) : 0;
            if ((double)timeOffset > period / 3.0) {
                timeOffset = (int)(period / 3.0);
            }
            if (fadeDistance > distance / 2.0) {
                fadeDistance = distance / 2.0;
            }
            int n2 = offsetDistance == 0.0 || period == 1.0 ? 1 : 3;
            for (int i = 0; i < n2; ++i) {
                double amount = (double)(this.millisecondsElapsed + (float)(timeOffset * i)) % period / (period / (distance * 100.0) * 100.0);
                double alpha = 1.0;
                if (period > 1.0) {
                    if (amount < fadeDistance) {
                        alpha = amount / fadeDistance;
                    } else if (amount > distance - fadeDistance) {
                        alpha = (distance - amount) / fadeDistance;
                    }
                    amount -= distance / 2.0;
                }
                AxisAlignedBB box2 = new AxisAlignedBB(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f).func_72317_d(amount * (double)dir.func_82601_c(), amount * (double)dir.func_96559_d(), amount * (double)dir.func_82599_e());
                this.renderTexturedSide(t, buffer, side, northSouth, box2, minU, maxU, minV, maxV, alpha);
            }
        } else {
            this.renderTexturedSide(t, buffer, side, northSouth, box, minU, maxU, minV, maxV, 1.0);
        }
        return box;
    }

    private void renderTexturedSide(Tessellator t, BufferBuilder buffer, int side, boolean northSouth, AxisAlignedBB box, float minU, float maxU, float minV, float maxV, double alpha) {
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)alpha);
        if (side == 1 || side == 3 || side == 4) {
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_187315_a((double)maxU, (double)minV).func_181675_d();
            buffer.func_181662_b(box.field_72336_d, northSouth ? box.field_72338_b : box.field_72337_e, box.field_72334_f).func_187315_a((double)minU, (double)minV).func_181675_d();
            buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_187315_a((double)minU, (double)maxV).func_181675_d();
            buffer.func_181662_b(box.field_72340_a, northSouth ? box.field_72337_e : box.field_72338_b, box.field_72339_c).func_187315_a((double)maxU, (double)maxV).func_181675_d();
            t.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(box.field_72336_d, northSouth ? box.field_72338_b : box.field_72337_e, box.field_72334_f).func_187315_a((double)minU, (double)minV).func_181675_d();
            buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_187315_a((double)maxU, (double)minV).func_181675_d();
            buffer.func_181662_b(box.field_72340_a, northSouth ? box.field_72337_e : box.field_72338_b, box.field_72339_c).func_187315_a((double)maxU, (double)maxV).func_181675_d();
            buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_187315_a((double)minU, (double)maxV).func_181675_d();
            t.func_78381_a();
        } else {
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(box.field_72340_a, northSouth ? box.field_72337_e : box.field_72338_b, box.field_72339_c).func_187315_a((double)maxU, (double)minV).func_181675_d();
            buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_187315_a((double)minU, (double)minV).func_181675_d();
            buffer.func_181662_b(box.field_72336_d, northSouth ? box.field_72338_b : box.field_72337_e, box.field_72334_f).func_187315_a((double)minU, (double)maxV).func_181675_d();
            buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_187315_a((double)maxU, (double)maxV).func_181675_d();
            t.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_187315_a((double)minU, (double)minV).func_181675_d();
            buffer.func_181662_b(box.field_72340_a, northSouth ? box.field_72337_e : box.field_72338_b, box.field_72339_c).func_187315_a((double)maxU, (double)minV).func_181675_d();
            buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_187315_a((double)maxU, (double)maxV).func_181675_d();
            buffer.func_181662_b(box.field_72336_d, northSouth ? box.field_72338_b : box.field_72337_e, box.field_72334_f).func_187315_a((double)minU, (double)maxV).func_181675_d();
            t.func_78381_a();
        }
    }

    static {
        ARROW_HEAD = new ResourceLocation("extrabitmanipulation", "textures/overlays/arrow_head.png");
        ARROW_BIDIRECTIONAL = new ResourceLocation("extrabitmanipulation", "textures/overlays/arrow_bidirectional.png");
        ARROW_CYCLICAL = new ResourceLocation("extrabitmanipulation", "textures/overlays/arrow_cyclical.png");
        CIRCLE = new ResourceLocation("extrabitmanipulation", "textures/overlays/circle.png");
        INVERSION = new ResourceLocation("extrabitmanipulation", "textures/overlays/inversion.png");
        DIRECTION_FORWARD = new int[]{2, 0, 5, 4, 1, 3};
        DIRECTION_BACKWARD = new int[]{1, 4, 0, 5, 3, 2};
        AXIS_FORWARD = new int[]{2, 3, 4, 5, 0, 1};
        AXIS_BACKWARD = new int[]{4, 5, 0, 1, 2, 3};
        SHAPE_CURVED = new int[]{1, 2, 0, 0, 0, 0, 0};
        SHAPE_FLAT = new int[]{3, 3, 3, 6, 3, 3, 3};
        BOUNDING_BOX_OFFSET = 0.002f;
    }
}

