/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.armor.capability;

import com.phylogeny.extrabitmanipulation.ExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.armor.capability.IChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.packet.PacketSyncAllArmorSlotData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemStackHandler;

public class ChiseledArmorSlotsHandler
extends ItemStackHandler
implements ICapabilityProvider,
IChiseledArmorSlotsHandler {
    @CapabilityInject(value=IChiseledArmorSlotsHandler.class)
    public static final Capability<IChiseledArmorSlotsHandler> ARMOR_SLOTS_CAP = null;

    public ChiseledArmorSlotsHandler() {
        super(ItemChiseledArmor.ArmorType.values().length);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return ARMOR_SLOTS_CAP != null && capability == ARMOR_SLOTS_CAP;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == ARMOR_SLOTS_CAP ? ARMOR_SLOTS_CAP.cast((Object)this) : null);
    }

    public static IChiseledArmorSlotsHandler getCapability(EntityPlayer player) {
        return (IChiseledArmorSlotsHandler)player.getCapability(ARMOR_SLOTS_CAP, null);
    }

    @Override
    public void syncAllData(EntityPlayerMP player) {
        ExtraBitManipulation.packetNetwork.sendTo((IMessage)new PacketSyncAllArmorSlotData(this.serializeNBT()), player);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public void setSize(int size) {
        super.setSize(ItemChiseledArmor.ArmorType.values().length);
    }

    public static boolean isItemValid(int slot, ItemStack stack) {
        return ItemStackHelper.isChiseledArmorStack(stack) && ((ItemChiseledArmor)stack.func_77973_b()).field_77881_a.ordinal() == slot && ItemStackHelper.getArmorData(ItemStackHelper.getNBTOrNew(stack)).func_74767_n("notEmpty");
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (stack.func_190926_b() || ChiseledArmorSlotsHandler.isItemValid(slot, stack)) {
            super.setStackInSlot(slot, stack);
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return ChiseledArmorSlotsHandler.isItemValid(slot, stack) ? super.insertItem(slot, stack, simulate) : stack;
    }
}

