/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.api.jei;

import com.phylogeny.extrabitmanipulation.api.jei.Translator;
import com.phylogeny.extrabitmanipulation.api.jei.armor.ChiseledArmorInfoRecipe;
import com.phylogeny.extrabitmanipulation.api.jei.armor.ChiseledArmorInfoRecipeCategory;
import com.phylogeny.extrabitmanipulation.api.jei.armor.ChiseledArmorInfoRecipeHandler;
import com.phylogeny.extrabitmanipulation.api.jei.model.ModelInfoRecipe;
import com.phylogeny.extrabitmanipulation.api.jei.model.ModelInfoRecipeCategory;
import com.phylogeny.extrabitmanipulation.api.jei.model.ModelInfoRecipeHandler;
import com.phylogeny.extrabitmanipulation.api.jei.shape.ShapeInfoRecipe;
import com.phylogeny.extrabitmanipulation.api.jei.shape.ShapeInfoRecipeCategory;
import com.phylogeny.extrabitmanipulation.api.jei.shape.ShapeInfoRecipeHandler;
import com.phylogeny.extrabitmanipulation.init.BlocksExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.init.ItemsExtraBitManipulation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.registry.ModItems;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class JustEnoughItemsPlugin
implements IModPlugin {
    private static IJeiRuntime jeiRuntime;

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JustEnoughItemsPlugin.jeiRuntime = jeiRuntime;
    }

    public static void openCategory(String categoryUid) {
        jeiRuntime.getRecipesGui().showCategories(Collections.singletonList(categoryUid));
    }

    public static String translate(String langKey) {
        return Translator.translateToLocal("jei.extrabitmanipulation." + langKey);
    }

    public void register(IModRegistry registry) {
        this.addDescription(registry, ItemsExtraBitManipulation.bitWrench);
        ItemStack modelingStack = this.addDescription(registry, ItemsExtraBitManipulation.modelingTool);
        List<ItemStack> sculptingStacks = this.addDescription(registry, "sculpting", ItemsExtraBitManipulation.sculptingLoop, ItemsExtraBitManipulation.sculptingSquare, ItemsExtraBitManipulation.sculptingSpadeCurved, ItemsExtraBitManipulation.sculptingSpadeSquared);
        ModItems items = ChiselsAndBits.getItems();
        this.addDescription(registry, (Item)items.itemBlockBit);
        this.addDescription(registry, "designs", new Item[]{items.itemMirrorprint, items.itemNegativeprint, items.itemPositiveprint});
        List<ItemStack> armorStacks = this.addDescription(registry, "chiseled_armor", ItemsExtraBitManipulation.chiseledHelmet, ItemsExtraBitManipulation.chiseledChestplate, ItemsExtraBitManipulation.chiseledLeggings, ItemsExtraBitManipulation.chiseledBoots);
        Item templateItem = Item.func_150898_a((Block)BlocksExtraBitManipulation.bodyPartTemplate);
        this.addDescription(registry, templateItem);
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.handleRecipes(ShapeInfoRecipe.class, (IRecipeWrapperFactory)new ShapeInfoRecipeHandler(), "extrabitmanipulationshape");
        registry.addRecipes(ShapeInfoRecipe.create(guiHelper, sculptingStacks), "extrabitmanipulationshape");
        registry.handleRecipes(ModelInfoRecipe.class, (IRecipeWrapperFactory)new ModelInfoRecipeHandler(), "extrabitmanipulationmodel");
        registry.addRecipes(ModelInfoRecipe.create(guiHelper, Collections.singletonList(modelingStack)), "extrabitmanipulationmodel");
        registry.handleRecipes(ChiseledArmorInfoRecipe.class, (IRecipeWrapperFactory)new ChiseledArmorInfoRecipeHandler(), "extrabitmanipulationchiseled_armor");
        ArrayList<ItemStack> iconStacks = new ArrayList<ItemStack>();
        iconStacks.addAll(armorStacks);
        iconStacks.add(new ItemStack(templateItem));
        registry.addRecipes(ChiseledArmorInfoRecipe.create(guiHelper, iconStacks), "extrabitmanipulationchiseled_armor");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new ShapeInfoRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ModelInfoRecipeCategory(guiHelper)});
        ArrayList<ItemStack> armorStacks = new ArrayList<ItemStack>();
        armorStacks.add(this.getStack(ItemsExtraBitManipulation.chiseledHelmet));
        armorStacks.add(this.getStack(ItemsExtraBitManipulation.chiseledChestplate));
        armorStacks.add(this.getStack(ItemsExtraBitManipulation.chiseledLeggings));
        armorStacks.add(this.getStack(ItemsExtraBitManipulation.chiseledBoots));
        registry.addRecipeCategories(new IRecipeCategory[]{new ChiseledArmorInfoRecipeCategory(guiHelper, armorStacks)});
    }

    private ItemStack getStack(Item item) {
        return new ItemStack(item, 1, Short.MAX_VALUE);
    }

    private ItemStack addDescription(IModRegistry registry, Item item) {
        ItemStack stack = this.getStack(item);
        registry.addIngredientInfo((Object)stack, ItemStack.class, new String[]{"jei.description." + item.getRegistryName()});
        return stack;
    }

    private List<ItemStack> addDescription(IModRegistry registry, String langKeySuffix, Item ... items) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Item item : items) {
            stacks.add(new ItemStack(item));
        }
        registry.addIngredientInfo(stacks, ItemStack.class, new String[]{"jei.description.extrabitmanipulation:" + langKeySuffix});
        return stacks;
    }
}

