/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.handler;

import javax.annotation.Nullable;
import net.blay09.mods.waystones.GlobalWaystones;
import net.blay09.mods.waystones.PlayerWaystoneHelper;
import net.blay09.mods.waystones.WaystoneConfig;
import net.blay09.mods.waystones.WaystoneManager;
import net.blay09.mods.waystones.network.NetworkHandler;
import net.blay09.mods.waystones.network.message.MessageTeleportToGlobal;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class HandlerTeleportToGlobal
implements IMessageHandler<MessageTeleportToGlobal, IMessage> {
    @Nullable
    public IMessage onMessage(MessageTeleportToGlobal message, MessageContext ctx) {
        NetworkHandler.getThreadListener(ctx).func_152344_a(() -> {
            int xpLevelCost;
            if (WaystoneConfig.general.teleportButtonReturnOnly) {
                return;
            }
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WaystoneEntry waystone = GlobalWaystones.get(player.field_70170_p).getGlobalWaystone(message.getWaystoneName());
            if (waystone == null) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("waystones:waystoneBroken", new Object[0]), true);
                return;
            }
            int dist = (int)Math.sqrt(player.func_174831_c(waystone.getPos()));
            int n = xpLevelCost = WaystoneConfig.general.blocksPerXPLevel > 0 ? MathHelper.func_76125_a((int)(dist / WaystoneConfig.general.blocksPerXPLevel), (int)0, (int)WaystoneConfig.general.maximumXpCost) : 0;
            if (!WaystoneConfig.general.teleportButton || WaystoneConfig.general.teleportButtonReturnOnly) {
                return;
            }
            if (WaystoneConfig.general.inventoryButtonXpCost && player.field_71068_ca < xpLevelCost) {
                return;
            }
            if (!PlayerWaystoneHelper.canFreeWarp((EntityPlayer)ctx.getServerHandler().field_147369_b)) {
                return;
            }
            if (WaystoneManager.teleportToWaystone((EntityPlayer)ctx.getServerHandler().field_147369_b, waystone)) {
                if (!WaystoneConfig.general.globalNoCooldown) {
                    PlayerWaystoneHelper.setLastFreeWarp((EntityPlayer)ctx.getServerHandler().field_147369_b, System.currentTimeMillis());
                }
                if (WaystoneConfig.general.inventoryButtonXpCost) {
                    player.func_82242_a(-xpLevelCost);
                }
            }
            WaystoneManager.sendPlayerWaystones((EntityPlayer)ctx.getServerHandler().field_147369_b);
        });
        return null;
    }
}

