/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.builder;

import mcjty.lib.api.IModuleSupport;
import mcjty.lib.base.ModBase;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.GenericBlock;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BaseBlockBuilder;
import mcjty.lib.builder.BlockFlags;
import mcjty.lib.builder.GenericBlockBuilder;
import mcjty.lib.builder.ICanRenderInLayer;
import mcjty.lib.builder.IGetLightValue;
import mcjty.lib.builder.IRedstoneGetter;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.EmptyContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.tileentity.LogicTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LogicSlabBlockBuilder<T extends LogicTileEntity>
extends BaseBlockBuilder<LogicSlabBlockBuilder<T>> {
    public static IProperty<?>[] ADDITIONAL_PROPERTIES = null;
    private Class<T> tileEntityClass;
    private ContainerFactory containerFactory;
    private IModuleSupport moduleSupport;
    private int guiId = -1;
    private boolean infusable = false;

    public LogicSlabBlockBuilder(ModBase mod, String registryName) {
        super(mod, registryName);
        this.rotationType(BaseBlock.RotationType.NONE);
    }

    public LogicSlabBlockBuilder<T> tileEntityClass(Class<T> tileEntityClass) {
        this.tileEntityClass = tileEntityClass;
        return this;
    }

    public LogicSlabBlockBuilder<T> container(ContainerFactory containerFactory) {
        this.containerFactory = containerFactory;
        return this;
    }

    public LogicSlabBlockBuilder<T> emptyContainer() {
        this.containerFactory = EmptyContainerFactory.getInstance();
        return this;
    }

    public LogicSlabBlockBuilder<T> infusable() {
        this.infusable = true;
        return this;
    }

    public LogicSlabBlockBuilder<T> moduleSupport(IModuleSupport moduleSupport) {
        this.moduleSupport = moduleSupport;
        return this;
    }

    public LogicSlabBlockBuilder<T> guiId(int id) {
        this.guiId = id;
        return this;
    }

    @Override
    protected IProperty<?>[] getAdditionalProperties() {
        if (ADDITIONAL_PROPERTIES == null) {
            ADDITIONAL_PROPERTIES = new IProperty[]{LogicSlabBlock.LOGIC_FACING, LogicSlabBlock.META_INTERMEDIATE};
        }
        return ADDITIONAL_PROPERTIES;
    }

    @Override
    public GenericBlock<T, GenericContainer> build() {
        final IProperty<?>[] properties = this.calculateProperties();
        final IRedstoneGetter getter = GenericBlockBuilder.getRedstoneGetter(this.flags.contains((Object)BlockFlags.REDSTONE_OUTPUT));
        final ICanRenderInLayer canRenderInLayer = this.getCanRenderInLayer();
        final IGetLightValue getLightValue = this.getGetLightValue();
        LogicSlabBlock block = new LogicSlabBlock<T, GenericContainer>(this.mod, this.material, this.tileEntityClass, (player, inventory) -> {
            GenericContainer c = new GenericContainer(this.containerFactory);
            if (inventory != null) {
                c.addInventory("container", (IInventory)inventory);
            }
            c.addInventory("player", (IInventory)player.field_71071_by);
            c.generateSlots();
            return c;
        }, this.itemBlockFactory, this.registryName, true){

            @Override
            public BaseBlock.RotationType getRotationType() {
                return LogicSlabBlockBuilder.this.rotationType;
            }

            @Override
            protected void checkRedstone(World world, BlockPos pos) {
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof LogicTileEntity) {
                    LogicTileEntity logicTileEntity = (LogicTileEntity)te;
                    logicTileEntity.checkRedstone(world, pos);
                }
            }

            @Override
            protected int getRedstoneOutput(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
                return getter.getRedstoneOutput(state, world, pos, side);
            }

            @Override
            protected IProperty<?>[] getProperties() {
                return properties;
            }

            public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
                return canRenderInLayer.canRenderInLayer(state, layer);
            }

            public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
                return getLightValue.getLightValue(state, world, pos);
            }

            @Override
            protected BlockStateContainer func_180661_e() {
                return new BlockStateContainer((Block)this, this.getProperties());
            }
        };
        this.setupBlock(block);
        return block;
    }

    @Override
    protected void setupBlock(BaseBlock block) {
        super.setupBlock(block);
        GenericBlock b = (GenericBlock)block;
        b.setGuiId(this.guiId);
        b.setNeedsRedstoneCheck(this.flags.contains((Object)BlockFlags.REDSTONE_CHECK));
        b.setHasRedstoneOutput(this.flags.contains((Object)BlockFlags.REDSTONE_OUTPUT));
        b.setModuleSupport(this.moduleSupport);
        b.setInfusable(this.infusable);
    }
}

