/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import mcjty.lib.base.ModBase;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.GenericItemBlock;
import mcjty.lib.builder.BlockFlags;
import mcjty.lib.builder.ICanRenderInLayer;
import mcjty.lib.builder.IGetLightValue;
import mcjty.lib.builder.InformationString;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BaseBlockBuilder<T extends BaseBlockBuilder<T>> {
    private static final Pattern COMPILE = Pattern.compile("@", 16);
    public static final IProperty<?>[] EMPTY_PROPERTIES = new IProperty[0];
    protected final ModBase mod;
    protected final String registryName;
    protected CreativeTabs creativeTabs;
    protected Material material = Material.field_151573_f;
    protected Function<Block, ItemBlock> itemBlockFactory = GenericItemBlock::new;
    protected List<IProperty<?>> extraProperties = new ArrayList();
    protected InformationString informationString;
    protected InformationString informationStringWithShift;
    protected Set<BlockFlags> flags = new HashSet<BlockFlags>();
    protected int lightValue = -1;
    protected BaseBlock.RotationType rotationType = BaseBlock.RotationType.ROTATION;

    public BaseBlockBuilder(ModBase mod, String registryName) {
        this.mod = mod;
        this.registryName = registryName;
    }

    public T creativeTabs(CreativeTabs creativeTabs) {
        this.creativeTabs = creativeTabs;
        return (T)this;
    }

    public T material(Material material) {
        this.material = material;
        return (T)this;
    }

    public T itemBlockFactory(Function<Block, ItemBlock> itemBlockFactory) {
        this.itemBlockFactory = itemBlockFactory;
        return (T)this;
    }

    public T info(String informationString) {
        this.informationString = new InformationString(informationString);
        return (T)this;
    }

    public T infoParameter(Function<ItemStack, String> parameter) {
        this.informationString.addParameter(parameter);
        return (T)this;
    }

    public T infoExtended(String informationString) {
        this.informationStringWithShift = new InformationString(informationString);
        return (T)this;
    }

    public T infoExtendedParameter(Function<ItemStack, String> parameter) {
        this.informationStringWithShift.addParameter(parameter);
        return (T)this;
    }

    public T property(IProperty<?> property) {
        this.extraProperties.add(property);
        return (T)this;
    }

    public T flags(BlockFlags ... flags) {
        Collections.addAll(this.flags, flags);
        return (T)this;
    }

    public T rotationType(BaseBlock.RotationType rotationType) {
        this.rotationType = rotationType;
        return (T)this;
    }

    public T lightValue(int v) {
        this.lightValue = v;
        return (T)this;
    }

    public BaseBlock build() {
        final IProperty<?>[] properties = this.calculateProperties();
        final ICanRenderInLayer canRenderInLayer = this.getCanRenderInLayer();
        final IGetLightValue getLightValue = this.getGetLightValue();
        BaseBlock block = new BaseBlock(this.mod, this.material, this.registryName, this.itemBlockFactory){

            @Override
            protected IProperty<?>[] getProperties() {
                return properties;
            }

            @Override
            public BaseBlock.RotationType getRotationType() {
                return BaseBlockBuilder.this.rotationType;
            }

            public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
                return canRenderInLayer.canRenderInLayer(state, layer);
            }

            public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
                return getLightValue.getLightValue(state, world, pos);
            }
        };
        this.setupBlock(block);
        return block;
    }

    protected IGetLightValue getGetLightValue() {
        if (this.lightValue == -1) {
            return (state, world, pos) -> state.func_185906_d();
        }
        return (state, world, pos) -> this.lightValue;
    }

    protected ICanRenderInLayer getCanRenderInLayer() {
        ICanRenderInLayer canRenderInLayer;
        BlockRenderLayer layer = null;
        if (this.flags.contains((Object)BlockFlags.RENDER_CUTOUT)) {
            layer = BlockRenderLayer.CUTOUT;
        } else if (this.flags.contains((Object)BlockFlags.RENDER_TRANSLUCENT)) {
            layer = BlockRenderLayer.TRANSLUCENT;
        }
        if (layer != null) {
            BlockRenderLayer finalLayer = layer;
            canRenderInLayer = this.flags.contains((Object)BlockFlags.RENDER_SOLID) ? (state, layer1) -> layer1 == BlockRenderLayer.SOLID || layer1 == finalLayer : (state, layer1) -> layer1 == finalLayer;
        } else {
            canRenderInLayer = (state, layer1) -> layer1 == BlockRenderLayer.SOLID;
        }
        return canRenderInLayer;
    }

    protected IProperty<?>[] calculateProperties() {
        IProperty<?>[] properties = BaseBlock.getProperties(this.rotationType);
        IProperty<?>[] additionalProperties = this.getAdditionalProperties();
        if (!this.extraProperties.isEmpty() || additionalProperties.length > 0) {
            ArrayList newProperties = new ArrayList();
            Collections.addAll(newProperties, properties);
            Collections.addAll(newProperties, additionalProperties);
            for (IProperty<?> property : this.extraProperties) {
                newProperties.add(property);
            }
            properties = newProperties.toArray(new IProperty[newProperties.size()]);
        }
        return properties;
    }

    protected IProperty<?>[] getAdditionalProperties() {
        return EMPTY_PROPERTIES;
    }

    protected void setupBlock(BaseBlock block) {
        block.setCreative(this.flags.contains((Object)BlockFlags.CREATIVE));
        if (this.creativeTabs != null) {
            block.func_149647_a(this.creativeTabs);
        }
        boolean opaque = !this.flags.contains((Object)BlockFlags.NON_OPAQUE);
        block.setOpaqueCube(opaque);
        block.setInformationString(this.informationString);
        if (this.informationStringWithShift != null) {
            block.setInformationStringWithShift(this.informationStringWithShift);
        } else {
            block.setInformationStringWithShift(this.informationString);
        }
    }
}

