/*
 * Decompiled with CFR 0.152.
 */
package elucent.elulib.tile.module;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class FaceConfig {
    public Map<EnumFacing, FaceIO> ioConfig = new HashMap<EnumFacing, FaceIO>();
    public Map<EnumFacing, String> moduleConfig = new HashMap<EnumFacing, String>();

    public FaceConfig() {
        for (EnumFacing e : EnumFacing.values()) {
            this.ioConfig.put(e, FaceIO.NEUTRAL);
            this.moduleConfig.put(e, "");
        }
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound iotag = new NBTTagCompound();
        NBTTagCompound moduletag = new NBTTagCompound();
        for (EnumFacing e : EnumFacing.values()) {
            iotag.func_74768_a(e.func_176610_l(), this.ioConfig.get(e).ordinal());
            moduletag.func_74778_a(e.func_176610_l(), this.moduleConfig.get(e));
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("io", (NBTBase)iotag);
        tag.func_74782_a("modules", (NBTBase)moduletag);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagCompound iotag = tag.func_74775_l("io");
        NBTTagCompound moduletag = tag.func_74775_l("modules");
        for (EnumFacing e : EnumFacing.values()) {
            if (iotag.func_74764_b(e.func_176610_l())) {
                this.ioConfig.put(e, FaceIO.values()[iotag.func_74762_e(e.func_176610_l())]);
            }
            if (!moduletag.func_74764_b(e.func_176610_l())) continue;
            this.moduleConfig.put(e, moduletag.func_74779_i(e.func_176610_l()));
        }
    }

    public void setIO(EnumFacing face, FaceIO io) {
        this.ioConfig.replace(face, io);
    }

    public void setModule(EnumFacing face, String module) {
        this.moduleConfig.replace(face, module);
    }

    public void setAllIO(FaceIO io) {
        for (EnumFacing e : EnumFacing.values()) {
            this.setIO(e, io);
        }
    }

    public void setAllModules(String module) {
        for (EnumFacing e : EnumFacing.values()) {
            this.setModule(e, module);
        }
    }

    public static enum FaceIO {
        IN,
        OUT,
        NEUTRAL,
        INOUT;

    }
}

