/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStackValidated;
import cofh.core.inventory.InventoryCraftingFalse;
import cofh.core.inventory.OreValidator;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalfoundation.item.ItemMaterial;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class SawmillManager {
    private static Map<ComparableItemStackValidated, SawmillRecipe> recipeMap = new Object2ObjectOpenHashMap();
    private static OreValidator oreValidator = new OreValidator();
    static final float LOG_MULTIPLIER = 1.5f;
    public static final int DEFAULT_ENERGY = 2000;

    public static SawmillRecipe getRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return null;
        }
        ComparableItemStackValidated query = SawmillManager.convertInput(input);
        SawmillRecipe recipe = recipeMap.get(query);
        if (recipe == null) {
            query.metadata = Short.MAX_VALUE;
            recipe = recipeMap.get(query);
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack input) {
        return SawmillManager.getRecipe(input) != null;
    }

    public static SawmillRecipe[] getRecipeList() {
        return recipeMap.values().toArray(new SawmillRecipe[0]);
    }

    public static void initialize() {
        int energy = 1500;
        ItemStack output = new ItemStack(Items.field_151116_aA);
        SawmillManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151024_Q), output, 2);
        SawmillManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151027_R), output, 4);
        SawmillManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151026_S), output, 3);
        SawmillManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151021_T), output, 2);
        InventoryCraftingFalse tempCrafting = new InventoryCraftingFalse(3, 3);
        for (ItemStack logWood : OreDictionary.getOres((String)"logWood", (boolean)false)) {
            Block logBlock = Block.func_149634_a((Item)logWood.func_77973_b());
            if (ItemHelper.getItemDamage((ItemStack)logWood) == Short.MAX_VALUE) {
                NonNullList logVariants = NonNullList.func_191196_a();
                logBlock.func_149666_a(logBlock.func_149708_J(), logVariants);
                for (ItemStack log : logVariants) {
                    tempCrafting.func_70299_a(0, log);
                    ItemStack resultEntry = ItemHelper.getCraftingResult((InventoryCrafting)tempCrafting, null);
                    if (resultEntry.func_190926_b()) continue;
                    ItemStack result = resultEntry.func_77946_l();
                    result.func_190920_e((int)((float)result.func_190916_E() * 1.5f));
                    SawmillManager.addRecipe(1000, log, result, ItemMaterial.dustWood);
                }
                continue;
            }
            ItemStack log = ItemHelper.cloneStack((ItemStack)logWood, (int)1);
            tempCrafting.func_70299_a(0, log);
            ItemStack resultEntry = ItemHelper.getCraftingResult((InventoryCrafting)tempCrafting, null);
            if (resultEntry.func_190926_b()) continue;
            ItemStack result = resultEntry.func_77946_l();
            result.func_190920_e((int)((float)result.func_190916_E() * 1.5f));
            SawmillManager.addRecipe(1000, log, result, ItemMaterial.dustWood);
        }
    }

    public static void refresh() {
        Object2ObjectOpenHashMap tempMap = new Object2ObjectOpenHashMap(recipeMap.size());
        for (Map.Entry<ComparableItemStackValidated, SawmillRecipe> entry : recipeMap.entrySet()) {
            SawmillRecipe tempRecipe = entry.getValue();
            tempMap.put(SawmillManager.convertInput(tempRecipe.input), tempRecipe);
        }
        recipeMap.clear();
        recipeMap = tempMap;
    }

    public static SawmillRecipe addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (input.func_190926_b() || primaryOutput.func_190926_b() || energy <= 0 || SawmillManager.recipeExists(input)) {
            return null;
        }
        SawmillRecipe recipe = new SawmillRecipe(input, primaryOutput, secondaryOutput, secondaryOutput.func_190926_b() ? 0 : secondaryChance, energy);
        recipeMap.put(SawmillManager.convertInput(input), recipe);
        return recipe;
    }

    public static SawmillRecipe addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        return SawmillManager.addRecipe(energy, input, primaryOutput, secondaryOutput, 100);
    }

    public static SawmillRecipe addRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        return SawmillManager.addRecipe(energy, input, primaryOutput, ItemStack.field_190927_a, 0);
    }

    public static SawmillRecipe removeRecipe(ItemStack input) {
        return recipeMap.remove(SawmillManager.convertInput(input));
    }

    public static ComparableItemStackValidated convertInput(ItemStack stack) {
        return new ComparableItemStackValidated(stack, oreValidator);
    }

    public static void addRecycleRecipe(int energy, ItemStack input, ItemStack output, int outputSize) {
        SawmillManager.addRecycleRecipe(energy, input, output, outputSize, true);
    }

    public static void addRecycleRecipe(int energy, ItemStack input, ItemStack output, int outputSize, boolean wildcard) {
        ItemStack recycleInput = wildcard ? input.func_77946_l() : new ItemStack(input.func_77973_b(), 1, Short.MAX_VALUE);
        SawmillManager.addRecipe(energy, recycleInput, ItemHelper.cloneStack((ItemStack)output, (int)outputSize));
    }

    static {
        oreValidator.addPrefix("ore");
        oreValidator.addPrefix("ingot");
        oreValidator.addPrefix("nugget");
    }

    public static class SawmillRecipe {
        final ItemStack input;
        final ItemStack primaryOutput;
        final ItemStack secondaryOutput;
        final int secondaryChance;
        final int energy;

        SawmillRecipe(ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, int energy) {
            this.input = input;
            this.primaryOutput = primaryOutput;
            this.secondaryOutput = secondaryOutput;
            this.secondaryChance = secondaryChance;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getPrimaryOutput() {
            return this.primaryOutput;
        }

        public ItemStack getSecondaryOutput() {
            return this.secondaryOutput;
        }

        public int getSecondaryOutputChance() {
            return this.secondaryChance;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

