/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.render;

import codechicken.lib.model.bakery.ModelErrorStateProperty;
import codechicken.lib.model.bakery.generation.ILayeredBlockBakery;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.BakingVertexBuffer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.core.init.CoreEnchantments;
import cofh.core.util.helpers.RenderHelper;
import cofh.thermalexpansion.block.storage.BlockTank;
import cofh.thermalexpansion.block.storage.TileTank;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TETextures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BakeryTank
implements ILayeredBlockBakery {
    public static final BakeryTank INSTANCE = new BakeryTank();
    public static final int RENDER_LEVELS = 100;
    private static CCModel[] modelFluid = new CCModel[100];
    private static CCModel modelFrame = CCModel.quadModel((int)48);

    private static void generateModels() {
        Cuboid6 box = new Cuboid6(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
        double inset = 0.0625;
        modelFrame = CCModel.quadModel((int)48).generateBlock(0, box);
        CCModel.generateBackface((CCModel)modelFrame, (int)0, (CCModel)modelFrame, (int)24, (int)24);
        modelFrame.computeNormals();
        for (int i = 24; i < 48; ++i) {
            BakeryTank.modelFrame.verts[i].vec.add(modelFrame.normals()[i].copy().multiply(inset));
        }
        modelFrame.shrinkUVs(0.001953125);
    }

    private static void generateFluidModels() {
        double minXZ = 0.185546875;
        double maxXZ = 0.814453125;
        double minY = 0.060546875;
        double maxY = 1.0 - minY;
        double increment = (maxY - minY) / 100.0;
        for (int i = 1; i < 101; ++i) {
            double yLevel = minY + increment * (double)i;
            BakeryTank.modelFluid[i - 1] = CCModel.quadModel((int)24).generateBlock(0, minXZ, minY, minXZ, maxXZ, yLevel, maxXZ).computeNormals();
        }
    }

    protected void renderFrame(CCRenderState ccrs, boolean creative, int level, int mode) {
        int i;
        if (creative) {
            level = 5;
        }
        modelFrame.render(ccrs, 0, 4, new IVertexOperation[]{new IconTransformation(TETextures.TANK_BOTTOM[mode][level])});
        modelFrame.render(ccrs, 24, 28, new IVertexOperation[]{new IconTransformation(TETextures.TANK_BOTTOM[mode][level])});
        modelFrame.render(ccrs, 4, 8, new IVertexOperation[]{new IconTransformation(TETextures.TANK_TOP[level])});
        modelFrame.render(ccrs, 28, 32, new IVertexOperation[]{new IconTransformation(TETextures.TANK_TOP[level])});
        for (i = 8; i < 24; i += 4) {
            modelFrame.render(ccrs, i, i + 4, new IVertexOperation[]{new IconTransformation(TETextures.TANK_SIDE[mode][level])});
        }
        for (i = 32; i < 48; i += 4) {
            modelFrame.render(ccrs, i, i + 4, new IVertexOperation[]{new IconTransformation(TETextures.TANK_SIDE[mode][level])});
        }
    }

    protected void renderLock(CCRenderState ccrs) {
        for (int i = 8; i < 24; i += 4) {
            modelFrame.render(ccrs, i, i + 4, new IVertexOperation[]{new IconTransformation(TETextures.TANK_SIDE_LOCK)});
        }
    }

    protected void renderFluid(CCRenderState ccrs, boolean creative, int level, int holding, FluidStack stack) {
        if (stack == null || stack.amount <= 0) {
            return;
        }
        Fluid fluid = stack.getFluid();
        ccrs.setFluidColour(stack);
        TextureAtlasSprite fluidTex = RenderHelper.getFluidTexture((FluidStack)stack);
        int fluidLevel = 99;
        if (fluid.isGaseous(stack)) {
            ccrs.alphaOverride = creative ? 224 : 32 + 192 * stack.amount / TileTank.CAPACITY[level];
        } else if (!creative) {
            fluidLevel = (int)Math.min(99L, (long)stack.amount * 100L / (long)TileTank.getMaxCapacity(level, holding));
        }
        modelFluid[fluidLevel].render(ccrs, new IVertexOperation[]{new IconTransformation(fluidTex)});
    }

    public IExtendedBlockState handleState(IExtendedBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return state.withProperty((IUnlistedProperty)ModelErrorStateProperty.ERROR_STATE, (Object)ModelErrorStateProperty.ErrorState.of((String)"Null tile. Position: %s", (Object[])new Object[]{pos}));
        }
        if (!(tile instanceof TileTank)) {
            return state.withProperty((IUnlistedProperty)ModelErrorStateProperty.ERROR_STATE, (Object)ModelErrorStateProperty.ErrorState.of((String)"Tile is not an instance of TileTank, was %s. Pos: %s", (Object[])new Object[]{tile.getClass().getName(), pos}));
        }
        state = state.withProperty((IUnlistedProperty)ModelErrorStateProperty.ERROR_STATE, (Object)ModelErrorStateProperty.ErrorState.OK);
        state = state.withProperty(TEProps.TILE_TANK, (Object)((TileTank)tile));
        return state;
    }

    public List<BakedQuad> bakeItemQuads(EnumFacing face, ItemStack stack) {
        if (face == null && !stack.func_190926_b()) {
            BakingVertexBuffer buffer = BakingVertexBuffer.create();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((BufferBuilder)buffer);
            boolean creative = BlockTank.itemBlock.isCreative(stack);
            int level = BlockTank.itemBlock.getLevel(stack);
            int holding = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
            FluidStack fluid = null;
            if (stack.func_77978_p() != null) {
                fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Fluid"));
            }
            this.renderFrame(ccrs, creative, level, 0);
            this.renderFluid(ccrs, creative, level, holding, fluid);
            buffer.func_178977_d();
            return buffer.bake();
        }
        return new ArrayList<BakedQuad>();
    }

    public List<BakedQuad> bakeLayerFace(EnumFacing face, BlockRenderLayer layer, IExtendedBlockState state) {
        if (face == null && state != null) {
            TileTank tank = (TileTank)((Object)state.getValue(TEProps.TILE_TANK));
            boolean creative = tank.isCreative;
            int level = tank.getLevel();
            byte holding = tank.enchantHolding;
            int mode = tank.getTransferOut() ? 1 : 0;
            boolean lock = tank.isLocked();
            FluidStack fluidStack = tank.getTankFluid();
            BakingVertexBuffer buffer = BakingVertexBuffer.create();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((BufferBuilder)buffer);
            if (layer == BlockRenderLayer.CUTOUT) {
                this.renderFrame(ccrs, creative, level, mode);
                if (lock) {
                    this.renderLock(ccrs);
                }
            } else {
                this.renderFluid(ccrs, creative, level, holding, fluidStack);
            }
            buffer.func_178977_d();
            return buffer.bake();
        }
        return new ArrayList<BakedQuad>();
    }

    static {
        BakeryTank.generateModels();
        BakeryTank.generateFluidModels();
    }
}

