/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.GuiInfoBook;
import org.cyclops.cyclopscore.infobook.HyperLink;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;

public class InfoSection {
    private static final int TITLE_LINES = 3;
    private static final int APPENDIX_OFFSET_LINE = 1;
    private static final int LINK_INDENT = 8;
    private final IInfoBook infoBook;
    private InfoSection parent;
    private int childIndex;
    private String unlocalizedName;
    private List<InfoSection> sections = Lists.newLinkedList();
    private List<List<HyperLink>> links = Lists.newLinkedList();
    private List<SectionAppendix> appendixes;
    protected List<String> paragraphs;
    private ArrayList<String> tagList;
    private int pages;
    private List<String> localizedPages;
    private Map<Integer, List<AdvancedButton>> advancedButtons = Maps.newHashMap();

    public InfoSection(IInfoBook infoBook, InfoSection parent, int childIndex, String unlocalizedName, List<String> paragraphs, List<SectionAppendix> appendixes, ArrayList<String> tagList) {
        this.infoBook = infoBook;
        this.parent = parent;
        this.childIndex = childIndex;
        this.unlocalizedName = unlocalizedName;
        this.paragraphs = paragraphs;
        this.appendixes = appendixes;
        this.tagList = tagList;
    }

    protected void addLinks(int maxLines, int lineHeight, int yOffset, Map<String, Pair<InfoSection, Integer>> softLinks) {
        int linesOnPage = 0;
        if (this.isTitlePage(0)) {
            linesOnPage += 3;
        }
        ArrayList pageLinks = Lists.newArrayListWithCapacity((int)maxLines);
        StringBuilder lines = new StringBuilder();
        for (Map.Entry<String, Pair<InfoSection, Integer>> entry : softLinks.entrySet()) {
            lines.append(" \n");
            if (++linesOnPage >= maxLines) {
                linesOnPage = 0;
                this.links.add(pageLinks);
                pageLinks = Lists.newArrayListWithCapacity((int)maxLines);
            }
            pageLinks.add(new HyperLink((Integer)entry.getValue().getRight(), yOffset + (linesOnPage - 1) * lineHeight, (InfoSection)entry.getValue().getLeft(), entry.getKey()));
        }
        this.paragraphs.add(lines.toString());
        this.links.add(pageLinks);
    }

    protected boolean shouldAddIndex() {
        return true;
    }

    protected static void constructAllLinks(InfoSection root, Map<String, Pair<InfoSection, Integer>> softLinks, int indent, int maxDepth) {
        for (InfoSection section : root.sections) {
            softLinks.put(section.unlocalizedName, (Pair<InfoSection, Integer>)Pair.of((Object)section, (Object)indent));
            if (maxDepth - 1 <= 0) continue;
            InfoSection.constructAllLinks(section, softLinks, indent + 8, maxDepth - 1);
        }
    }

    public void bakeSection(FontRenderer fontRenderer, int width, int maxLines, int lineHeight, int yOffset) {
        if (this.paragraphs.size() == 0 && this.shouldAddIndex()) {
            LinkedHashMap softLinks = Maps.newLinkedHashMap();
            InfoSection.constructAllLinks(this, softLinks, 0, 2);
            this.addLinks(maxLines, lineHeight, yOffset, softLinks);
        }
        String contents = "";
        Iterator<String> it = this.paragraphs.iterator();
        while (it.hasNext()) {
            String paragraph = it.next();
            contents = contents + InfoSection.formatString(L10NHelpers.localize(paragraph, new Object[0])) + (it.hasNext() ? "\n\n" : "");
        }
        List allLines = fontRenderer.func_78271_c(contents, width);
        this.localizedPages = Lists.newLinkedList();
        int linesOnPage = 0;
        StringBuilder currentPage = new StringBuilder();
        if (this.isTitlePage(0)) {
            for (int i = 1; i < 3; ++i) {
                currentPage.append("\n");
            }
            linesOnPage += 3;
        }
        this.pages = 1;
        for (String line : allLines) {
            if (linesOnPage >= maxLines) {
                linesOnPage = 0;
                ++this.pages;
                this.localizedPages.add(currentPage.toString());
                currentPage = new StringBuilder();
            }
            if (++linesOnPage > 1) {
                currentPage.append("\n");
            }
            currentPage.append(line);
        }
        this.localizedPages.add(currentPage.toString());
        HashMap appendixesPerPage = Maps.newHashMap();
        LinkedList appendixCurrentPage = Lists.newLinkedList();
        int appendixPageStart = this.pages - 1;
        int appendixLineStart = ++linesOnPage;
        for (SectionAppendix sectionAppendix : this.appendixes) {
            int lines = InfoSection.getAppendixLineHeight(sectionAppendix, fontRenderer);
            if (linesOnPage + lines > maxLines) {
                appendixesPerPage.put(this.pages - 1, appendixCurrentPage);
                ++this.pages;
                linesOnPage = 0;
                appendixCurrentPage = Lists.newLinkedList();
            }
            appendixCurrentPage.add(sectionAppendix);
            sectionAppendix.setPage(this.pages - 1);
            linesOnPage += lines + 1;
        }
        appendixesPerPage.put(this.pages - 1, appendixCurrentPage);
        for (Map.Entry entry : appendixesPerPage.entrySet()) {
            int freeLines = maxLines;
            int lineStart = 0;
            if ((Integer)entry.getKey() == appendixPageStart) {
                lineStart = appendixLineStart;
                freeLines -= appendixLineStart;
            }
            for (SectionAppendix appendix : (List)entry.getValue()) {
                freeLines -= InfoSection.getAppendixLineHeight(appendix, fontRenderer);
            }
            int linesOffset = freeLines / (((List)entry.getValue()).size() + 1);
            int linesOffsetMod = freeLines % (((List)entry.getValue()).size() + 1);
            lineStart += linesOffset;
            for (SectionAppendix appendix : (List)entry.getValue()) {
                appendix.setLineStart(lineStart);
                lineStart += linesOffset + InfoSection.getAppendixLineHeight(appendix, fontRenderer) + (linesOffsetMod > 0 ? linesOffsetMod-- : 0);
            }
        }
        this.advancedButtons.clear();
        for (SectionAppendix sectionAppendix : this.appendixes) {
            sectionAppendix.preBakeElement(this);
            sectionAppendix.bakeElement(this);
        }
    }

    protected static int getAppendixLineHeight(SectionAppendix appendix, FontRenderer fontRenderer) {
        return (int)Math.ceil((double)appendix.getFullHeight() / (double)InfoSection.getFontHeight(fontRenderer));
    }

    public static int getFontHeight(FontRenderer fontRenderer) {
        return fontRenderer.field_78288_b;
    }

    public boolean isTitlePage(int page) {
        return this.unlocalizedName != null && page == 0;
    }

    public void registerSection(InfoSection section) {
        this.sections.add(section);
        section.childIndex = this.sections.size() - 1;
    }

    public int getPages() {
        return this.pages;
    }

    public static String formatString(String string) {
        return (string + "&r").replaceAll("&N", "\n").replaceAll("&", "\u00a7");
    }

    protected String getLocalizedPageString(int page) {
        if (page >= this.localizedPages.size() || page < 0) {
            return null;
        }
        return this.localizedPages.get(page);
    }

    public String getLocalizedTitle() {
        return InfoSection.formatString(L10NHelpers.localize(this.unlocalizedName, new Object[0]));
    }

    public int getSubSections() {
        return this.sections.size();
    }

    public InfoSection getSubSection(int index) {
        return this.sections.get(index);
    }

    public InfoSection getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public int getChildIndex() {
        return this.childIndex;
    }

    public List<HyperLink> getLinks(int page) {
        if (this.links.size() <= page || page < 0) {
            return Collections.emptyList();
        }
        return this.links.get(page);
    }

    public void drawScreen(GuiInfoBook gui, int x, int y, int yOffset, int width, int height, int page, int mx, int my, int footnoteOffsetX, int footnoteOffsetY) {
        if (page < this.getPages()) {
            FontRenderer fontRenderer = gui.getFontRenderer();
            boolean oldUnicode = fontRenderer.func_82883_a();
            fontRenderer.func_78264_a(true);
            fontRenderer.func_78275_b(false);
            String content = this.getLocalizedPageString(page);
            if (content != null) {
                fontRenderer.func_78279_b(content, x, y + yOffset, width, 0);
            }
            if (this.isTitlePage(page)) {
                gui.drawScaledCenteredString(this.getLocalizedTitle(), x, y + yOffset + 10, width, 1.5f, width, gui.getTitleColor());
                gui.drawHorizontalRule(x + width / 2, y + yOffset);
                gui.drawHorizontalRule(x + width / 2, y + yOffset + 21);
            }
            fontRenderer.func_78264_a(oldUnicode);
            gui.drawScaledCenteredString(this.getLocalizedTitle() + " - " + (page + 1) + "/" + this.getPages(), x + (page % 2 == 0 ? 1 : -1) * footnoteOffsetX, y + height + footnoteOffsetY, width, 0.6f, (int)((float)width * 0.75f), Helpers.RGBToInt(190, 190, 190));
            for (SectionAppendix appendix : this.appendixes) {
                if (appendix.getPage() != page) continue;
                appendix.drawScreen(gui, x, y + yOffset + InfoSection.getAppendixOffsetLine(fontRenderer, appendix), width, height, page, mx, my, true);
            }
        }
    }

    public void postDrawScreen(GuiInfoBook gui, int x, int y, int width, int height, int page, int mx, int my) {
        if (page < this.getPages()) {
            FontRenderer fontRenderer = gui.getFontRenderer();
            for (SectionAppendix appendix : this.appendixes) {
                if (appendix.getPage() != page) continue;
                appendix.drawScreen(gui, x, y + InfoSection.getAppendixOffsetLine(fontRenderer, appendix), width, height, page, mx, my, false);
            }
        }
    }

    public Location getNext(int page, boolean stepSection) {
        if (page < this.getPages() - 1 && !stepSection) {
            return new Location(page + 1, this);
        }
        if (this.getSubSections() > 0) {
            return new Location(0, this.getSubSection(0));
        }
        InfoSection current = this;
        while (!current.isRoot()) {
            if (current.getChildIndex() < current.getParent().getSubSections() - 1) {
                return new Location(0, current.getParent().getSubSection(current.getChildIndex() + 1));
            }
            current = current.getParent();
        }
        return new Location(page, this);
    }

    public Location getPrevious(int page, boolean stepSection) {
        if (page > 0) {
            return new Location(stepSection ? 0 : page - this.getInfoBook().getPagesPerView(), this);
        }
        if (!this.isRoot() && this.getChildIndex() == 0) {
            return new Location(0, this.getParent());
        }
        if (!this.isRoot() && this.getChildIndex() > 0) {
            InfoSection current = this.getParent().getSubSection(this.getChildIndex() - 1);
            while (current.getSubSections() > 0) {
                current = current.getSubSection(current.getSubSections() - 1);
            }
            return new Location(0, current);
        }
        return new Location(page, this);
    }

    protected static int getAppendixOffsetLine(FontRenderer fontRenderer, SectionAppendix appendix) {
        return InfoSection.getFontHeight(fontRenderer) * appendix.getLineStart();
    }

    public ArrayList<String> getTags() {
        return this.tagList;
    }

    public List<AdvancedButton> getAdvancedButtons(int page) {
        if (!this.advancedButtons.containsKey(page)) {
            return Collections.emptyList();
        }
        return this.advancedButtons.get(page);
    }

    public void addAdvancedButton(int page, AdvancedButton advancedButton) {
        if (!this.advancedButtons.containsKey(page)) {
            this.advancedButtons.put(page, Lists.newLinkedList());
        }
        this.advancedButtons.get(page).add(advancedButton);
    }

    public <T extends AdvancedButton> void addAdvancedButtons(int page, Collection<T> advancedButtons) {
        for (AdvancedButton advancedButton : advancedButtons) {
            this.addAdvancedButton(page, advancedButton);
        }
    }

    public IInfoBook getInfoBook() {
        return this.infoBook;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public static class Location {
        private int page;
        private InfoSection infoSection;

        public boolean equals(Object o) {
            if (o instanceof Location) {
                return ((Location)o).page == this.page && ((Location)o).infoSection == this.infoSection;
            }
            return false;
        }

        public int hashCode() {
            return this.infoSection.hashCode() >> 4 & this.page;
        }

        public int getPage() {
            return this.page;
        }

        public InfoSection getInfoSection() {
            return this.infoSection;
        }

        public void setPage(int page) {
            this.page = page;
        }

        public void setInfoSection(InfoSection infoSection) {
            this.infoSection = infoSection;
        }

        public String toString() {
            return "InfoSection.Location(page=" + this.getPage() + ", infoSection=" + this.getInfoSection() + ")";
        }

        @ConstructorProperties(value={"page", "infoSection"})
        public Location(int page, InfoSection infoSection) {
            this.page = page;
            this.infoSection = infoSection;
        }
    }
}

