/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurable;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.block.property.BlockPropertyManagerComponent;
import org.cyclops.cyclopscore.block.property.IBlockPropertyManager;
import org.cyclops.cyclopscore.config.configurable.IConfigurableBlock;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.BlockHelpers;

public abstract class ConfigurableBlockLeaves
extends BlockLeaves
implements IConfigurableBlock {
    private IBlockPropertyManager propertyManager;
    @BlockProperty(ignore=true)
    public static final IProperty[] _COMPAT = new IProperty[]{field_176237_a, field_176236_b};
    protected BlockConfig eConfig = null;
    protected boolean hasGui = false;

    protected BlockStateContainer func_180661_e() {
        this.propertyManager = new BlockPropertyManagerComponent((Block)this);
        return this.propertyManager.createDelegatedBlockState();
    }

    public ConfigurableBlockLeaves(ExtendedConfig<BlockConfig> eConfig) {
        this.setConfig((BlockConfig)eConfig);
        this.func_149663_c(eConfig.getUnlocalizedName());
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColorHandler() {
        return null;
    }

    @Override
    public boolean hasGui() {
        return this.hasGui;
    }

    private void setConfig(BlockConfig eConfig) {
        this.eConfig = eConfig;
    }

    @Override
    public BlockConfig getConfig() {
        return this.eConfig;
    }

    public abstract Item func_180660_a(IBlockState var1, Random var2, int var3);

    public void func_180653_a(World world, BlockPos blockPos, IBlockState blockState, float chance, int fortune) {
        if (!world.field_72995_K) {
            List items = this.getDrops((IBlockAccess)world, blockPos, blockState, fortune);
            for (ItemStack item : items) {
                if (!(world.field_73012_v.nextFloat() <= chance)) continue;
                ConfigurableBlockLeaves.func_180635_a((World)world, (BlockPos)blockPos, (ItemStack)item);
            }
        }
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean isNormalCube(IBlockState blockState, IBlockAccess world, BlockPos blockPos) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos blockPos, EnumFacing side) {
        return !blockState.func_185895_e() || super.func_176225_a(blockState, world, blockPos, side);
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        if (!BlockHelpers.isValidCreativeTab((Block)this, creativeTabs)) {
            return;
        }
        list.add((Object)new ItemStack((Block)this, 1, 0));
    }

    public boolean isLeaves(IBlockState blockState, IBlockAccess world, BlockPos blockPos) {
        return true;
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return null;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)this)});
    }

    public int func_176201_c(IBlockState state) {
        return this.propertyManager.getMetaFromState(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.propertyManager.getStateFromMeta(meta);
    }

    public BlockStateContainer createDelegatedBlockState() {
        return this.propertyManager.createDelegatedBlockState();
    }
}

