/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.network.client;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.skills.AoVSkill;

public class ClientPacketHandlerAoVData
implements IMessageHandler<Packet, IMessage> {
    @SideOnly(value=Side.CLIENT)
    private static void processPacket(Packet message, EntityPlayer player) {
        IAoVCapability cap;
        if (player.hasCapability(CapabilityList.AOV, null) && (cap = (IAoVCapability)player.getCapability(CapabilityList.AOV, null)) != null) {
            cap.getObtainedSkills().clear();
            for (AoVSkill skill : message.obtainedSkills) {
                cap.addObtainedSkill(skill);
            }
            cap.setSkillPoints(message.skillPoints);
            cap.setExp(message.exp);
            cap.setMaxLevel(message.maxLevel);
            cap.toggleInvokeMass(message.invokeMass);
            for (int index = 0; index < 9; ++index) {
                cap.setSlot(message.slots[index], index, true);
            }
            cap.setCurrentSlot(message.currentSlot);
            cap.markDirty();
            cap.setLoaded();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(Packet message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> ClientPacketHandlerAoVData.processPacket(message, (EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        return null;
    }

    public static class Packet
    implements IMessage {
        private List<AoVSkill> obtainedSkills = new ArrayList<AoVSkill>();
        private int skillPoints;
        private int exp;
        private int maxLevel;
        private boolean invokeMass;
        private Ability[] slots = new Ability[]{null, null, null, null, null, null, null, null, null};
        private int currentSlot;

        public Packet() {
        }

        public Packet(IAoVCapability cap) {
            this.obtainedSkills = cap.getObtainedSkills();
            this.skillPoints = cap.getSkillPoints();
            this.exp = cap.getExp();
            this.maxLevel = cap.getMaxLevel();
            this.invokeMass = cap.getInvokeMass();
            this.slots = cap.getSlots();
            this.currentSlot = cap.getCurrentSlot();
        }

        public void fromBytes(ByteBuf stream) {
            int index;
            int size = stream.readInt();
            this.obtainedSkills.clear();
            for (index = 0; index < size; ++index) {
                this.obtainedSkills.add(AoVSkill.getSkillFromID(stream.readInt()));
            }
            this.skillPoints = stream.readInt();
            this.exp = stream.readInt();
            this.maxLevel = stream.readInt();
            this.invokeMass = stream.readBoolean();
            for (index = 0; index < 9; ++index) {
                this.slots[index] = stream.readBoolean() ? Ability.construct(stream) : null;
            }
            this.currentSlot = stream.readInt();
        }

        public void toBytes(ByteBuf stream) {
            stream.writeInt(this.obtainedSkills.size());
            for (AoVSkill skill : this.obtainedSkills) {
                stream.writeInt(skill == null ? -1 : skill.getID());
            }
            stream.writeInt(this.skillPoints);
            stream.writeInt(this.exp);
            stream.writeInt(this.maxLevel);
            stream.writeBoolean(this.invokeMass);
            for (int index = 0; index < 9; ++index) {
                Ability ability = this.slots[index];
                if (ability == null) {
                    stream.writeBoolean(false);
                    continue;
                }
                stream.writeBoolean(true);
                ability.encode(stream);
            }
            stream.writeInt(this.currentSlot);
        }
    }
}

