/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.defender;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.registry.AoVPotions;
import tamaized.aov.registry.SoundEvents;

public class Zeal
extends AbilityBase {
    private static final String name = "aov.spells.zeal.name";
    private static final int charges = 5;

    public Zeal() {
        super(new TextComponentTranslation(name, new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{5}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.zeal.desc", new Object[0]));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)name, (Object[])new Object[0]);
    }

    @Override
    public double getMaxDistance() {
        return 1.0;
    }

    @Override
    public int getMaxCharges() {
        return 5;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    protected int getParticleColor() {
        return -1;
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer player, EntityLivingBase e) {
        IAoVCapability cap = (IAoVCapability)player.getCapability(CapabilityList.AOV, null);
        if (cap == null) {
            return false;
        }
        this.addPotionEffects((EntityLivingBase)player);
        SoundEvents.playMovingSoundOnServer(SoundEvents.cast_2, (Entity)player);
        cap.addExp((Entity)player, 8, this);
        return true;
    }

    private void addPotionEffects(EntityLivingBase entity) {
        entity.func_70690_d(new PotionEffect(AoVPotions.zeal, 3000));
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public int getCoolDown() {
        return 12;
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("aov", "textures/spells/zeal.png");
    }
}

