/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.astro;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.astro.IAstroCapability;
import tamaized.aov.common.core.abilities.Abilities;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;

public class RoyalRoad
extends AbilityBase {
    private static final ResourceLocation icon = new ResourceLocation("aov", "textures/spells/royalroad.png");
    private static final int charges = -1;

    public RoyalRoad() {
        super(new TextComponentTranslation(RoyalRoad.getStaticName(), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.royalroad.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.royalroad.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)RoyalRoad.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 30;
    }

    @Override
    public int getMaxCharges() {
        return -1;
    }

    @Override
    public int getChargeCost() {
        return 0;
    }

    @Override
    public double getMaxDistance() {
        return 0.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        if (!caster.hasCapability(CapabilityList.ASTRO, null) || !caster.hasCapability(CapabilityList.AOV, null)) {
            return false;
        }
        IAstroCapability astro = (IAstroCapability)caster.getCapability(CapabilityList.ASTRO, null);
        IAoVCapability aov = (IAoVCapability)caster.getCapability(CapabilityList.AOV, null);
        if (astro == null || aov == null) {
            return false;
        }
        if (astro.getDraw() != null) {
            astro.burnCard((EntityLivingBase)caster);
            for (Ability a : aov.getSlots()) {
                if (a == null || a.getAbility() != Abilities.draw) continue;
                a.setTimer(0);
            }
            aov.addExp((Entity)caster, 15, this);
        } else {
            ability.setNextCooldown(1);
        }
        astro.sendPacketUpdates(caster);
        return true;
    }
}

