/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
@Config(modid="aov")
public class ConfigHandler {
    @Config.Name(value="Element Positions")
    @Config.Comment(value={"The XY positions of on screen elements from the mod"})
    public static ElementPositions elementPositions = new ElementPositions();
    @Config.Name(value="Max Level")
    @Config.Comment(value={"Sets the maximum level"})
    public static int maxlevel = 15;
    @Config.Name(value="Recharge Delay")
    @Config.Comment(value={"Sets the recharge rate per tick, -1 disables this"})
    public static int recharge = -1;
    @Config.Name(value="Enable Vanilla Experience gain")
    @Config.Comment(value={"Determines whether or not vanilla experience contributes to AoV experience gain"})
    public static boolean experience = false;
    @Config.Name(value="Render SpellBar Over HotBar")
    @Config.Comment(value={"Sets the Spellbar to render in place of the hotbar while active."})
    public static boolean renderBarOverHotbar = false;
    @Config.Name(value="Render Charges Above SpellBar")
    @Config.Comment(value={"Renders the Charges left to be above the Spellbar instead of below. This setting has no impact if Render SpellBar Over HotBar is enabled."})
    public static boolean renderChargesAboveSpellbar = false;
    @Config.Name(value="Render Astro UI while Empty")
    @Config.Comment(value={"If false, the Astro UI will no longer render while not holding any card, spread, or royal road buff."})
    public static boolean renderAstro = true;
    @Config.Name(value="Render Royal Road Text")
    @Config.Comment(value={"Enables the text render for the Astro UI Royal Road. If disabled, only the icon will render."})
    public static boolean renderRoyalRoad = true;

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("aov")) {
            ConfigManager.sync((String)"aov", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class ElementPositions {
        @Config.Name(value="SpellBar X")
        public int spellbar_x = 0;
        @Config.Name(value="SpellBar Y")
        public int spellbar_y = 0;
        @Config.Name(value="Astro X")
        public int astro_x = 0;
        @Config.Name(value="Astro Y")
        public int astro_y = 0;
    }
}

