/*
 * Decompiled with CFR 0.152.
 */
package teamroots.roots.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import teamroots.roots.EventManager;
import teamroots.roots.capability.IPlayerDataCapability;
import teamroots.roots.capability.PlayerDataProvider;
import teamroots.roots.util.NoiseGenUtil;
import teamroots.roots.util.RenderUtil;

public class FeyMagicManager {
    public static final String FEY_TAG = "roots:fey_magic";
    public static final Float MAX_VALUE = Float.valueOf(256.0f);

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new FeyMagicManager());
    }

    public static void setFeyMagic(EntityPlayer player, float value) {
        if (player.hasCapability(PlayerDataProvider.playerDataCapability, null)) {
            NBTTagCompound tag = ((IPlayerDataCapability)player.getCapability(PlayerDataProvider.playerDataCapability, null)).getData();
            tag.func_74776_a(FEY_TAG, Math.min(MAX_VALUE.floatValue(), value));
            ((IPlayerDataCapability)player.getCapability(PlayerDataProvider.playerDataCapability, null)).markDirty();
        }
    }

    public static float getFeyMagic(EntityPlayer player) {
        NBTTagCompound tag;
        if (player.hasCapability(PlayerDataProvider.playerDataCapability, null) && (tag = ((IPlayerDataCapability)player.getCapability(PlayerDataProvider.playerDataCapability, null)).getData()).func_74764_b(FEY_TAG)) {
            return tag.func_74760_g(FEY_TAG);
        }
        return 0.0f;
    }

    public float getRed(float level) {
        if (level >= 0.0f && level < 0.25f) {
            float coeff = level * 4.0f;
            return 177.0f * (1.0f - coeff) + 219.0f * coeff;
        }
        if (level >= 0.25f && level < 0.5f) {
            float coeff = (level - 0.25f) * 4.0f;
            return 219.0f * (1.0f - coeff) + 255.0f * coeff;
        }
        if (level >= 0.5f && level < 0.75f) {
            float coeff = (level - 0.5f) * 4.0f;
            return 255.0f * (1.0f - coeff) + 255.0f * coeff;
        }
        if (level >= 0.75f && level < 1.0f) {
            float coeff = (level - 0.75f) * 4.0f;
            return 255.0f * (1.0f - coeff) + 177.0f * coeff;
        }
        return 0.0f;
    }

    public float getGreen(float level) {
        if (level >= 0.0f && level < 0.25f) {
            float coeff = level * 4.0f;
            return 255.0f * (1.0f - coeff) + 179.0f * coeff;
        }
        if (level >= 0.25f && level < 0.5f) {
            float coeff = (level - 0.25f) * 4.0f;
            return 179.0f * (1.0f - coeff) + 163.0f * coeff;
        }
        if (level >= 0.5f && level < 0.75f) {
            float coeff = (level - 0.5f) * 4.0f;
            return 163.0f * (1.0f - coeff) + 223.0f * coeff;
        }
        if (level >= 0.75f && level < 1.0f) {
            float coeff = (level - 0.75f) * 4.0f;
            return 223.0f * (1.0f - coeff) + 255.0f * coeff;
        }
        return 0.0f;
    }

    public float getBlue(float level) {
        if (level >= 0.0f && level < 0.25f) {
            float coeff = level * 4.0f;
            return 117.0f * (1.0f - coeff) + 255.0f * coeff;
        }
        if (level >= 0.25f && level < 0.5f) {
            float coeff = (level - 0.25f) * 4.0f;
            return 255.0f * (1.0f - coeff) + 255.0f * coeff;
        }
        if (level >= 0.5f && level < 0.75f) {
            float coeff = (level - 0.5f) * 4.0f;
            return 255.0f * (1.0f - coeff) + 163.0f * coeff;
        }
        if (level >= 0.75f && level < 1.0f) {
            float coeff = (level - 0.75f) * 4.0f;
            return 163.0f * (1.0f - coeff) + 117.0f * coeff;
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGameOverlayRender(RenderGameOverlayEvent.Post e) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        float f = FeyMagicManager.getFeyMagic((EntityPlayer)player);
        if (f > 0.0f) {
            int w = e.getResolution().func_78326_a();
            int h = e.getResolution().func_78328_b();
            int x = w / 2;
            int y = h / 2;
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder b = tess.func_178180_c();
            GlStateManager.func_179097_i();
            GlStateManager.func_179129_p();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179141_d();
            int func = GL11.glGetInteger((int)3009);
            float ref = GL11.glGetFloat((int)3010);
            GlStateManager.func_179092_a((int)519, (float)0.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179103_j((int)7425);
            b.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            double x1 = x - 90;
            double x2 = (double)(x - 90) + 180.0 * (double)f / (double)MAX_VALUE.floatValue();
            for (double j = 0.0; j < 50.0; j += 1.0) {
                float time = (float)(EventManager.ticks % 20L) / 20.0f;
                double coeff = j / 50.0;
                double coeff2 = (j + 1.0) / 50.0;
                float c = (float)coeff + time;
                c -= (float)((int)c);
                float c2 = (float)coeff2 + time;
                c2 -= (float)((int)c2);
                float r1 = this.getRed(c) / 255.0f;
                float r2 = this.getRed(c2) / 255.0f;
                float g1 = this.getGreen(c) / 255.0f;
                float g2 = this.getGreen(c2) / 255.0f;
                float b1 = this.getBlue(c) / 255.0f;
                float b2 = this.getBlue(c2) / 255.0f;
                for (double k = 0.0; k < 4.0; k += 0.5) {
                    float thick = (float)((k + 0.5) / 4.0);
                    double p1 = x1 * (1.0 - coeff) + x2 * coeff;
                    double p2 = x1 * (1.0 - coeff2) + x2 * coeff2;
                    float a1 = 0.25f + 0.75f * NoiseGenUtil.get2DNoise(0L, (int)((float)EventManager.ticks + Minecraft.func_71410_x().func_184121_ak() * 5.0f) + (int)(400.0 * coeff), 4) * MathHelper.func_76133_a((double)(Math.min(coeff * (double)(f / MAX_VALUE.floatValue()), 1.0 - coeff * (double)(f / MAX_VALUE.floatValue())) * 2.0));
                    float a2 = 0.25f + 0.75f * NoiseGenUtil.get2DNoise(0L, (int)((float)EventManager.ticks + Minecraft.func_71410_x().func_184121_ak() * 5.0f) + (int)(400.0 * coeff2), 4) * MathHelper.func_76133_a((double)(Math.min(coeff2 * (double)(f / MAX_VALUE.floatValue()), 1.0 - coeff2 * (double)(f / MAX_VALUE.floatValue())) * 2.0));
                    RenderUtil.drawColorRectBatched(b, p1, (double)h - 29.5 + (double)(3.0f * (1.0f - thick)), 0.0, p2 - p1, 3.0f * thick, r1, g1, b1, a1 * (1.0f - thick) * 0.25f, r2, g2, b2, a2 * (1.0f - thick) * 0.25f, r2, g2, b2, 0.0f, r1, g1, b1, 0.0f);
                    RenderUtil.drawColorRectBatched(b, p1, (double)h - 29.5 + (double)(3.0f * (1.0f - thick)) + (double)(3.0f * thick), 0.0, p2 - p1, 3.0f * thick, r1, g1, b1, 0.0f, r2, g2, b2, 0.0f, r2, g2, b2, a2 * (1.0f - thick) * 0.25f, r1, g1, b1, a1 * (1.0f - thick) * 0.25f);
                }
            }
            tess.func_78381_a();
            GlStateManager.func_179098_w();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("roots:textures/gui/fairy_icon.png"));
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179092_a((int)func, (float)ref);
            GlStateManager.func_179084_k();
            GlStateManager.func_179089_o();
            GlStateManager.func_179126_j();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("minecraft:textures/gui/icons.png"));
    }
}

