/*
 * Decompiled with CFR 0.152.
 */
package teamroots.roots.tileentity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.roots.network.PacketHandler;
import teamroots.roots.network.message.MessageTEUpdate;
import teamroots.roots.particle.ParticleUtil;
import teamroots.roots.ritual.RitualBase;
import teamroots.roots.ritual.RitualRegistry;
import teamroots.roots.tileentity.ITileEntityBase;
import teamroots.roots.util.Misc;

public class TileEntityBonfire
extends TileEntity
implements ITileEntityBase,
ITickable {
    float ticker = 0.0f;
    float pickupDelay = 0.0f;
    int burnTime = 0;
    boolean doBigFlame = false;
    public ItemStackHandler inventory = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            TileEntityBonfire.this.func_70296_d();
            if (!((TileEntityBonfire)TileEntityBonfire.this).field_145850_b.field_72995_K) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(TileEntityBonfire.this));
            }
        }
    };

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a("burnTime", this.burnTime);
        tag.func_74757_a("doBigFlame", this.doBigFlame);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        this.burnTime = tag.func_74762_e("burnTime");
        this.doBigFlame = tag.func_74767_n("doBigFlame");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!heldItem.func_190926_b()) {
            if (heldItem.func_77973_b() instanceof ItemFlintAndSteel) {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (int i = 0; i < this.inventory.getSlots(); ++i) {
                    stacks.add(this.inventory.getStackInSlot(i));
                }
                RitualBase ritual = RitualRegistry.getRitual(stacks);
                if (ritual != null && ritual.isValidForPos(world, pos)) {
                    ritual.doEffect(world, pos);
                    this.burnTime = ritual.duration;
                    this.doBigFlame = true;
                    for (int i = 0; i < this.inventory.getSlots(); ++i) {
                        this.inventory.extractItem(i, 1, false);
                    }
                    this.func_70296_d();
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
                }
            } else {
                for (int i = 0; i < 5; ++i) {
                    ItemStack toInsert;
                    ItemStack attemptedInsert;
                    if (!this.inventory.getStackInSlot(i).func_190926_b() || !(attemptedInsert = this.inventory.insertItem(i, toInsert = heldItem.func_77946_l(), true)).func_190926_b()) continue;
                    this.inventory.insertItem(i, toInsert, false);
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                    this.func_70296_d();
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
                    return true;
                }
            }
        }
        if (heldItem.func_190926_b() && !world.field_72995_K && hand == EnumHand.MAIN_HAND) {
            for (int i = 4; i >= 0; --i) {
                if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
                ItemStack extracted = this.inventory.extractItem(i, this.inventory.getStackInSlot(i).func_190916_E(), false);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, extracted));
                }
                this.func_70296_d();
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
                this.pickupDelay = 40.0f;
                return true;
            }
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K) {
            Misc.spawnInventoryInWorld(world, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, (IItemHandler)this.inventory);
        }
    }

    public void func_73660_a() {
        int i;
        this.ticker += 1.0f;
        if (this.pickupDelay > 0.0f) {
            this.pickupDelay -= 1.0f;
        }
        if (this.field_145850_b.field_72995_K && this.doBigFlame) {
            for (i = 0; i < 40; ++i) {
                ParticleUtil.spawnParticleFiery(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.125f + 0.75f * Misc.random.nextFloat(), (float)this.func_174877_v().func_177956_o() + 0.75f + 0.5f * Misc.random.nextFloat(), (float)this.func_174877_v().func_177952_p() + 0.125f + 0.75f * Misc.random.nextFloat(), 0.03125f * (Misc.random.nextFloat() - 0.5f), 0.125f * Misc.random.nextFloat(), 0.03125f * (Misc.random.nextFloat() - 0.5f), 255.0f, 224.0f, 32.0f, 0.75f, 9.0f + 9.0f * Misc.random.nextFloat(), 40);
            }
        }
        if (this.doBigFlame) {
            this.doBigFlame = false;
            this.func_70296_d();
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
        }
        if (this.burnTime > 0) {
            --this.burnTime;
            if (this.burnTime == 0) {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (int i2 = 0; i2 < this.inventory.getSlots(); ++i2) {
                    stacks.add(this.inventory.getStackInSlot(i2));
                }
                RitualBase ritual = RitualRegistry.getRitual(stacks);
                if (ritual != null && ritual.isValidForPos(this.field_145850_b, this.func_174877_v())) {
                    ritual.doEffect(this.field_145850_b, this.field_174879_c);
                    this.burnTime = ritual.duration;
                    for (int i3 = 0; i3 < this.inventory.getSlots(); ++i3) {
                        this.inventory.extractItem(i3, 1, false);
                    }
                    this.doBigFlame = true;
                    this.func_70296_d();
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
                }
            }
            if (this.field_145850_b.field_72995_K) {
                for (i = 0; i < 2; ++i) {
                    ParticleUtil.spawnParticleFiery(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.3125f + 0.375f * Misc.random.nextFloat(), (float)this.func_174877_v().func_177956_o() + 0.625f + 0.375f * Misc.random.nextFloat(), (float)this.func_174877_v().func_177952_p() + 0.3125f + 0.375f * Misc.random.nextFloat(), 0.03125f * (Misc.random.nextFloat() - 0.5f), 0.125f * Misc.random.nextFloat(), 0.03125f * (Misc.random.nextFloat() - 0.5f), 255.0f, 96.0f, 32.0f, 0.75f, 7.0f + 7.0f * Misc.random.nextFloat(), 40);
                }
            }
        }
        if ((int)this.ticker % 20 == 0 && this.pickupDelay == 0.0f) {
            List items = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1)));
            for (int i4 = 0; i4 < items.size(); ++i4) {
                ItemStack stack = ((EntityItem)items.get(i4)).func_92059_d();
                boolean isFull = false;
                boolean isEmpty = false;
                while (stack.func_190916_E() > 0 && !isFull && !isEmpty) {
                    isFull = true;
                    isEmpty = true;
                    int minStack = -1;
                    for (int j = 0; j < 5; ++j) {
                        if (stack == ItemStack.field_190927_a) continue;
                        isEmpty = false;
                        if (stack.func_77973_b() != this.inventory.getStackInSlot(j).func_77973_b() || stack.func_77952_i() != this.inventory.getStackInSlot(j).func_77952_i() || this.inventory.getStackInSlot(j).func_190916_E() >= this.inventory.getSlotLimit(j)) continue;
                        isFull = false;
                        if (minStack == -1) {
                            minStack = j;
                            continue;
                        }
                        if (this.inventory.getStackInSlot(j).func_190916_E() >= this.inventory.getStackInSlot(minStack).func_190916_E()) continue;
                        minStack = j;
                    }
                    if (minStack == -1 || minStack >= 5 || this.inventory.getStackInSlot(minStack) == ItemStack.field_190927_a || stack == ItemStack.field_190927_a) continue;
                    ItemStack toInsert = stack.func_77946_l();
                    toInsert.func_190920_e(1);
                    this.inventory.insertItem(minStack, toInsert, false);
                    this.func_70296_d();
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
                    stack.func_190918_g(1);
                    if (stack.func_190916_E() != 0) continue;
                    stack = ItemStack.field_190927_a;
                }
                ((EntityItem)items.get(i4)).func_92058_a(stack);
                this.func_70296_d();
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
            }
        }
    }
}

