/*
 * Decompiled with CFR 0.152.
 */
package teamroots.roots.spell;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.text.TextFormatting;
import teamroots.roots.util.InventoryUtil;

public class SpellBase {
    public float red1;
    public float green1;
    public float blue1;
    public float red2;
    public float green2;
    public float blue2;
    public TextFormatting textColor;
    public String name;
    public EnumCastType castType = EnumCastType.INSTANTANEOUS;
    public int cooldown = 20;
    public Map<String, Double> costs = new HashMap<String, Double>();

    public boolean costsMet(EntityPlayer player) {
        boolean matches = true;
        for (int i = 0; i < this.costs.size(); ++i) {
            String s = this.costs.keySet().toArray(new String[this.costs.size()])[i];
            double d = this.costs.values().toArray(new Double[this.costs.size()])[i];
            matches = matches && InventoryUtil.getPowderTotal(player, s) >= d;
        }
        return matches && this.costs.size() > 0 || player.field_71075_bZ.field_75098_d;
    }

    public void enactCosts(EntityPlayer player) {
        for (int i = 0; i < this.costs.size(); ++i) {
            String s = this.costs.keySet().toArray(new String[this.costs.size()])[i];
            double d = this.costs.values().toArray(new Double[this.costs.size()])[i];
            InventoryUtil.removePowder(player, s, d);
        }
    }

    public void enactTickCosts(EntityPlayer player) {
        for (int i = 0; i < this.costs.size(); ++i) {
            String s = this.costs.keySet().toArray(new String[this.costs.size()])[i];
            double d = this.costs.values().toArray(new Double[this.costs.size()])[i];
            InventoryUtil.removePowder(player, s, d / 20.0);
        }
    }

    public void addToolTip(List<String> tooltip) {
        tooltip.add("" + this.textColor + TextFormatting.BOLD + I18n.func_135052_a((String)("roots.spell." + this.name + ".name"), (Object[])new Object[0]) + TextFormatting.RESET);
        for (int i = 0; i < this.costs.size(); ++i) {
            String s = this.costs.keySet().toArray(new String[this.costs.size()])[i];
            double d = this.costs.values().toArray(new Double[this.costs.size()])[i];
            tooltip.add(I18n.func_135052_a((String)(s + ".name"), (Object[])new Object[0]) + I18n.func_135052_a((String)"roots.tooltip.pouch_divider", (Object[])new Object[0]) + d);
        }
    }

    public SpellBase(String name, TextFormatting textColor, float r1, float g1, float b1, float r2, float g2, float b2) {
        this.name = name;
        this.red1 = r1;
        this.green1 = g1;
        this.blue1 = b1;
        this.red2 = r2;
        this.green2 = g2;
        this.blue2 = b2;
        this.textColor = textColor;
    }

    public SpellBase addCost(Item herb, double amount) {
        this.costs.put(herb.func_77658_a(), amount);
        return this;
    }

    public void cast(EntityPlayer caster) {
    }

    public static enum EnumCastType {
        INSTANTANEOUS,
        CONTINUOUS;

    }
}

