/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.util;

import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class CommonUtils {
    public static final boolean DEV_ENV = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    public static final GameProfile FAKE_PLAYER_PROFILE = new GameProfile(StringUtils.fromString("069be1413c1b45c3b3b160d3f9fcd236"), "FakeForgePlayer");
    private static ListMultimap<String, ModContainer> packageOwners = null;
    public static File folderConfig;
    public static File folderMinecraft;
    public static File folderLocal;
    private static final Predicate<Object> PREDICATE_ALWAYS_TRUE;
    public static final Object[] NO_OBJECTS;
    public static final char[] HEX;
    public static final IBlockState AIR_STATE;

    public static <T> T cast(@Nullable Object o) {
        return (T)o;
    }

    public static <T> Predicate<T> alwaysTruePredicate() {
        return (Predicate)CommonUtils.cast(PREDICATE_ALWAYS_TRUE);
    }

    public static void init(File configFolder) {
        folderConfig = configFolder;
        folderMinecraft = folderConfig.getParentFile();
        folderLocal = new File(folderMinecraft, "local/");
        if (!folderLocal.exists()) {
            folderLocal.mkdirs();
        }
    }

    public static String getNameFromState(IBlockState state) {
        if (state == AIR_STATE) {
            return "minecraft:air";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(Block.field_149771_c.func_177774_c((Object)state.func_177230_c()));
        if (state != state.func_177230_c().func_176223_P() && !state.func_177228_b().isEmpty()) {
            builder.append('[');
            boolean first = true;
            for (Map.Entry entry : state.func_177228_b().entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                builder.append(((IProperty)entry.getKey()).func_177701_a());
                builder.append('=');
                builder.append(((IProperty)entry.getKey()).func_177702_a((Comparable)CommonUtils.cast(entry.getValue())));
            }
            builder.append(']');
        }
        return builder.toString();
    }

    public static IBlockState getStateFromName(String name, IBlockState def) {
        if (name.isEmpty()) {
            return def;
        }
        int p = name.indexOf(91);
        String stateName = p == -1 ? name : name.substring(0, p);
        IBlockState state = ((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(stateName))).func_176223_P();
        if (state == AIR_STATE) {
            return def;
        }
        if (p >= 0) {
            for (String property : name.substring(p + 1, name.length() - 1).split(",")) {
                Optional propValue;
                String[] p1 = property.split("=", 2);
                IProperty property1 = state.func_177230_c().func_176194_O().func_185920_a(p1[0]);
                if (property1 == null || !(propValue = property1.func_185929_b(p1[1])).isPresent()) continue;
                state = state.func_177226_a(property1, (Comparable)CommonUtils.cast(propValue.get()));
            }
        }
        return state;
    }

    public static IBlockState getStateFromName(String name) {
        return CommonUtils.getStateFromName(name, AIR_STATE);
    }

    public static void renameTag(NBTTagCompound nbt, String oldName, String newName) {
        NBTBase tag = nbt.func_74781_a(oldName);
        if (tag != null) {
            nbt.func_82580_o(oldName);
            nbt.func_74782_a(newName, tag);
        }
    }

    @Nullable
    public static NBTTagCompound nonnull(@Nullable NBTTagCompound nbt) {
        return nbt == null || nbt.func_82582_d() ? null : nbt;
    }

    @Nullable
    public static NBTTagList nonnull(@Nullable NBTTagList nbt) {
        return nbt == null || nbt.func_82582_d() ? null : nbt;
    }

    public static IBlockState notifyBlockUpdate(World world, BlockPos pos, @Nullable IBlockState state) {
        if (state == null) {
            state = world.func_180495_p(pos);
        }
        world.func_184138_a(pos, state, state, 11);
        return state;
    }

    public static boolean hasBlockData(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("BlockEntityTag");
    }

    public static NBTTagCompound getBlockData(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74775_l("BlockEntityTag") : new NBTTagCompound();
    }

    @Nullable
    public static ModContainer getModContainerForClass(Class clazz) {
        if (packageOwners == null) {
            try {
                LoadController instance = (LoadController)ReflectionHelper.getPrivateValue(Loader.class, (Object)Loader.instance(), (String[])new String[]{"modController"});
                packageOwners = (ListMultimap)ReflectionHelper.getPrivateValue(LoadController.class, (Object)instance, (String[])new String[]{"packageOwners"});
            }
            catch (Exception ex) {
                packageOwners = ImmutableListMultimap.of();
            }
        }
        if (packageOwners.isEmpty()) {
            return null;
        }
        String pkg = clazz.getName().substring(0, clazz.getName().lastIndexOf(46));
        return packageOwners.containsKey((Object)pkg) ? (ModContainer)packageOwners.get((Object)pkg).get(0) : null;
    }

    static {
        PREDICATE_ALWAYS_TRUE = object -> true;
        NO_OBJECTS = new Object[0];
        HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        AIR_STATE = Blocks.field_150350_a.func_176223_P();
    }
}

