/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.item;

import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class ItemStackSerializer {
    public static ItemStack parseItem(String input) {
        String[] s1;
        if ((input = input.trim()).isEmpty() || input.equals("-")) {
            return ItemStack.field_190927_a;
        }
        if (input.startsWith("{") && input.endsWith("}")) {
            try {
                ItemStack stack = new ItemStack(JsonToNBT.func_180713_a((String)input));
                if (!stack.func_190926_b()) {
                    return stack;
                }
            }
            catch (NBTException e) {
                e.printStackTrace();
            }
        }
        if ((s1 = input.split(" ", 4)).length == 0) {
            return ItemStack.field_190927_a;
        }
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(s1[0]));
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        int stackSize = 1;
        int meta = 0;
        if (s1.length >= 2) {
            stackSize = MathHelper.func_82715_a((String)s1[1], (int)1);
        }
        if (s1.length >= 3) {
            meta = s1[2].charAt(0) == '*' ? Short.MAX_VALUE : MathHelper.func_82715_a((String)s1[2], (int)0);
        }
        ItemStack itemstack = new ItemStack(item, stackSize, meta);
        if (s1.length >= 4) {
            try {
                itemstack.func_77982_d(JsonToNBT.func_180713_a((String)s1[3]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return itemstack;
    }

    public static String toString(ItemStack is) {
        if (is.func_190926_b()) {
            return "-";
        }
        StringBuilder builder = new StringBuilder(String.valueOf(Item.field_150901_e.func_177774_c((Object)is.func_77973_b())));
        int count = is.func_190916_E();
        int meta = is.func_77960_j();
        NBTTagCompound tag = is.func_77978_p();
        if (count > 1 || meta != 0 || tag != null) {
            builder.append(' ');
            builder.append(count);
        }
        if (meta != 0 || tag != null) {
            builder.append(' ');
            builder.append(meta);
        }
        if (tag != null) {
            builder.append(' ');
            builder.append(tag);
        }
        return builder.toString();
    }

    public static JsonElement serialize(ItemStack is, boolean forceNonnull, boolean string) {
        if (!forceNonnull && is.func_190926_b()) {
            return JsonNull.INSTANCE;
        }
        if (string) {
            return new JsonPrimitive(ItemStackSerializer.toString(is));
        }
        JsonObject json = new JsonObject();
        ResourceLocation id = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)is.func_77973_b());
        json.addProperty("item", id == null ? "minecraft:air" : id.toString());
        if (is.func_77981_g()) {
            json.addProperty("data", (Number)is.func_77960_j());
        }
        if (is.func_190916_E() > 1) {
            json.addProperty("count", (Number)is.func_190916_E());
        }
        if (is.func_77942_o()) {
            json.add("nbt", JsonUtils.toJson((NBTBase)is.func_77978_p()));
        }
        return json;
    }

    public static ItemStack deserialize(JsonElement e) {
        ItemStack stack;
        if (e.isJsonNull()) {
            return ItemStack.field_190927_a;
        }
        if (e.isJsonPrimitive()) {
            return ItemStackSerializer.parseItem(e.getAsString());
        }
        JsonObject json = e.getAsJsonObject();
        if (!json.has("item")) {
            return ItemStack.field_190927_a;
        }
        Item item = Item.func_111206_d((String)json.get("id").getAsString());
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        int meta = 0;
        if (item.func_77614_k() && json.has("data")) {
            meta = json.get("data").getAsInt();
        }
        int count = 1;
        if (json.has("count")) {
            count = json.get("count").getAsInt();
        }
        if ((stack = new ItemStack(item, count, meta)).func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (json.has("nbt")) {
            stack.func_77982_d((NBTTagCompound)JsonUtils.toNBT(json.get("nbt")));
        }
        return stack;
    }
}

