/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.io;

import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.io.RequestMethod;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.feed_the_beast.ftblib.lib.util.StringJoiner;
import com.google.gson.JsonElement;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpDataReader
extends DataReader {
    public final URL url;
    public final RequestMethod requestMethod;
    public final String contentType;
    public final HttpDataOutput data;
    public final Proxy proxy;

    HttpDataReader(URL u, RequestMethod r, String c, @Nullable HttpDataOutput d, Proxy p) {
        this.url = u;
        this.requestMethod = r;
        this.contentType = c;
        this.data = d;
        this.proxy = p;
    }

    public String toString() {
        return this.url.toString();
    }

    private HttpURLConnection getConnection() throws Exception {
        int responseCode;
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection(this.proxy);
        if (connection instanceof HttpsURLConnection) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                ((HttpsURLConnection)connection).setSSLSocketFactory(sc.getSocketFactory());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        connection.setRequestMethod(this.requestMethod.name());
        connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-GB; rv:1.9.0.3) Gecko/2008092417 Firefox/3.0.3");
        if (!this.contentType.isEmpty()) {
            connection.setRequestProperty("Content-Type", this.contentType);
        }
        connection.setDoInput(true);
        if (this.data != null) {
            connection.setDoOutput(true);
            OutputStream os = connection.getOutputStream();
            this.data.writeData(os);
            os.flush();
            os.close();
        }
        if ((responseCode = connection.getResponseCode()) / 100 != 2) {
            throw new ConnectionNotOKException(responseCode);
        }
        return connection;
    }

    /*
     * Loose catch block
     */
    @Override
    public String string(int bufferSize) throws Exception {
        HttpURLConnection connection = this.getConnection();
        try {
            try (InputStream stream = connection.getInputStream();){
                String string = HttpDataReader.readStringFromStream(stream, bufferSize);
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            connection.disconnect();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public List<String> stringList() throws Exception {
        HttpURLConnection connection = this.getConnection();
        try {
            try (InputStream stream = connection.getInputStream();){
                List<String> list = HttpDataReader.readStringListFromStream(stream);
                return list;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            connection.disconnect();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public JsonElement json() throws Exception {
        HttpURLConnection connection = this.getConnection();
        try {
            try (InputStream stream = connection.getInputStream();){
                JsonElement jsonElement = JsonUtils.parse(new InputStreamReader(stream, StandardCharsets.UTF_8));
                return jsonElement;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            connection.disconnect();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public BufferedImage image() throws Exception {
        HttpURLConnection connection = this.getConnection();
        try {
            try (InputStream stream = connection.getInputStream();){
                BufferedImage bufferedImage = ImageIO.read(stream);
                return bufferedImage;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            connection.disconnect();
        }
    }

    public static class ConnectionNotOKException
    extends IllegalStateException {
        private final int responseCode;

        public ConnectionNotOKException(int code) {
            super("Connection not OK! Response code: " + code);
            this.responseCode = code;
        }

        public int getResponseCode() {
            return this.responseCode;
        }
    }

    public static interface HttpDataOutput {
        public void writeData(OutputStream var1) throws Exception;

        public static class StringOutput
        implements HttpDataOutput {
            private final String string;

            public StringOutput(String text) {
                this.string = text;
            }

            public StringOutput(Iterable<String> text) {
                this(StringJoiner.with('\n').join(text));
            }

            @Override
            public void writeData(OutputStream output) throws Exception {
                new OutputStreamWriter(output).write(this.string);
            }
        }
    }
}

