/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.icon;

import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ImageIcon;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PartIcon
extends ImageIcon {
    public final ImageIcon parent;
    public final boolean repeat;
    public final int width;
    public final int height;
    public final int corner;
    public final int middleH;
    public final int middleV;
    private final Icon all;
    private final Icon middleU;
    private final Icon middleD;
    private final Icon middleL;
    private final Icon middleR;
    private final Icon cornerNN;
    private final Icon cornerPN;
    private final Icon cornerNP;
    private final Icon cornerPP;
    private final Icon center;

    public PartIcon(ImageIcon icon, int x, int y, int w, int h, int c, int mh, int mv, boolean r) {
        super(icon.texture);
        this.parent = icon;
        this.width = w;
        this.height = h;
        this.corner = c;
        this.middleH = mh;
        this.middleV = mv;
        this.repeat = r;
        int cmh = c + mh;
        int cmv = c + mv;
        this.all = this.parent.withUVfromCoords(x, y, c + mh + c, c + mv + c, w, h);
        this.middleU = this.parent.withUVfromCoords(x + c, y, mh, c, w, h);
        this.middleD = this.parent.withUVfromCoords(x + c, y + cmv, mh, c, w, h);
        this.middleL = this.parent.withUVfromCoords(x, y + c, c, mv, w, h);
        this.middleR = this.parent.withUVfromCoords(x + cmh, y + c, c, mv, w, h);
        this.cornerNN = this.parent.withUVfromCoords(x, y, c, c, w, h);
        this.cornerPN = this.parent.withUVfromCoords(x + cmh, y, c, c, w, h);
        this.cornerNP = this.parent.withUVfromCoords(x, y + cmv, c, c, w, h);
        this.cornerPP = this.parent.withUVfromCoords(x + cmh, y + cmv, c, c, w, h);
        this.center = this.parent.withUVfromCoords(x + c, y + c, mh, mv, w, h);
    }

    public PartIcon(ImageIcon icon, int s, int c, int m) {
        this(icon, 0, 0, s, s, c, m, m, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void bindTexture() {
        this.parent.bindTexture();
    }

    @Override
    public void draw(int x, int y, int w, int h, Color4I col) {
        this.bindTexture();
        if (w == this.width && h == this.height) {
            this.all.draw(x, y, w, h, col);
            return;
        }
        int c = this.corner;
        int mw = w - c * 2;
        int mh = h - c * 2;
        this.middleU.draw(x + c, y, mw, c, col);
        this.middleR.draw(x + w - c, y + c, c, mh, col);
        this.middleD.draw(x + c, y + h - c, mw, c, col);
        this.middleL.draw(x, y + c, c, mh, col);
        this.cornerNN.draw(x, y, c, c, col);
        this.cornerNP.draw(x, y + h - c, c, c, col);
        this.cornerPN.draw(x + w - c, y, c, c, col);
        this.cornerPP.draw(x + w - c, y + h - c, c, c, col);
        this.center.draw(x + c, y + c, mw, mh, col);
    }

    @Override
    public JsonElement getJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", "part");
        json.add("parent", this.parent.getJson());
        json.addProperty("width", (Number)this.width);
        json.addProperty("height", (Number)this.height);
        json.addProperty("corner", (Number)this.corner);
        json.addProperty("middle_h", (Number)this.middleH);
        json.addProperty("middle_v", (Number)this.middleV);
        return json;
    }
}

