/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui.misc;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.data.Action;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.util.ResourceLocation;

public class GuiActionList
extends GuiButtonListBase {
    private final ArrayList<Action.Inst> actions;
    private final Consumer<ResourceLocation> callback;

    public GuiActionList(String title, Collection<Action.Inst> a, Consumer<ResourceLocation> c) {
        this.setTitle(title);
        this.actions = new ArrayList<Action.Inst>(a);
        this.actions.sort(null);
        this.callback = c;
    }

    @Override
    public void addButtons(Panel panel) {
        for (Action.Inst a : this.actions) {
            panel.add(new ActionButton(panel, a));
        }
    }

    private class ActionButton
    extends SimpleTextButton {
        private final Action.Inst action;

        private ActionButton(Panel panel, Action.Inst a) {
            super(panel, a.title.func_150254_d(), a.icon);
            this.action = a;
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            if (this.action.requiresConfirm) {
                ClientUtils.MC.func_147108_a((GuiScreen)new GuiYesNo((result, id) -> {
                    this.getGui().openGui();
                    if (result) {
                        GuiActionList.this.callback.accept(this.action.id);
                    }
                }, this.action.title.func_150254_d() + "?", "", 0));
            } else {
                GuiActionList.this.callback.accept(this.action.id);
            }
        }

        @Override
        public boolean renderTitleInCenter() {
            return false;
        }

        @Override
        public WidgetType getWidgetType() {
            return this.action.enabled ? WidgetType.mouseOver(this.isMouseOver()) : WidgetType.DISABLED;
        }
    }
}

