/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui;

import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import java.util.List;

public abstract class SimpleTextButton
extends Button {
    public SimpleTextButton(Panel panel, String txt, Icon icon) {
        super(panel, txt, icon);
        this.setHeight(20);
    }

    @Override
    public SimpleTextButton setTitle(String txt) {
        super.setTitle(txt);
        this.setWidth(this.getStringWidth(this.getTitle()) + (this.getIcon().isEmpty() ? 8 : 28));
        return this;
    }

    public boolean renderTitleInCenter() {
        return false;
    }

    @Override
    public void addMouseOverText(List<String> list) {
        if (this.getStringWidth(this.getTitle()) + (this.getIcon().isEmpty() ? 8 : 28) > this.width) {
            list.add(this.getTitle());
        }
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void draw() {
        int ax = this.getAX();
        int ay = this.getAY();
        this.getButtonBackground().draw(ax, ay, this.width, this.height);
        int off = (this.height - 16) / 2;
        Icon icon = this.getIcon();
        String title = this.getTitle();
        int textX = ax;
        int textY = ay + (this.height - this.getFontHeight() + 1) / 2;
        textX = this.renderTitleInCenter() ? (textX += (this.width - this.getStringWidth(title) - (icon.isEmpty() ? 0 : off + 16)) / 2) : (textX += 4);
        if (!icon.isEmpty()) {
            icon.draw(ax + off, ay + off, 16, 16);
            textX += off + 16;
        }
        this.drawString(title, textX, textY, this.getTheme().getContentColor(this.getWidgetType()), 2);
    }
}

