/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.data;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.events.ServerReloadEvent;
import com.feed_the_beast.ftblib.events.player.ForgePlayerLoggedInEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamCreatedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamPlayerJoinedEvent;
import com.feed_the_beast.ftblib.events.universe.PersistentScheduledTaskEvent;
import com.feed_the_beast.ftblib.events.universe.UniverseClearCacheEvent;
import com.feed_the_beast.ftblib.events.universe.UniverseClosedEvent;
import com.feed_the_beast.ftblib.events.universe.UniverseLoadedEvent;
import com.feed_the_beast.ftblib.events.universe.UniverseSavedEvent;
import com.feed_the_beast.ftblib.lib.EnumReloadType;
import com.feed_the_beast.ftblib.lib.EnumTeamColor;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.IHasCache;
import com.feed_the_beast.ftblib.lib.data.TeamType;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.util.CommonUtils;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftblib.lib.util.ServerUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.IScheduledTask;
import com.feed_the_beast.ftblib.lib.util.misc.TimeType;
import com.feed_the_beast.ftblib.net.MessageSyncData;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="ftblib")
public class Universe
implements IHasCache {
    private static Universe INSTANCE = null;
    @Nonnull
    public final MinecraftServer server;
    public final WorldServer world;
    public final Map<UUID, ForgePlayer> players;
    public final Map<String, ForgeTeam> teams;
    private final ForgeTeam noneTeam;
    private UUID uuid;
    private boolean needsSaving;
    boolean checkSaving;
    public ForgeTeam fakePlayerTeam;
    public ForgePlayer fakePlayer;
    private final List<ScheduledTask> scheduledTasks;
    private final List<PersistentScheduledTask> persistentScheduledTasks;
    private final List<ScheduledTask> scheduledTaskQueue;
    private final List<PersistentScheduledTask> persistentScheduledTaskQueue;
    public long ticks;

    public static boolean loaded() {
        return INSTANCE != null;
    }

    public static Universe get() {
        if (INSTANCE == null) {
            throw new NullPointerException("FTBLib Universe == null!");
        }
        return INSTANCE;
    }

    @SubscribeEvent
    public static void onWorldLoaded(WorldEvent.Load event) {
        if (event.getWorld().field_73011_w.getDimension() == 0 && !event.getWorld().field_72995_K) {
            INSTANCE = new Universe((WorldServer)event.getWorld());
            INSTANCE.load();
        }
    }

    @SubscribeEvent
    public static void onWorldUnloaded(WorldEvent.Unload event) {
        if (Universe.loaded() && event.getWorld() == Universe.INSTANCE.world) {
            for (ForgePlayer player : INSTANCE.getPlayers()) {
                player.onLoggedOut();
            }
            new UniverseClosedEvent(INSTANCE).post();
            INSTANCE.save();
            INSTANCE = null;
        }
    }

    @SubscribeEvent
    public static void onWorldSaved(WorldEvent.Save event) {
        if (Universe.loaded() && event.getWorld() == Universe.INSTANCE.world) {
            INSTANCE.save();
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (Universe.loaded() && event.player instanceof EntityPlayerMP && !ServerUtils.isFake((EntityPlayerMP)event.player)) {
            INSTANCE.onPlayerLoggedIn((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (Universe.loaded() && event.player instanceof EntityPlayerMP) {
            INSTANCE.onPlayerLoggedOut((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onTickEvent(TickEvent.WorldTickEvent event) {
        if (!Universe.loaded()) {
            return;
        }
        Universe universe = Universe.get();
        if (event.phase == TickEvent.Phase.START) {
            universe.ticks = universe.world.func_82737_E();
        } else if (!event.world.field_72995_K && event.world.field_73011_w.getDimension() == 0) {
            universe.scheduledTasks.addAll(universe.scheduledTaskQueue);
            universe.scheduledTaskQueue.clear();
            universe.persistentScheduledTasks.addAll(universe.persistentScheduledTaskQueue);
            universe.persistentScheduledTaskQueue.clear();
            Iterator<ScheduledTask> iterator = universe.scheduledTasks.iterator();
            while (iterator.hasNext()) {
                ScheduledTask task = iterator.next();
                if (!task.task.isComplete(universe, task.type, task.time)) continue;
                task.task.execute(universe);
                iterator.remove();
            }
            Iterator<PersistentScheduledTask> piterator = universe.persistentScheduledTasks.iterator();
            while (piterator.hasNext()) {
                PersistentScheduledTask task = piterator.next();
                if (universe.ticks < task.time) continue;
                new PersistentScheduledTaskEvent(universe, task.id, task.data).post();
                piterator.remove();
            }
        }
    }

    public Universe(WorldServer w) {
        this.server = w.func_73046_m();
        this.world = w;
        this.ticks = this.world.func_82737_E();
        this.players = new HashMap<UUID, ForgePlayer>();
        this.teams = new HashMap<String, ForgeTeam>();
        this.noneTeam = new ForgeTeam(this, "", TeamType.NONE);
        this.uuid = null;
        this.needsSaving = false;
        this.checkSaving = true;
        this.scheduledTasks = new ArrayList<ScheduledTask>();
        this.persistentScheduledTasks = new ArrayList<PersistentScheduledTask>();
        this.scheduledTaskQueue = new ArrayList<ScheduledTask>();
        this.persistentScheduledTaskQueue = new ArrayList<PersistentScheduledTask>();
    }

    public void markDirty() {
        this.needsSaving = true;
        this.checkSaving = true;
    }

    public UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            this.markDirty();
        }
        return this.uuid;
    }

    public void scheduleTask(TimeType type, long time, IScheduledTask task) {
        this.scheduledTaskQueue.add(new ScheduledTask(type, time, task));
    }

    public void scheduleTask(ResourceLocation id, TimeType type, long time, NBTTagCompound data) {
        this.persistentScheduledTaskQueue.add(new PersistentScheduledTask(id, type, time, data));
        this.markDirty();
    }

    private void load() {
        NBTTagCompound nbt;
        File[] files;
        File worldDataJsonFile;
        JsonElement worldData;
        File folder = new File(this.getWorldDirectory(), "data/ftb_lib/");
        NBTTagCompound universeData = FileUtils.readNBT(new File(folder, "universe.dat"));
        if (universeData == null) {
            universeData = new NBTTagCompound();
        }
        if ((worldData = DataReader.get(worldDataJsonFile = new File(this.getWorldDirectory(), "world_data.json")).safeJson()).isJsonObject()) {
            JsonObject jsonWorldData = worldData.getAsJsonObject();
            if (jsonWorldData.has("world_id")) {
                universeData.func_74778_a("UUID", jsonWorldData.get("world_id").getAsString());
            }
            worldDataJsonFile.delete();
        }
        this.uuid = StringUtils.fromString(universeData.func_74779_i("UUID"));
        if (this.uuid != null && this.uuid.getLeastSignificantBits() == 0L && this.uuid.getMostSignificantBits() == 0L) {
            this.uuid = null;
        }
        NBTTagList taskTag = universeData.func_150295_c("PersistentScheduledTasks", 10);
        for (int i = 0; i < taskTag.func_74745_c(); ++i) {
            NBTTagCompound taskData = taskTag.func_150305_b(i);
            this.persistentScheduledTasks.add(new PersistentScheduledTask(new ResourceLocation(taskData.func_74779_i("ID")), TimeType.NAME_MAP.get(taskData.func_74779_i("Type")), taskData.func_74763_f("Time"), taskData.func_74775_l("Data")));
        }
        NBTTagCompound data = universeData.func_74775_l("Data");
        new UniverseLoadedEvent.Pre(this, this.world, data).post();
        HashMap<UUID, NBTTagCompound> playerNBT = new HashMap<UUID, NBTTagCompound>();
        HashMap<String, NBTTagCompound> teamNBT = new HashMap<String, NBTTagCompound>();
        try {
            files = new File(folder, "players").listFiles();
            if (files != null && files.length > 0) {
                for (File f : files) {
                    UUID uuid;
                    if (!f.getName().endsWith(".dat") || (nbt = FileUtils.readNBT(f)) == null) continue;
                    String uuidString = nbt.func_74779_i("UUID");
                    if (uuidString.isEmpty()) {
                        uuidString = FileUtils.getBaseName(f);
                        FileUtils.delete(f);
                    }
                    if ((uuid = StringUtils.fromString(uuidString)) == null) continue;
                    playerNBT.put(uuid, nbt);
                    ForgePlayer player = new ForgePlayer(this, uuid, nbt.func_74779_i("Name"));
                    this.players.put(uuid, player);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            files = new File(folder, "teams").listFiles();
            if (files != null && files.length > 0) {
                for (File file : files) {
                    if (!file.getName().endsWith(".dat") || (nbt = FileUtils.readNBT(file)) == null) continue;
                    String s = FileUtils.getBaseName(file);
                    teamNBT.put(s, nbt);
                    this.teams.put(s, new ForgeTeam(this, s, TeamType.NAME_MAP.get(nbt.func_74779_i("Type"))));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.fakePlayerTeam = new ForgeTeam(this, "fakeplayer", TeamType.SERVER_NO_SAVE){

            @Override
            public void markDirty() {
                Universe.this.markDirty();
            }
        };
        this.fakePlayer = new ForgePlayer(this, CommonUtils.FAKE_PLAYER_PROFILE.getId(), CommonUtils.FAKE_PLAYER_PROFILE.getName()){

            @Override
            public void markDirty() {
                Universe.this.markDirty();
            }

            @Override
            public boolean isFake() {
                return true;
            }
        };
        this.fakePlayer.team = this.fakePlayerTeam;
        this.fakePlayerTeam.setColor(EnumTeamColor.GRAY);
        new UniverseLoadedEvent.CreateServerTeams(this, this.world).post();
        for (ForgePlayer player : this.players.values()) {
            NBTTagCompound nbt2 = (NBTTagCompound)playerNBT.get(player.getId());
            if (nbt2 == null || nbt2.func_82582_d()) continue;
            player.team = this.getTeam(nbt2.func_74779_i("TeamID"));
            player.deserializeNBT(nbt2);
        }
        for (ForgeTeam team : this.teams.values()) {
            NBTTagCompound nbt3;
            if (!team.type.save || (nbt3 = (NBTTagCompound)teamNBT.get(team.func_176610_l())) == null || nbt3.func_82582_d()) continue;
            team.deserializeNBT(nbt3);
        }
        if (universeData.func_74764_b("FakePlayer")) {
            this.fakePlayer.deserializeNBT(universeData.func_74775_l("FakePlayer"));
        }
        if (universeData.func_74764_b("FakeTeam")) {
            this.fakePlayerTeam.deserializeNBT(universeData.func_74775_l("FakeTeam"));
        }
        this.fakePlayerTeam.owner = this.fakePlayer;
        new UniverseLoadedEvent.Post(this, this.world, data).post();
        new UniverseLoadedEvent.Finished(this, this.world).post();
        FTBLibAPI.reloadServer(this, (ICommandSender)this.server, EnumReloadType.CREATED, ServerReloadEvent.ALL);
    }

    private void save() {
        NBTTagCompound nbt;
        if (!this.checkSaving) {
            return;
        }
        File worldDirectory = this.getWorldDirectory();
        NBTTagCompound universeData = new NBTTagCompound();
        HashMap<String, NBTTagCompound> playerDataMap = new HashMap<String, NBTTagCompound>();
        HashMap<String, NBTTagCompound> teamDataMap = new HashMap<String, NBTTagCompound>();
        if (this.needsSaving) {
            NBTTagCompound data = new NBTTagCompound();
            new UniverseSavedEvent(this, data).post();
            universeData.func_74782_a("Data", (NBTBase)data);
            universeData.func_74778_a("UUID", StringUtils.fromUUID(this.getUUID()));
            NBTTagList taskTag = new NBTTagList();
            for (PersistentScheduledTask task : this.persistentScheduledTasks) {
                NBTTagCompound taskData = new NBTTagCompound();
                taskData.func_74778_a("ID", task.id.toString());
                taskData.func_74778_a("Type", TimeType.NAME_MAP.getName(task.type));
                taskData.func_74772_a("Time", task.time);
                taskData.func_74782_a("Data", (NBTBase)task.data);
                taskTag.func_74742_a((NBTBase)taskData);
            }
            universeData.func_74782_a("PersistentScheduledTasks", (NBTBase)taskTag);
            universeData.func_74782_a("FakePlayer", (NBTBase)this.fakePlayer.serializeNBT());
            universeData.func_74782_a("FakeTeam", (NBTBase)this.fakePlayerTeam.serializeNBT());
            this.needsSaving = false;
        }
        for (ForgePlayer player : this.players.values()) {
            if (!player.needsSaving) continue;
            nbt = player.serializeNBT();
            nbt.func_74778_a("Name", player.func_176610_l());
            nbt.func_74778_a("UUID", StringUtils.fromUUID(player.getId()));
            nbt.func_74778_a("TeamID", player.team.func_176610_l());
            playerDataMap.put(player.func_176610_l().toLowerCase(), nbt);
            player.needsSaving = false;
        }
        for (ForgeTeam team : this.teams.values()) {
            if (!team.needsSaving) continue;
            if (team.type.save && team.isValid()) {
                nbt = team.serializeNBT();
                nbt.func_74778_a("Type", team.type.func_176610_l());
                teamDataMap.put(team.func_176610_l(), nbt);
                team.needsSaving = false;
            } else {
                File file = new File(worldDirectory, "data/ftb_lib/teams/" + team.func_176610_l() + ".dat");
                if (file.exists()) {
                    file.delete();
                }
            }
            team.needsSaving = false;
        }
        if (!(universeData.func_82582_d() && playerDataMap.isEmpty() && teamDataMap.isEmpty())) {
            ThreadedFileIOBase.func_178779_a().func_75735_a(() -> {
                if (FTBLibConfig.debugging.print_more_info) {
                    FTBLib.LOGGER.info("Saving data");
                }
                File folder = new File(worldDirectory, "data/ftb_lib");
                if (!universeData.func_82582_d()) {
                    FileUtils.writeNBT(new File(folder, "universe.dat"), universeData);
                    if (FTBLibConfig.debugging.print_more_info) {
                        FTBLib.LOGGER.info("Saved universe data");
                    }
                }
                for (Map.Entry entry : playerDataMap.entrySet()) {
                    FileUtils.writeNBT(new File(folder, "players/" + (String)entry.getKey() + ".dat"), (NBTTagCompound)entry.getValue());
                    if (!FTBLibConfig.debugging.print_more_info) continue;
                    FTBLib.LOGGER.info("Saved player data for " + (String)entry.getKey());
                }
                for (Map.Entry entry : teamDataMap.entrySet()) {
                    FileUtils.writeNBT(new File(folder, "teams/" + (String)entry.getKey() + ".dat"), (NBTTagCompound)entry.getValue());
                    if (!FTBLibConfig.debugging.print_more_info) continue;
                    FTBLib.LOGGER.info("Saved team data for " + (String)entry.getKey());
                }
                return false;
            });
        }
        this.checkSaving = false;
    }

    public File getWorldDirectory() {
        return this.world.func_72860_G().func_75765_b();
    }

    private void onPlayerLoggedIn(EntityPlayerMP player) {
        boolean firstLogin;
        if (!player.field_71133_b.func_184103_al().func_152607_e(player.func_146103_bH())) {
            return;
        }
        ForgePlayer p = this.getPlayer(player.func_146103_bH());
        boolean bl = firstLogin = p == null;
        if (firstLogin) {
            p = new ForgePlayer(this, player.func_110124_au(), player.func_70005_c_());
            this.players.put(p.getId(), p);
            p.clearCache();
        } else if (!p.func_176610_l().equals(player.func_70005_c_())) {
            p.setName(player.func_70005_c_());
        }
        boolean sendTeamJoinEvent = false;
        boolean sendTeamCreatedEvent = false;
        if (firstLogin && (player.field_71133_b.func_71264_H() ? FTBLibConfig.teams.autocreate_sp : FTBLibConfig.teams.autocreate_mp)) {
            if (!player.field_71133_b.func_71264_H()) {
                String id = p.func_176610_l().toLowerCase();
                if (this.getTeam(id).isValid()) {
                    id = StringUtils.fromUUID(p.getId());
                }
                if (!this.getTeam(id).isValid()) {
                    ForgeTeam team = new ForgeTeam(this, id, TeamType.PLAYER);
                    team.owner = p;
                    this.teams.put(team.func_176610_l(), team);
                    p.team = team;
                    team.markDirty();
                    sendTeamCreatedEvent = true;
                    sendTeamJoinEvent = true;
                }
            } else {
                ForgeTeam team = this.getTeam("singleplayer");
                if (!team.isValid()) {
                    team = new ForgeTeam(this, "singleplayer", TeamType.PLAYER);
                    team.setFreeToJoin(true);
                    team.owner = p;
                    this.teams.put(team.func_176610_l(), team);
                    p.team = team;
                    team.markDirty();
                    sendTeamCreatedEvent = true;
                } else {
                    p.team = team;
                }
                sendTeamJoinEvent = true;
            }
        }
        p.entityPlayer = player;
        p.clearCache();
        if (!p.isFake()) {
            p.lastTimeSeen = this.ticks;
            new MessageSyncData(true, player, p).sendTo(p.entityPlayer);
        }
        new ForgePlayerLoggedInEvent(p).post();
        if (sendTeamCreatedEvent) {
            new ForgeTeamCreatedEvent(p.team).post();
        }
        if (sendTeamJoinEvent) {
            new ForgeTeamPlayerJoinedEvent(p).post();
        }
        if (!p.hideTeamNotification() && !p.hasTeam()) {
            ITextComponent b1 = FTBLib.lang((ICommandSender)player, "click_here", new Object[0]);
            b1.func_150256_b().func_150238_a(TextFormatting.GOLD);
            b1.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ftblib_simulate_button custom:ftblib:my_team_gui"));
            b1.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, FTBLib.lang((ICommandSender)player, "sidebar_button.ftblib.my_team", new Object[0])));
            ITextComponent b2 = FTBLib.lang((ICommandSender)player, "click_here", new Object[0]);
            b2.func_150256_b().func_150238_a(TextFormatting.GOLD);
            b2.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/my_settings ftblib.hide_team_notification toggle"));
            b2.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, FTBLib.lang((ICommandSender)player, "ftblib.lang.team.notification.hide", new Object[0])));
            player.func_145747_a(FTBLib.lang((ICommandSender)player, "ftblib.lang.team.notification", b1, b2));
        }
        p.markDirty();
    }

    private void onPlayerLoggedOut(EntityPlayerMP player) {
        ForgePlayer p = INSTANCE.getPlayer(player.func_146103_bH());
        if (p != null) {
            p.onLoggedOut();
        }
    }

    public Collection<ForgePlayer> getPlayers() {
        return this.players.values();
    }

    @Nullable
    public ForgePlayer getPlayer(@Nullable UUID id) {
        if (id == null || id.getLeastSignificantBits() == 0L && id.getMostSignificantBits() == 0L) {
            return null;
        }
        if (id.equals(CommonUtils.FAKE_PLAYER_PROFILE.getId())) {
            return this.fakePlayer;
        }
        return this.players.get(id);
    }

    @Nullable
    public ForgePlayer getPlayer(CharSequence nameOrId) {
        String s = nameOrId.toString().toLowerCase();
        if (s.isEmpty()) {
            return null;
        }
        UUID id = StringUtils.fromString(s);
        if (id != null) {
            return this.getPlayer(id);
        }
        if (s.equals(CommonUtils.FAKE_PLAYER_PROFILE.getName().toLowerCase())) {
            return this.fakePlayer;
        }
        for (ForgePlayer p : this.players.values()) {
            if (!p.func_176610_l().toLowerCase().equals(s)) continue;
            return p;
        }
        for (ForgePlayer p : this.players.values()) {
            if (!p.func_176610_l().toLowerCase().contains(s)) continue;
            return p;
        }
        return null;
    }

    public ForgePlayer getPlayer(ICommandSender sender) {
        if (sender instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)sender;
            if (ServerUtils.isFake(player)) {
                this.fakePlayer.entityPlayer = player;
                this.fakePlayer.clearCache();
                return this.fakePlayer;
            }
            return Objects.requireNonNull(this.getPlayer(player.func_146103_bH()));
        }
        throw new IllegalArgumentException("Sender is not a player!");
    }

    public ForgePlayer getPlayer(ForgePlayer player) {
        ForgePlayer p = this.getPlayer(player.getId());
        return p == null ? player : p;
    }

    @Nullable
    public ForgePlayer getPlayer(GameProfile profile) {
        ForgePlayer player = this.getPlayer(profile.getId());
        if (player == null && FTBLibConfig.general.merge_offline_mode_players.get(!this.server.func_71262_S()) && (player = this.getPlayer(profile.getName())) != null) {
            this.players.put(profile.getId(), player);
            player.markDirty();
        }
        return player;
    }

    public Collection<ForgeTeam> getTeams() {
        return this.teams.values();
    }

    public ForgeTeam getTeam(String id) {
        ForgeTeam team;
        ForgeTeam forgeTeam = team = id.isEmpty() ? null : this.teams.get(id);
        return team == null ? (id.equals("fakeplayer") ? this.fakePlayerTeam : this.noneTeam) : team;
    }

    public Collection<ForgePlayer> getOnlinePlayers() {
        Set<ForgePlayer> set = Collections.emptySet();
        for (ForgePlayer player : this.players.values()) {
            if (!player.isOnline()) continue;
            if (set.isEmpty()) {
                set = new HashSet<ForgePlayer>();
            }
            set.add(player);
        }
        return set;
    }

    @Override
    public void clearCache() {
        new UniverseClearCacheEvent(this).post();
        for (ForgeTeam team : this.teams.values()) {
            team.clearCache();
        }
        for (ForgePlayer player : this.players.values()) {
            player.clearCache();
        }
        this.fakePlayer.clearCache();
    }

    private static class PersistentScheduledTask {
        private final ResourceLocation id;
        private final TimeType type;
        private final long time;
        private final NBTTagCompound data;

        public PersistentScheduledTask(ResourceLocation i, TimeType tt, long t, NBTTagCompound d) {
            this.id = i;
            this.type = tt;
            this.time = t;
            this.data = d;
        }
    }

    private static class ScheduledTask {
        private final TimeType type;
        private final long time;
        private final IScheduledTask task;

        public ScheduledTask(TimeType tt, long t, IScheduledTask tk) {
            this.type = tt;
            this.time = t;
            this.task = tk;
        }
    }
}

