/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInfo;
import com.feed_the_beast.ftblib.lib.config.IGuiEditConfig;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.CommonUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftblib.lib.util.misc.NameMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.util.text.TextFormatting;

public class ConfigEnum<E>
extends ConfigValue {
    public static final String ID = "enum";
    public static final Color4I COLOR = Color4I.rgb(38143);
    private final NameMap<E> nameMap;
    private E value;

    public static <T extends Enum<T>> ConfigEnum<T> create(NameMap<T> nm, final Supplier<T> getter, final Consumer<T> setter) {
        return new ConfigEnum<T>(nm){

            @Override
            public T getValue() {
                return (Enum)getter.get();
            }

            @Override
            public void setValue(T e) {
                setter.accept(e);
            }
        };
    }

    public ConfigEnum(NameMap<E> nm) {
        this.nameMap = nm;
        this.value = nm.defaultValue;
    }

    public String func_176610_l() {
        return ID;
    }

    public NameMap<E> getNameMap() {
        return this.nameMap;
    }

    @Nonnull
    public E getValue() {
        return this.value;
    }

    public void setValue(E e) {
        this.value = e;
    }

    public void setValue(String value) {
        this.setValue(this.getNameMap().get(value));
    }

    @Override
    public String getString() {
        return this.getNameMap().getName(this.getValue());
    }

    @Override
    public String toString() {
        return this.getNameMap().getDisplayName(null, this.getValue()).func_150254_d();
    }

    @Override
    public boolean getBoolean() {
        return this.getValue() != this.getNameMap().defaultValue;
    }

    @Override
    public int getInt() {
        return this.getNameMap().getIndex(this.getValue());
    }

    @Override
    public ConfigEnum<E> copy() {
        return new ConfigEnum<E>(this.getNameMap().withDefault(this.getNameMap().get(this.getInt())));
    }

    @Override
    public Color4I getColor() {
        Color4I col = this.getNameMap().getColor(this.getValue());
        return col.isEmpty() ? COLOR : col;
    }

    @Override
    public void addInfo(ConfigValueInfo info, List<String> list) {
        list.add(TextFormatting.AQUA + "Def: " + this.getNameMap().getDisplayName(null, CommonUtils.cast(info.defaultValue.getValue())).func_150254_d());
    }

    @Override
    public List<String> getVariants() {
        return this.getNameMap().keys;
    }

    public void func_152753_a(JsonElement json) {
        this.setValue(json.getAsString());
    }

    public JsonElement func_151003_a() {
        return new JsonPrimitive(this.getString());
    }

    @Override
    public void writeData(DataOut data) {
        NameMap<E> nameMap = this.getNameMap();
        data.writeShort(nameMap.size());
        for (Map.Entry entry : nameMap.map.entrySet()) {
            data.writeString(entry.getKey());
            data.writeTextComponent(nameMap.getDisplayName(null, entry.getValue()));
            data.writeIcon(nameMap.getColor(entry.getValue()));
        }
        data.writeShort(nameMap.getIndex(this.getValue()));
    }

    @Override
    public void readData(DataIn data) {
        throw new IllegalStateException("Can't read Abstract Enum Property!");
    }

    public void onClicked(MouseButton button) {
        this.setValue(button.isLeft() ? this.getNameMap().getNext(this.getValue()) : this.getNameMap().getPrevious(this.getValue()));
    }

    @Override
    public void onClicked(IGuiEditConfig gui, ConfigValueInfo info, MouseButton button) {
        this.onClicked(button);
        gui.onChanged(info.id, this.func_151003_a());
    }
}

