/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.command;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.lib.command.CmdBase;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.Node;
import com.feed_the_beast.ftblib.lib.util.text_components.Notification;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public abstract class CmdEditConfigBase
extends CmdBase {
    public CmdEditConfigBase(String n, CmdBase.Level l) {
        super(n, l);
    }

    public abstract ConfigGroup getGroup(ICommandSender var1) throws CommandException;

    public IConfigCallback getCallback(ICommandSender sender) throws CommandException {
        return IConfigCallback.DEFAULT;
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        try {
            List<String> variants;
            ConfigValue entry;
            ConfigGroup group = this.getGroup(sender);
            if (args.length == 1) {
                List keys = CmdEditConfigBase.func_175762_a((String[])args, group.getMap().keySet());
                if (keys.size() > 1) {
                    keys.sort(StringUtils.ID_COMPARATOR);
                }
                return keys;
            }
            if (args.length == 2 && !(entry = group.get(Node.get(args[0]))).isNull() && !(variants = entry.getVariants()).isEmpty()) {
                return CmdEditConfigBase.func_175762_a((String[])args, variants);
            }
        }
        catch (CommandException commandException) {
            // empty catch block
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0 && sender instanceof EntityPlayerMP) {
            FTBLibAPI.editServerConfig(CmdEditConfigBase.func_71521_c((ICommandSender)sender), this.getGroup(sender), this.getCallback(sender));
            return;
        }
        this.checkArgs(sender, args, 1);
        Node node = Node.get(args[0]);
        ConfigGroup group = this.getGroup(sender);
        ConfigValue entry = group.get(node);
        if (entry.isNull()) {
            throw FTBLib.error(sender, "ftblib.lang.config_command.invalid_key", node.toString());
        }
        if (args.length >= 2) {
            String json = String.valueOf(StringUtils.joinSpaceUntilEnd(1, args));
            FTBLib.LOGGER.info("Setting " + node + " to " + json);
            try {
                JsonElement value = DataReader.get(JsonUtils.fixJsonString(json)).json();
                JsonObject json1 = new JsonObject();
                json1.add(node.toString(), value);
                this.getCallback(sender).saveConfig(group, sender, json1);
                ConfigValueInstance instance = group.getMap().get(node);
                Notification.of(Notification.VANILLA_STATUS, FTBLib.lang(sender, "ftblib.lang.config_command.set", group.getDisplayName(instance.info), group.get(node).toString())).send(server, (EntityPlayer)CmdEditConfigBase.func_71521_c((ICommandSender)sender));
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw FTBLib.error(sender, "error", ex.toString());
            }
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(String.valueOf(entry.func_151003_a())));
    }
}

