/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.grid.portable;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridTab;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.storage.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.IStorageDiskProvider;
import com.raoulvdberge.refinedstorage.api.storage.StorageDiskType;
import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.apiimpl.network.grid.handler.ItemGridHandlerPortable;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.diskdrive.NetworkNodeDiskDrive;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageCacheItemPortable;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageCacheListenerGridPortable;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageDiskItemPortable;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageTrackerItem;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFilter;
import com.raoulvdberge.refinedstorage.item.ItemWirelessGrid;
import com.raoulvdberge.refinedstorage.network.MessageGridSettingsUpdate;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class PortableGrid
implements IGrid,
IPortableGrid {
    public static int ID;
    public static final String NBT_STORAGE_TRACKER = "StorageTracker";
    @Nullable
    private IStorageDisk<ItemStack> storage;
    private StorageCacheItemPortable cache = new StorageCacheItemPortable(this);
    private ItemGridHandlerPortable handler = new ItemGridHandlerPortable(this, this);
    private EntityPlayer player;
    private ItemStack stack;
    private int sortingType;
    private int sortingDirection;
    private int searchBoxMode;
    private int tabSelected;
    private int tabPage;
    private int size;
    private StorageTrackerItem storageTracker = new StorageTrackerItem(() -> this.stack.func_77978_p().func_74782_a(NBT_STORAGE_TRACKER, (NBTBase)this.getStorageTracker().serializeNBT()));
    private List<IFilter> filters = new ArrayList<IFilter>();
    private List<IGridTab> tabs = new ArrayList<IGridTab>();
    private ItemHandlerFilter filter = new ItemHandlerFilter(this.filters, this.tabs, null){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (!PortableGrid.this.stack.func_77942_o()) {
                PortableGrid.this.stack.func_77982_d(new NBTTagCompound());
            }
            StackUtils.writeItems((IItemHandler)this, 0, PortableGrid.this.stack.func_77978_p());
        }
    };
    private ItemHandlerBase disk = new ItemHandlerBase(1, new Predicate[]{s -> NetworkNodeDiskDrive.VALIDATOR_STORAGE_DISK.test((ItemStack)s) && ((IStorageDiskProvider)s.func_77973_b()).create((ItemStack)s).getType() == StorageDiskType.ITEMS}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER || PortableGrid.this.player == null && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                if (this.getStackInSlot(slot).func_190926_b()) {
                    PortableGrid.this.storage = null;
                } else {
                    IStorageDiskProvider provider = (IStorageDiskProvider)this.getStackInSlot(slot).func_77973_b();
                    PortableGrid.this.storage = new StorageDiskItemPortable(provider.create(this.getStackInSlot(slot)), PortableGrid.this);
                    if (PortableGrid.this.player != null) {
                        PortableGrid.this.storage.readFromNBT();
                        PortableGrid.this.storage.onPassContainerContext(() -> {}, () -> false, () -> AccessType.INSERT_EXTRACT);
                    }
                }
                if (PortableGrid.this.player != null) {
                    PortableGrid.this.cache.invalidate();
                    StackUtils.writeItems((IItemHandler)this, 4, PortableGrid.this.stack.func_77978_p());
                }
            }
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (PortableGrid.this.storage != null) {
                PortableGrid.this.storage.writeToNBT();
            }
            return super.extractItem(slot, amount, simulate);
        }
    };

    public PortableGrid(@Nullable EntityPlayer player, ItemStack stack) {
        this.player = player;
        this.stack = stack;
        if (player != null) {
            this.sortingType = ItemWirelessGrid.getSortingType(stack);
            this.sortingDirection = ItemWirelessGrid.getSortingDirection(stack);
            this.searchBoxMode = ItemWirelessGrid.getSearchBoxMode(stack);
            this.tabSelected = ItemWirelessGrid.getTabSelected(stack);
            this.tabPage = ItemWirelessGrid.getTabPage(stack);
            this.size = ItemWirelessGrid.getSize(stack);
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (stack.func_77978_p().func_74764_b(NBT_STORAGE_TRACKER)) {
            this.storageTracker.readFromNBT(stack.func_77978_p().func_150295_c(NBT_STORAGE_TRACKER, 10));
        }
        if (player != null) {
            StackUtils.readItems((IItemHandlerModifiable)this.filter, 0, stack.func_77978_p());
        }
        StackUtils.readItems((IItemHandlerModifiable)this.disk, 4, stack.func_77978_p());
        if (player != null) {
            this.drainEnergy(RS.INSTANCE.config.portableGridOpenUsage);
            if (!player.func_130014_f_().field_72995_K && this.disk.getStackInSlot(0).func_190926_b()) {
                this.cache.invalidate();
            }
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public StorageCacheItemPortable getCache() {
        return this.cache;
    }

    @Override
    @Nullable
    public IStorageDisk<ItemStack> getStorage() {
        return this.storage;
    }

    @Override
    public void drainEnergy(int energy) {
        if (RS.INSTANCE.config.portableGridUsesEnergy && this.stack.func_77952_i() != 1) {
            ((IEnergyStorage)this.stack.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(energy, false);
        }
    }

    @Override
    public int getEnergy() {
        if (RS.INSTANCE.config.portableGridUsesEnergy && this.stack.func_77952_i() != 1) {
            return ((IEnergyStorage)this.stack.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored();
        }
        return 3200;
    }

    @Override
    public ItemHandlerBase getDisk() {
        return this.disk;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    public GridType getType() {
        return GridType.NORMAL;
    }

    @Override
    @Nullable
    public IStorageCache getStorageCache() {
        return this.storage != null ? this.cache : null;
    }

    @Override
    public IStorageCacheListener createListener(EntityPlayerMP player) {
        return new StorageCacheListenerGridPortable(this, player);
    }

    @Override
    @Nullable
    public IItemGridHandler getItemHandler() {
        return this.handler;
    }

    @Override
    @Nullable
    public IFluidGridHandler getFluidHandler() {
        return null;
    }

    @Override
    public String getGuiTitle() {
        return "gui.refinedstorage:portable_grid";
    }

    @Override
    public int getViewType() {
        return -1;
    }

    @Override
    public int getSortingType() {
        return this.sortingType;
    }

    @Override
    public int getSortingDirection() {
        return this.sortingDirection;
    }

    @Override
    public int getSearchBoxMode() {
        return this.searchBoxMode;
    }

    @Override
    public int getTabSelected() {
        return this.tabSelected;
    }

    @Override
    public int getTabPage() {
        return Math.min(this.tabPage, this.getTotalTabPages());
    }

    @Override
    public int getTotalTabPages() {
        return (int)Math.floor((float)Math.max(0, this.tabs.size() - 1) / 6.0f);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void onViewTypeChanged(int type) {
    }

    @Override
    public void onSortingTypeChanged(int type) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageGridSettingsUpdate(this.getViewType(), this.getSortingDirection(), type, this.getSearchBoxMode(), this.getSize(), this.getTabSelected(), this.getTabPage()));
        this.sortingType = type;
        GuiBase.executeLater(GuiGrid.class, grid -> grid.getView().sort());
    }

    @Override
    public void onSortingDirectionChanged(int direction) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageGridSettingsUpdate(this.getViewType(), direction, this.getSortingType(), this.getSearchBoxMode(), this.getSize(), this.getTabSelected(), this.getTabPage()));
        this.sortingDirection = direction;
        GuiBase.executeLater(GuiGrid.class, grid -> grid.getView().sort());
    }

    @Override
    public void onSearchBoxModeChanged(int searchBoxMode) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageGridSettingsUpdate(this.getViewType(), this.getSortingDirection(), this.getSortingType(), searchBoxMode, this.getSize(), this.getTabSelected(), this.getTabPage()));
        this.searchBoxMode = searchBoxMode;
    }

    @Override
    public void onSizeChanged(int size) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageGridSettingsUpdate(this.getViewType(), this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode(), size, this.getTabSelected(), this.getTabPage()));
        this.size = size;
        if (Minecraft.func_71410_x().field_71462_r != null) {
            Minecraft.func_71410_x().field_71462_r.func_73866_w_();
        }
    }

    @Override
    public void onTabSelectionChanged(int tab) {
        this.tabSelected = tab == this.tabSelected ? -1 : tab;
        RS.INSTANCE.network.sendToServer((IMessage)new MessageGridSettingsUpdate(this.getViewType(), this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode(), this.getSize(), this.tabSelected, this.getTabPage()));
        GuiBase.executeLater(GuiGrid.class, grid -> grid.getView().sort());
    }

    @Override
    public void onTabPageChanged(int page) {
        if (page >= 0 && page <= this.getTotalTabPages()) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageGridSettingsUpdate(this.getViewType(), this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode(), this.getSize(), this.getTabSelected(), page));
            this.tabPage = page;
        }
    }

    @Override
    public List<IFilter> getFilters() {
        return this.filters;
    }

    @Override
    public List<IGridTab> getTabs() {
        return this.tabs;
    }

    @Override
    public IItemHandlerModifiable getFilter() {
        return this.filter;
    }

    @Override
    public StorageTrackerItem getStorageTracker() {
        return this.storageTracker;
    }

    @Override
    public InventoryCrafting getCraftingMatrix() {
        return null;
    }

    @Override
    public InventoryCraftResult getCraftingResult() {
        return null;
    }

    @Override
    public void onCraftingMatrixChanged() {
    }

    @Override
    public void onCrafted(EntityPlayer player) {
    }

    @Override
    public void onCraftedShift(EntityPlayer player) {
    }

    @Override
    public void onRecipeTransfer(EntityPlayer player, ItemStack[][] recipe) {
    }

    @Override
    public void onClosed(EntityPlayer player) {
        if (!player.func_130014_f_().field_72995_K && this.storage != null) {
            this.storage.writeToNBT();
            StackUtils.writeItems((IItemHandler)this.disk, 4, this.stack.func_77978_p());
        }
    }

    @Override
    public boolean isActive() {
        if (RS.INSTANCE.config.portableGridUsesEnergy && this.stack.func_77952_i() != 1 && ((IEnergyStorage)this.stack.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored() <= RS.INSTANCE.config.portableGridOpenUsage) {
            return false;
        }
        return !this.disk.getStackInSlot(0).func_190926_b();
    }
}

