/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.craftingmonitor;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFilter;
import com.raoulvdberge.refinedstorage.item.ItemWirelessCraftingMonitor;
import com.raoulvdberge.refinedstorage.network.MessageWirelessCraftingMonitorViewAutomated;
import com.raoulvdberge.refinedstorage.tile.craftingmonitor.ICraftingMonitor;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class WirelessCraftingMonitor
implements ICraftingMonitor {
    private ItemStack stack;
    private int networkDimension;
    private BlockPos network;
    private boolean viewAutomated;
    private List<IFilter> filters = new ArrayList<IFilter>();
    private ItemHandlerFilter filter = new ItemHandlerFilter(this.filters, new ArrayList(), null){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (!WirelessCraftingMonitor.this.stack.func_77942_o()) {
                WirelessCraftingMonitor.this.stack.func_77982_d(new NBTTagCompound());
            }
            StackUtils.writeItems((IItemHandler)this, 0, WirelessCraftingMonitor.this.stack.func_77978_p());
            INetwork network = WirelessCraftingMonitor.this.getNetwork();
            if (network != null) {
                network.getCraftingManager().sendCraftingMonitorUpdate();
            }
        }
    };

    public WirelessCraftingMonitor(int networkDimension, ItemStack stack) {
        this.stack = stack;
        this.networkDimension = networkDimension;
        this.network = new BlockPos(ItemWirelessCraftingMonitor.getX(stack), ItemWirelessCraftingMonitor.getY(stack), ItemWirelessCraftingMonitor.getZ(stack));
        this.viewAutomated = ItemWirelessCraftingMonitor.canViewAutomated(stack);
        if (stack.func_77942_o()) {
            StackUtils.readItems((IItemHandlerModifiable)this.filter, 0, stack.func_77978_p());
        }
    }

    @Override
    public String getGuiTitle() {
        return "gui.refinedstorage:wireless_crafting_monitor";
    }

    @Override
    public void onCancelled(EntityPlayerMP player, int id) {
        INetwork network = this.getNetwork();
        if (network != null) {
            network.getItemGridHandler().onCraftingCancelRequested(player, id);
        }
    }

    @Override
    public TileDataParameter<Integer, ?> getRedstoneModeParameter() {
        return null;
    }

    @Override
    public BlockPos getNetworkPosition() {
        return this.network;
    }

    @Override
    public List<ICraftingTask> getTasks() {
        INetwork network = this.getNetwork();
        if (network != null) {
            return network.getCraftingManager().getTasks();
        }
        return Collections.emptyList();
    }

    @Override
    public List<IFilter> getFilters() {
        return this.filters;
    }

    @Override
    public ItemHandlerBase getFilter() {
        return this.filter;
    }

    @Override
    public boolean canViewAutomated() {
        return this.viewAutomated;
    }

    @Override
    public void onViewAutomatedChanged(boolean viewAutomated) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageWirelessCraftingMonitorViewAutomated(viewAutomated));
        this.viewAutomated = viewAutomated;
    }

    private INetwork getNetwork() {
        WorldServer world = DimensionManager.getWorld((int)this.networkDimension);
        if (world != null) {
            TileEntity tile = world.func_175625_s(this.network);
            return tile instanceof INetwork ? (INetwork)tile : null;
        }
        return null;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void onClosed(EntityPlayer player) {
        INetwork network = this.getNetwork();
        if (network != null) {
            network.getNetworkItemHandler().onClose(player);
        }
    }
}

