/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.container.ContainerGrid;
import com.raoulvdberge.refinedstorage.network.MessageHandlerPlayerToServer;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.IGuiIngredient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageGridTransfer
extends MessageHandlerPlayerToServer<MessageGridTransfer>
implements IMessage {
    private Map<Integer, ? extends IGuiIngredient<ItemStack>> inputs;
    private List<Slot> slots;
    private ItemStack[][] recipe = new ItemStack[9][];

    public MessageGridTransfer() {
    }

    public MessageGridTransfer(Map<Integer, ? extends IGuiIngredient<ItemStack>> inputs, List<Slot> slots) {
        this.inputs = inputs;
        this.slots = slots;
    }

    public void fromBytes(ByteBuf buf) {
        int slots = buf.readInt();
        for (int i = 0; i < slots; ++i) {
            int ingredients = buf.readInt();
            this.recipe[i] = new ItemStack[ingredients];
            for (int j = 0; j < ingredients; ++j) {
                this.recipe[i][j] = StackUtils.readItemStack(buf);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slots.size());
        for (Slot slot : this.slots) {
            IGuiIngredient<ItemStack> ingredient = this.inputs.get(slot.getSlotIndex() + 1);
            ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
            if (ingredient != null) {
                for (ItemStack possibleStack : ingredient.getAllIngredients()) {
                    if (possibleStack == null) continue;
                    ingredients.add(possibleStack);
                }
            }
            buf.writeInt(ingredients.size());
            for (ItemStack possibleStack : ingredients) {
                StackUtils.writeItemStack(buf, possibleStack);
            }
        }
    }

    @Override
    public void handle(MessageGridTransfer message, EntityPlayerMP player) {
        IGrid grid;
        if (player.field_71070_bA instanceof ContainerGrid && ((grid = ((ContainerGrid)player.field_71070_bA).getGrid()).getType() == GridType.CRAFTING || grid.getType() == GridType.PATTERN)) {
            grid.onRecipeTransfer((EntityPlayer)player, message.recipe);
        }
    }
}

