/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.IStorageTracker;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageTrackerEntry;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackFluid;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageGridFluidUpdate
implements IMessage,
IMessageHandler<MessageGridFluidUpdate, IMessage> {
    private INetwork network;
    private boolean canCraft;
    private List<IGridStack> stacks = new ArrayList<IGridStack>();

    public MessageGridFluidUpdate() {
    }

    public MessageGridFluidUpdate(INetwork network, boolean canCraft) {
        this.network = network;
        this.canCraft = canCraft;
    }

    public void fromBytes(ByteBuf buf) {
        this.canCraft = buf.readBoolean();
        int items = buf.readInt();
        for (int i = 0; i < items; ++i) {
            this.stacks.add(new GridStackFluid(StackUtils.readFluidStack(buf), buf.readBoolean() ? new StorageTrackerEntry(buf) : null));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.canCraft);
        buf.writeInt(this.network.getFluidStorageCache().getList().getStacks().size());
        for (FluidStack stack : this.network.getFluidStorageCache().getList().getStacks()) {
            StackUtils.writeFluidStack(buf, stack);
            IStorageTracker.IStorageTrackerEntry entry = this.network.getFluidStorageTracker().get(stack);
            buf.writeBoolean(entry != null);
            if (entry == null) continue;
            buf.writeLong(entry.getTime());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getName());
        }
    }

    public IMessage onMessage(MessageGridFluidUpdate message, MessageContext ctx) {
        GuiBase.executeLater(GuiGrid.class, grid -> {
            grid.getView().setCanCraft(message.canCraft);
            grid.getView().setStacks(message.stacks);
            grid.getView().sort();
        });
        return null;
    }
}

