/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.integration.projecte;

import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.externalstorage.NetworkNodeExternalStorage;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.externalstorage.StorageItemExternal;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class StorageItemTransmutationTable
extends StorageItemExternal {
    private NetworkNodeExternalStorage externalStorage;

    public StorageItemTransmutationTable(NetworkNodeExternalStorage externalStorage) {
        this.externalStorage = externalStorage;
    }

    @Override
    public int getCapacity() {
        return 0;
    }

    @Override
    public Collection<ItemStack> getStacks() {
        IKnowledgeProvider provider;
        if (this.externalStorage.getOwner() != null && !(provider = ProjectEAPI.getTransmutationProxy().getKnowledgeProviderFor(this.externalStorage.getOwner())).getClass().getName().equals("moze_intel.projecte.impl.TransmutationOffline$1")) {
            LinkedList<ItemStack> stored = new LinkedList<ItemStack>();
            for (ItemStack knowledge : provider.getKnowledge()) {
                stored.add(ItemHandlerHelper.copyStackWithSize((ItemStack)knowledge, (int)((int)Math.floor(provider.getEmc() / (double)ProjectEAPI.getEMCProxy().getValue(knowledge)))));
            }
            return stored;
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public ItemStack insert(@Nonnull ItemStack stack, int size, boolean simulate) {
        IKnowledgeProvider provider;
        ItemStack actualStack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
        if (this.externalStorage.getOwner() != null && !(provider = ProjectEAPI.getTransmutationProxy().getKnowledgeProviderFor(this.externalStorage.getOwner())).getClass().getName().equals("moze_intel.projecte.impl.TransmutationOffline$1")) {
            int emc = ProjectEAPI.getEMCProxy().getValue(actualStack) * size;
            if (emc == 0) {
                return actualStack;
            }
            if (!simulate) {
                provider.setEmc(provider.getEmc() + (double)emc);
                this.handleKnowledge(provider, stack.func_77946_l());
                EntityPlayer player = this.externalStorage.getWorld().func_152378_a(this.externalStorage.getOwner());
                if (player != null) {
                    provider.sync((EntityPlayerMP)player);
                }
            }
            return null;
        }
        return actualStack;
    }

    private void handleKnowledge(IKnowledgeProvider provider, ItemStack stack) {
        if (stack.func_190916_E() > 1) {
            stack.func_190920_e(1);
        }
        if (!stack.func_77981_g() && stack.func_77958_k() != 0) {
            stack.func_77964_b(0);
        }
        if (!provider.hasKnowledge(stack)) {
            stack.func_77982_d(null);
            provider.addKnowledge(stack);
        }
    }

    @Override
    @Nullable
    public ItemStack extract(@Nonnull ItemStack stack, int size, int flags, boolean simulate) {
        IKnowledgeProvider provider;
        if (this.externalStorage.getOwner() != null && !(provider = ProjectEAPI.getTransmutationProxy().getKnowledgeProviderFor(this.externalStorage.getOwner())).getClass().getName().equals("moze_intel.projecte.impl.TransmutationOffline$1") && provider.hasKnowledge(stack)) {
            double singleEmc = ProjectEAPI.getEMCProxy().getValue(stack);
            if (singleEmc == 0.0) {
                return null;
            }
            int maxExtract = (int)Math.floor(provider.getEmc() / singleEmc);
            if (size > maxExtract) {
                size = maxExtract;
            }
            if (size <= 0) {
                return null;
            }
            ItemStack result = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
            if (!simulate) {
                provider.setEmc(provider.getEmc() - singleEmc * (double)size);
                EntityPlayer player = this.externalStorage.getWorld().func_152378_a(this.externalStorage.getOwner());
                if (player != null) {
                    provider.sync((EntityPlayerMP)player);
                }
            }
            return result;
        }
        return null;
    }

    @Override
    public int getStored() {
        return 0;
    }

    @Override
    public int getPriority() {
        return this.externalStorage.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.externalStorage.getAccessType();
    }
}

